/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.api.jdo.query;

import java.util.Iterator;
import java.util.List;
import javax.jdo.PersistenceManager;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ExecutionContext;
import org.datanucleus.api.jdo.JDOPersistenceManager;
import org.datanucleus.api.jdo.query.BooleanExpressionImpl;
import org.datanucleus.api.jdo.query.ExpressionImpl;
import org.datanucleus.api.jdo.query.OrderExpressionImpl;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.query.compiler.JDOQLSymbolResolver;
import org.datanucleus.query.compiler.QueryCompilation;
import org.datanucleus.query.expression.DyadicExpression;
import org.datanucleus.query.expression.Expression;
import org.datanucleus.query.expression.OrderExpression;
import org.datanucleus.query.expression.PrimaryExpression;
import org.datanucleus.query.symbol.PropertySymbol;
import org.datanucleus.query.symbol.Symbol;
import org.datanucleus.query.symbol.SymbolResolver;
import org.datanucleus.query.symbol.SymbolTable;
import org.datanucleus.query.typesafe.OrderExpression;

public abstract class AbstractTypesafeQuery<T> {
    protected QueryType type = QueryType.SELECT;
    protected Class candidateCls;
    protected String candidateAlias = null;
    protected List<ExpressionImpl> updateExprs;
    protected List<ExpressionImpl> updateVals;
    protected List<ExpressionImpl> result;
    protected Boolean resultDistinct = null;
    protected BooleanExpressionImpl filter;
    protected List<ExpressionImpl> grouping;
    protected ExpressionImpl having;
    protected List<OrderExpressionImpl> ordering;
    protected PersistenceManager pm;
    protected ExecutionContext ec;
    QueryCompilation compilation = null;

    public AbstractTypesafeQuery(PersistenceManager pm, Class<T> cls, String alias) {
        this.pm = pm;
        this.ec = ((JDOPersistenceManager)pm).getExecutionContext();
        this.candidateCls = cls;
        this.candidateAlias = alias;
    }

    protected void discardCompiled() {
        this.compilation = null;
    }

    protected QueryCompilation compile(MetaDataManager mmgr, ClassLoaderResolver clr) {
        SymbolTable symtbl = new SymbolTable();
        symtbl.setSymbolResolver((SymbolResolver)new JDOQLSymbolResolver(mmgr, clr, symtbl, this.candidateCls, this.candidateAlias));
        symtbl.addSymbol((Symbol)new PropertySymbol(this.candidateAlias, this.candidateCls));
        Expression[] resultExprs = null;
        if (this.result != null && !this.result.isEmpty()) {
            String resultExprId;
            resultExprs = new Expression[this.result.size()];
            Iterator<ExpressionImpl> iter = this.result.iterator();
            int i = 0;
            while (iter.hasNext()) {
                ExpressionImpl result = iter.next();
                Expression resultExpr = result.getQueryExpression();
                resultExpr.bind(symtbl);
                resultExprs[i++] = resultExpr;
            }
            if (resultExprs.length == 1 && resultExprs[0] instanceof PrimaryExpression && (resultExprId = ((PrimaryExpression)resultExprs[0]).getId()).equalsIgnoreCase(this.candidateAlias)) {
                resultExprs = null;
            }
        }
        Expression filterExpr = null;
        if (this.filter != null && (filterExpr = this.filter.getQueryExpression()) != null) {
            filterExpr.bind(symtbl);
        }
        Expression[] groupingExprs = null;
        if (this.grouping != null && !this.grouping.isEmpty()) {
            groupingExprs = new Expression[this.grouping.size()];
            Iterator<ExpressionImpl> iter = this.grouping.iterator();
            int i = 0;
            while (iter.hasNext()) {
                ExpressionImpl grp = iter.next();
                Expression groupingExpr = grp.getQueryExpression();
                groupingExpr.bind(symtbl);
                groupingExprs[i++] = groupingExpr;
            }
        }
        Expression havingExpr = null;
        if (this.having != null) {
            havingExpr = this.having.getQueryExpression();
            havingExpr.bind(symtbl);
        }
        Expression[] orderExprs = null;
        if (this.ordering != null && !this.ordering.isEmpty()) {
            orderExprs = new Expression[this.ordering.size()];
            Iterator<OrderExpressionImpl> iter = this.ordering.iterator();
            int i = 0;
            while (iter.hasNext()) {
                OrderExpressionImpl order = iter.next();
                OrderExpression orderExpr = new OrderExpression(((ExpressionImpl)order.getExpression()).getQueryExpression(), order.getDirection() == OrderExpression.OrderDirection.ASC ? "ascending" : "descending");
                orderExpr.bind(symtbl);
                orderExprs[i++] = orderExpr;
            }
        }
        Expression[] updateExprs = null;
        if (this.updateExprs != null) {
            Iterator<ExpressionImpl> expIter = this.updateExprs.iterator();
            Iterator<ExpressionImpl> valIter = this.updateVals.iterator();
            updateExprs = new Expression[this.updateExprs.size()];
            int i = 0;
            while (expIter.hasNext()) {
                ExpressionImpl updateExpr = expIter.next();
                ExpressionImpl updateVal = valIter.next();
                updateExprs[i++] = new DyadicExpression(updateExpr.getQueryExpression(), Expression.OP_EQ, updateVal.getQueryExpression());
            }
        }
        this.compilation = new QueryCompilation(this.candidateCls, this.candidateAlias, symtbl, resultExprs, null, filterExpr, groupingExprs, havingExpr, orderExprs, updateExprs);
        this.compilation.setQueryLanguage("JDOQL");
        return this.compilation;
    }

    public QueryCompilation getCompilation() {
        if (this.compilation == null) {
            this.compilation = this.compile(this.ec.getMetaDataManager(), this.ec.getClassLoaderResolver());
        }
        return this.compilation;
    }

    static enum QueryType {
        SELECT,
        BULK_UPDATE,
        BULK_DELETE;

    }
}

