/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.clients.stubs.jaxws;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.xml.ws.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class StubCache {
    private static final Logger log = LoggerFactory.getLogger(StubCache.class);
    private volatile LRUCache cache = new LRUCache();
    private ConcurrentHashMap<Class<?>, Lock> nameLocks = new ConcurrentHashMap();

    StubCache() {
    }

    void clear(Class<?> name) {
        Lock nameLock = this.lockFor(name);
        nameLock.lock();
        try {
            this.cache.remove(name);
        }
        finally {
            nameLock.unlock();
        }
    }

    Service get(Class<?> type, Callable<Service> task) {
        Lock nameLock = this.lockFor(type);
        nameLock.lock();
        try {
            Service service = (Service)this.cache.get(type);
            if (service == null) {
                try {
                    service = task.call();
                    log.info("caching stub for " + type);
                    this.cache.put(type, service);
                }
                catch (Exception e) {
                    throw new RuntimeException("could not build service", e);
                }
            } else {
                log.info("using cached stub for " + type);
            }
            Service service2 = service;
            return service2;
        }
        finally {
            nameLock.unlock();
        }
    }

    private Lock lockFor(Class<?> name) {
        Lock nameLock = this.nameLocks.get(name);
        if (nameLock == null) {
            ReentrantLock newLock = new ReentrantLock();
            nameLock = this.nameLocks.putIfAbsent(name, newLock);
            nameLock = nameLock == null ? newLock : nameLock;
        }
        return nameLock;
    }

    private class LRUCache
    extends LinkedHashMap<Class<?>, Service> {
        private static final long serialVersionUID = 1L;
        public static final int max = 50;

        public LRUCache() {
            super(16, 0.75f, true);
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<Class<?>, Service> eldest) {
            if (this.size() >= 50) {
                StubCache.this.nameLocks.remove(eldest.getKey());
                return true;
            }
            return false;
        }
    }
}

