/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.schemaframework;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.eis.EISDescriptor;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.databaseaccess.DatabasePlatform;
import org.eclipse.persistence.internal.descriptors.FieldTransformation;
import org.eclipse.persistence.internal.descriptors.MethodBasedFieldTransformation;
import org.eclipse.persistence.internal.descriptors.TransformerBasedFieldTransformation;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.ConversionManager;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.queries.MappedKeyMapContainerPolicy;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.DatabaseSessionImpl;
import org.eclipse.persistence.logging.AbstractSessionLog;
import org.eclipse.persistence.mappings.AggregateCollectionMapping;
import org.eclipse.persistence.mappings.AggregateObjectMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.DirectCollectionMapping;
import org.eclipse.persistence.mappings.DirectMapMapping;
import org.eclipse.persistence.mappings.DirectToFieldMapping;
import org.eclipse.persistence.mappings.ManyToManyMapping;
import org.eclipse.persistence.mappings.OneToManyMapping;
import org.eclipse.persistence.mappings.OneToOneMapping;
import org.eclipse.persistence.mappings.RelationTableMechanism;
import org.eclipse.persistence.mappings.TransformationMapping;
import org.eclipse.persistence.mappings.converters.Converter;
import org.eclipse.persistence.mappings.converters.SerializedObjectConverter;
import org.eclipse.persistence.mappings.converters.TypeConversionConverter;
import org.eclipse.persistence.mappings.structures.ObjectRelationalDataTypeDescriptor;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.sequencing.DefaultSequence;
import org.eclipse.persistence.sequencing.NativeSequence;
import org.eclipse.persistence.sequencing.Sequence;
import org.eclipse.persistence.sessions.DatabaseLogin;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.server.ServerSession;
import org.eclipse.persistence.tools.schemaframework.FieldDefinition;
import org.eclipse.persistence.tools.schemaframework.ForeignKeyConstraint;
import org.eclipse.persistence.tools.schemaframework.TableCreator;
import org.eclipse.persistence.tools.schemaframework.TableDefinition;
import org.eclipse.persistence.tools.schemaframework.UniqueKeyConstraint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultTableGenerator {
    Project project = null;
    private DatabasePlatform databasePlatform;
    private Map<String, TableDefinition> tableMap = null;
    private Map<DatabaseField, FieldDefinition> fieldMap = null;
    private Map<DatabaseField, DatabaseField> databaseFields;
    protected boolean generateFKConstraints = true;

    public DefaultTableGenerator(Project project) {
        this.project = project;
        if (project.getDatasourceLogin().getDatasourcePlatform() instanceof DatabasePlatform) {
            this.databasePlatform = (DatabasePlatform)project.getDatasourceLogin().getDatasourcePlatform();
        }
        this.tableMap = new HashMap<String, TableDefinition>();
        this.fieldMap = new HashMap<DatabaseField, FieldDefinition>();
        this.databaseFields = new HashMap<DatabaseField, DatabaseField>();
    }

    public DefaultTableGenerator(Project project, boolean generateFKConstraints) {
        this(project);
        this.generateFKConstraints = generateFKConstraints;
    }

    public TableCreator generateDefaultTableCreator() {
        TableCreator tblCreator = new TableCreator();
        for (ClassDescriptor desc : this.project.getDescriptors().values()) {
            if (desc instanceof XMLDescriptor || desc instanceof EISDescriptor || desc instanceof ObjectRelationalDataTypeDescriptor) {
                AbstractSessionLog.getLog().log(6, "relational_descriptor_support_only", null, true);
                return tblCreator;
            }
            if (desc.isAggregateDescriptor() || desc.isAggregateCollectionDescriptor()) continue;
            this.initTableSchema(desc);
        }
        for (ClassDescriptor desc : this.project.getOrderedDescriptors()) {
            if (desc.isAggregateDescriptor() || desc.isAggregateCollectionDescriptor()) continue;
            this.postInitTableSchema(desc);
        }
        tblCreator.addTableDefinitions(this.tableMap.values());
        return tblCreator;
    }

    public TableCreator generateFilteredDefaultTableCreator(AbstractSession session) throws DatabaseException {
        TableCreator tblCreator = this.generateDefaultTableCreator();
        try {
            Connection conn = null;
            if (session.isServerSession()) {
                conn = ((ServerSession)session).getDefaultConnectionPool().acquireConnection().getConnection();
            } else if (session.isDatabaseSession()) {
                conn = ((DatabaseSessionImpl)session).getAccessor().getConnection();
            }
            if (conn == null) {
                return tblCreator;
            }
            DatabaseMetaData dbMetaData = conn.getMetaData();
            ResultSet resultSet = dbMetaData.getTables(null, dbMetaData.getUserName(), null, new String[]{"TABLE"});
            ArrayList<String> tablesInDatabase = new ArrayList<String>();
            while (resultSet.next()) {
                tablesInDatabase.add(resultSet.getString("TABLE_NAME"));
            }
            resultSet.close();
            ArrayList<TableDefinition> existedTables = new ArrayList<TableDefinition>();
            ArrayList<String> existedTableNames = new ArrayList<String>();
            for (TableDefinition tblDef : tblCreator.getTableDefinitions()) {
                if (!tablesInDatabase.contains(tblDef.getFullName())) continue;
                existedTables.add(tblDef);
                existedTableNames.add(tblDef.getFullName());
            }
            if (!existedTableNames.isEmpty()) {
                session.getSessionLog().log(1, "skip_create_existing_tables", existedTableNames);
                tblCreator.getTableDefinitions().removeAll(existedTables);
            }
        }
        catch (SQLException sqlEx) {
            throw DatabaseException.errorRetrieveDbMetadataThroughJDBCConnection();
        }
        return tblCreator;
    }

    protected void initTableSchema(ClassDescriptor desc) {
        TableDefinition tblDef = null;
        DatabaseTable dbTbl2 = null;
        for (DatabaseTable dbTbl2 : desc.getTables()) {
            tblDef = this.getTableDefFromDBTable(dbTbl2);
        }
        Iterator<DatabaseField> fieldIter = desc.getFields().iterator();
        DatabaseField dbField = null;
        while (fieldIter.hasNext()) {
            dbField = fieldIter.next();
            boolean isPKField = false;
            isPKField = desc.getPrimaryKeyFields().contains(dbField);
            Map<DatabaseField, DatabaseField> secondaryKeyMap = desc.getAdditionalTablePrimaryKeyFields().get(dbField.getTable());
            if (secondaryKeyMap != null) {
                isPKField = isPKField || secondaryKeyMap.containsValue(dbField);
            }
            FieldDefinition fieldDef = this.getFieldDefFromDBField(dbField, isPKField);
            if (isPKField) {
                String sequenceName = desc.getSequenceNumberName();
                DatabaseLogin login = this.project.getLogin();
                Sequence seq = login.getSequence(sequenceName);
                if (seq instanceof DefaultSequence) {
                    seq = login.getDefaultSequence();
                }
                boolean isIdentity = seq instanceof NativeSequence && seq.shouldAcquireValueAfterInsert();
                fieldDef.setIsIdentity(isIdentity);
            }
            if ((tblDef = this.tableMap.get(dbField.getTableName())).getFields().contains(fieldDef)) continue;
            tblDef.addField(fieldDef);
        }
    }

    private void postInitTableSchema(ClassDescriptor desc) {
        for (DatabaseMapping mapping : desc.getMappings()) {
            if (desc.isChildDescriptor() && desc.getInheritancePolicy().getParentDescriptor().getMappingForAttributeName(mapping.getAttributeName()) != null) continue;
            if (mapping.isManyToManyMapping()) {
                this.buildRelationTableDefinition(((ManyToManyMapping)mapping).getRelationTableMechanism(), ((ManyToManyMapping)mapping).getListOrderField(), mapping.getContainerPolicy());
                continue;
            }
            if (mapping.isDirectCollectionMapping()) {
                this.buildDirectCollectionTableDefinition((DirectCollectionMapping)mapping, desc);
                continue;
            }
            if (mapping.isDirectToFieldMapping()) {
                Converter converter = ((DirectToFieldMapping)mapping).getConverter();
                if (converter == null) continue;
                if (converter instanceof TypeConversionConverter) {
                    this.resetFieldTypeForLOB((DirectToFieldMapping)mapping);
                }
                if (!(converter instanceof SerializedObjectConverter)) continue;
                this.getFieldDefFromDBField(mapping.getField(), false).setType(Byte[].class);
                continue;
            }
            if (mapping.isAggregateCollectionMapping()) {
                this.createAggregateTargetTable((AggregateCollectionMapping)mapping);
                continue;
            }
            if (mapping.isForeignReferenceMapping()) {
                if (mapping.isOneToOneMapping()) {
                    RelationTableMechanism relationTableMechanism = ((OneToOneMapping)mapping).getRelationTableMechanism();
                    if (relationTableMechanism == null) {
                        this.addForeignKeyFieldToSourceTargetTable((OneToOneMapping)mapping);
                        continue;
                    }
                    this.buildRelationTableDefinition(relationTableMechanism, null, null);
                    continue;
                }
                if (!mapping.isOneToManyMapping()) continue;
                this.addForeignKeyFieldToSourceTargetTable((OneToManyMapping)mapping);
                TableDefinition targTblDef = this.getTableDefFromDBTable(((OneToManyMapping)mapping).getReferenceDescriptor().getDefaultTable());
                this.addFieldsForMappedKeyMapContainerPolicy(mapping.getContainerPolicy(), targTblDef);
                continue;
            }
            if (mapping.isTransformationMapping()) {
                this.resetTransformedFieldType((TransformationMapping)mapping);
                continue;
            }
            if (!mapping.isAggregateObjectMapping()) continue;
            this.postInitTableSchema(((AggregateObjectMapping)mapping).getReferenceDescriptor());
        }
        this.processAdditionalTablePkFields(desc);
    }

    private void addFieldsForMappedKeyMapContainerPolicy(ContainerPolicy cp, TableDefinition tblDef) {
        if (cp.isMappedKeyMapPolicy()) {
            List<DatabaseField> keyFields = cp.getIdentityFieldsForMapKey();
            for (DatabaseField foreignKey : keyFields) {
                FieldDefinition fieldDef = this.getFieldDefFromDBField(foreignKey, false);
                if (tblDef.getFields().contains(fieldDef)) continue;
                tblDef.addField(this.getFieldDefFromDBField(foreignKey, false));
            }
            Map<DatabaseField, DatabaseField> foreignKeys = ((MappedKeyMapContainerPolicy)cp).getForeignKeyFieldsForMapKey();
            if (foreignKeys != null) {
                this.addForeignMappingFkConstraint(foreignKeys);
            }
        }
    }

    private void buildRelationTableDefinition(RelationTableMechanism relationTableMechanism, DatabaseField listOrderField, ContainerPolicy cp) {
        TableDefinition tblDef = this.getTableDefFromDBTable(relationTableMechanism.getRelationTable());
        Vector<DatabaseField> srcFkFields = relationTableMechanism.getSourceRelationKeyFields();
        Vector<DatabaseField> srcKeyFields = relationTableMechanism.getSourceKeyFields();
        this.buildRelationTableFields(tblDef, srcFkFields, srcKeyFields);
        Vector<DatabaseField> targFkFields = relationTableMechanism.getTargetRelationKeyFields();
        Vector<DatabaseField> targKeyFields = relationTableMechanism.getTargetKeyFields();
        this.buildRelationTableFields(tblDef, targFkFields, targKeyFields);
        if (cp != null) {
            this.addFieldsForMappedKeyMapContainerPolicy(cp, tblDef);
        }
        if (listOrderField != null) {
            tblDef.addField(this.getFieldDefFromDBField(listOrderField, false));
        }
    }

    private void buildRelationTableFields(TableDefinition tblDef, Vector fkFields, Vector targetFields) {
        assert (fkFields.size() > 0 && fkFields.size() == targetFields.size());
        DatabaseField fkField = null;
        DatabaseField targetField = null;
        Vector<String> fkFieldNames = new Vector<String>();
        Vector<String> targetFieldNames = new Vector<String>();
        for (int index = 0; index < fkFields.size(); ++index) {
            fkField = (DatabaseField)fkFields.get(index);
            targetField = (DatabaseField)targetFields.get(index);
            fkFieldNames.add(fkField.getNameDelimited(this.databasePlatform));
            targetFieldNames.add(targetField.getNameDelimited(this.databasePlatform));
            fkField = this.resolveDatabaseField(fkField, targetField);
            this.setFieldToRelationTable(fkField, tblDef);
        }
        DatabaseTable targetTable = targetField.getTable();
        TableDefinition targetTblDef = this.getTableDefFromDBTable(targetTable);
        this.addForeignKeyConstraint(tblDef, targetTblDef, fkFieldNames, targetFieldNames);
    }

    private void buildDirectCollectionTableDefinition(DirectCollectionMapping mapping, ClassDescriptor desc) {
        TableDefinition tblDef = this.getTableDefFromDBTable(mapping.getReferenceTable());
        DatabaseField dbField = null;
        Vector<DatabaseField> refPkFields = mapping.getReferenceKeyFields();
        for (int index = 0; index < refPkFields.size(); ++index) {
            dbField = this.resolveDatabaseField(refPkFields.get(index), mapping.getSourceKeyFields().get(index));
            tblDef.addField(this.getDirectCollectionReferenceKeyFieldDefFromDBField(dbField));
        }
        tblDef.addField(this.getFieldDefFromDBField(mapping.getDirectField(), false));
        if (mapping.isDirectMapMapping() && !mapping.getContainerPolicy().isMappedKeyMapPolicy()) {
            dbField = ((DirectMapMapping)mapping).getDirectKeyField();
            tblDef.addField(this.getFieldDefFromDBField(dbField, false));
        } else {
            this.addFieldsForMappedKeyMapContainerPolicy(mapping.getContainerPolicy(), tblDef);
            if (mapping.getListOrderField() != null) {
                tblDef.addField(this.getFieldDefFromDBField(mapping.getListOrderField(), false));
            }
        }
    }

    private void resetFieldTypeForLOB(DirectToFieldMapping mapping) {
        if (mapping.getFieldClassification().getName().equals("java.sql.Blob")) {
            this.getFieldDefFromDBField(mapping.getField(), false).setType(Byte[].class);
        } else if (mapping.getFieldClassification().getName().equals("java.sql.Clob")) {
            this.getFieldDefFromDBField(mapping.getField(), false).setType(Character[].class);
        }
    }

    private void resetTransformedFieldType(TransformationMapping mapping) {
        for (FieldTransformation transformation : mapping.getFieldTransformations()) {
            if (transformation instanceof MethodBasedFieldTransformation) {
                MethodBasedFieldTransformation methodTransformation = (MethodBasedFieldTransformation)transformation;
                try {
                    Class<?> returnType = Helper.getDeclaredMethod(mapping.getDescriptor().getJavaClass(), methodTransformation.getMethodName(), null).getReturnType();
                    this.getFieldDefFromDBField(methodTransformation.getField(), false).setType(returnType);
                }
                catch (NoSuchMethodException ex) {}
                continue;
            }
            TransformerBasedFieldTransformation classTransformation = (TransformerBasedFieldTransformation)transformation;
            String methodName = "buildFieldValue";
            Class[] params = new Class[]{Object.class, String.class, Session.class};
            try {
                Class<?> returnType = Helper.getDeclaredMethod(classTransformation.getTransformerClass(), methodName, params).getReturnType();
                if (returnType.equals(Object.class)) {
                    throw ValidationException.missingFieldTypeForDDLGenerationOfClassTransformation(mapping.getDescriptor(), mapping.getAttributeName(), methodName);
                }
                this.getFieldDefFromDBField(classTransformation.getField(), false).setType(returnType);
            }
            catch (NoSuchMethodException ex) {
                throw ValidationException.missingTransformerMethodForDDLGenerationOfClassTransformation(mapping.getDescriptor(), mapping.getAttributeName(), methodName);
            }
        }
    }

    private void createAggregateTargetTable(AggregateCollectionMapping mapping) {
        TableDefinition targTblDef = this.getTableDefFromDBTable(mapping.getReferenceDescriptor().getDefaultTable());
        this.addFieldsForMappedKeyMapContainerPolicy(mapping.getContainerPolicy(), targTblDef);
        for (DatabaseField dbField : mapping.getReferenceDescriptor().getFields()) {
            targTblDef.addField(this.getFieldDefFromDBField(dbField, false));
        }
        for (DatabaseField dbField : mapping.getTargetForeignKeyFields()) {
            targTblDef.addField(this.getFieldDefFromDBField(dbField, false));
        }
        if (mapping.getListOrderField() != null) {
            this.getTableDefFromDBTable(mapping.getListOrderField().getTable()).addField(this.getFieldDefFromDBField(mapping.getListOrderField(), false));
        }
    }

    private void addForeignKeyFieldToSourceTargetTable(OneToOneMapping mapping) {
        if (!mapping.isForeignKeyRelationship()) {
            return;
        }
        this.addForeignMappingFkConstraint(mapping.getSourceToTargetKeyFields());
    }

    private void addForeignKeyFieldToSourceTargetTable(OneToManyMapping mapping) {
        this.addForeignMappingFkConstraint(mapping.getTargetForeignKeysToSourceKeys());
        if (mapping.getListOrderField() != null) {
            this.getTableDefFromDBTable(mapping.getListOrderField().getTable()).addField(this.getFieldDefFromDBField(mapping.getListOrderField(), false));
        }
    }

    private void addForeignMappingFkConstraint(Map<DatabaseField, DatabaseField> srcFields) {
        if (srcFields.size() == 0) {
            return;
        }
        Vector<DatabaseField> fkFields = new Vector<DatabaseField>();
        Vector<DatabaseField> targetFields = new Vector<DatabaseField>();
        for (DatabaseField fkField : srcFields.keySet()) {
            fkFields.add(fkField);
            targetFields.add(srcFields.get(fkField));
        }
        this.addJoinColumnsFkConstraint(fkFields, targetFields);
    }

    private TableDefinition getTableDefFromDBTable(DatabaseTable dbTbl) {
        TableDefinition tblDef = this.tableMap.get(dbTbl.getName());
        if (tblDef == null) {
            tblDef = new TableDefinition();
            tblDef.setName(dbTbl.getNameDelimited(this.databasePlatform));
            tblDef.setQualifier(dbTbl.getTableQualifier());
            this.addUniqueKeyConstraints(tblDef, dbTbl.getUniqueConstraints());
            this.tableMap.put(dbTbl.getName(), tblDef);
        }
        return tblDef;
    }

    private DatabaseField resolveDatabaseField(DatabaseField childField, DatabaseField parentField) {
        DatabaseField resolvedDatabaseField = new DatabaseField();
        DatabaseField resolvedParentField = this.databaseFields.get(parentField);
        resolvedDatabaseField.setName(childField.getName());
        resolvedDatabaseField.setTable(childField.getTable());
        if (resolvedParentField != null) {
            resolvedDatabaseField.setType(resolvedParentField.getType());
            resolvedDatabaseField.setScale(resolvedParentField.getScale());
            resolvedDatabaseField.setLength(resolvedParentField.getLength());
            resolvedDatabaseField.setPrecision(resolvedParentField.getPrecision());
        }
        resolvedDatabaseField.setUnique(childField.isUnique());
        resolvedDatabaseField.setNullable(childField.isNullable());
        resolvedDatabaseField.setUpdatable(childField.isUpdatable());
        resolvedDatabaseField.setInsertable(childField.isInsertable());
        resolvedDatabaseField.setUseDelimiters(childField.shouldUseDelimiters());
        String columnDef = childField.getColumnDefinition();
        if (columnDef == null || columnDef.trim().equals("")) {
            if (resolvedParentField != null) {
                resolvedDatabaseField.setColumnDefinition(resolvedParentField.getColumnDefinition());
            }
        } else {
            resolvedDatabaseField.setColumnDefinition(columnDef);
        }
        return resolvedDatabaseField;
    }

    private FieldDefinition getFieldDefFromDBField(DatabaseField dbField, boolean isPrimaryKey) {
        FieldDefinition fieldDef = this.fieldMap.get(dbField);
        if (fieldDef == null) {
            fieldDef = new FieldDefinition();
            fieldDef.setName(dbField.getNameDelimited(this.databasePlatform));
            if (dbField.getColumnDefinition() != null && dbField.getColumnDefinition().length() > 0) {
                fieldDef.setTypeDefinition(dbField.getColumnDefinition());
            } else {
                Class fieldType = dbField.getType();
                if (fieldType != null) {
                    if (fieldType.equals(ClassConstants.STRING) || fieldType.equals(ClassConstants.APCHAR) || fieldType.equals(ClassConstants.ACHAR)) {
                        fieldDef.setSize(dbField.getLength());
                    } else if (dbField.getPrecision() > 0) {
                        fieldDef.setSize(dbField.getPrecision());
                        fieldDef.setSubSize(dbField.getScale());
                    }
                }
                if (fieldType == null || !fieldType.isPrimitive() && this.databasePlatform.getFieldTypeDefinition(fieldType) == null) {
                    AbstractSessionLog.getLog().log(1, "field_type_set_to_java_lang_string", dbField.getQualifiedName(), fieldType);
                    fieldDef.setType(ClassConstants.STRING);
                } else {
                    fieldDef.setType(ConversionManager.getObjectClass(fieldType));
                }
                fieldDef.setShouldAllowNull(dbField.isNullable());
                fieldDef.setUnique(dbField.isUnique());
            }
            fieldDef.setIsPrimaryKey(isPrimaryKey);
            this.fieldMap.put(dbField, fieldDef);
            this.databaseFields.put(dbField, dbField);
        }
        return fieldDef;
    }

    private FieldDefinition getDirectCollectionReferenceKeyFieldDefFromDBField(DatabaseField dbField) {
        FieldDefinition fieldDef = (FieldDefinition)this.getFieldDefFromDBField(dbField, true).clone();
        fieldDef.setIsPrimaryKey(false);
        return fieldDef;
    }

    private void setFieldToRelationTable(DatabaseField dbField, TableDefinition tblDef) {
        FieldDefinition fieldDef = this.getFieldDefFromDBField(dbField, false);
        if (!tblDef.getFields().contains(fieldDef)) {
            tblDef.addField(this.getFieldDefFromDBField(dbField, false));
            fieldDef.setIsPrimaryKey(true);
        }
    }

    private void processAdditionalTablePkFields(ClassDescriptor desc) {
        if (!desc.hasMultipleTables()) {
            return;
        }
        DatabaseTable dbTbl2 = null;
        for (DatabaseTable dbTbl2 : desc.getTables()) {
            Map<DatabaseField, DatabaseField> srcFields = desc.getAdditionalTablePrimaryKeyFields().get(dbTbl2);
            if (null == srcFields || srcFields.size() <= 0) continue;
            Vector<DatabaseField> fkFields = new Vector<DatabaseField>();
            Vector<DatabaseField> pkFields = new Vector<DatabaseField>();
            for (DatabaseField pkField : srcFields.keySet()) {
                pkFields.add(pkField);
                fkFields.add(srcFields.get(pkField));
            }
            this.addJoinColumnsFkConstraint(fkFields, pkFields);
        }
    }

    private void addJoinColumnsFkConstraint(List<DatabaseField> fkFields, List<DatabaseField> targetFields) {
        assert (fkFields.size() == targetFields.size());
        if (fkFields.size() == 0) {
            return;
        }
        DatabaseField fkField = null;
        DatabaseField targetField = null;
        Vector<String> fkFieldNames = new Vector<String>();
        Vector<String> targetFieldNames = new Vector<String>();
        DatabaseTable sourceTable = fkFields.get(0).getTable();
        TableDefinition sourceTableDef = this.getTableDefFromDBTable(sourceTable);
        for (int i = 0; i < fkFields.size(); ++i) {
            fkField = fkFields.get(i);
            targetField = targetFields.get(i);
            fkFieldNames.add(fkField.getName());
            targetFieldNames.add(targetField.getName());
            FieldDefinition fkFieldDef = this.fieldMap.get(fkField);
            FieldDefinition targetFieldDef = this.fieldMap.get(targetField);
            if (targetFieldDef == null) continue;
            if (fkFieldDef == null) {
                fkFieldDef = this.getFieldDefFromDBField(fkField, false);
                if (!sourceTableDef.getFields().contains(fkFieldDef)) {
                    sourceTableDef.addField(fkFieldDef);
                }
            }
            fkFieldDef.setType(targetFieldDef.getType());
            fkFieldDef.setTypeDefinition(targetFieldDef.getTypeDefinition());
            fkFieldDef.setSize(targetFieldDef.getSize());
            fkFieldDef.setSubSize(targetFieldDef.getSubSize());
        }
        DatabaseTable targetTable = targetField.getTable();
        TableDefinition targetTableDef = this.getTableDefFromDBTable(targetTable);
        this.addForeignKeyConstraint(sourceTableDef, targetTableDef, fkFieldNames, targetFieldNames);
    }

    private void addForeignKeyConstraint(TableDefinition sourceTableDef, TableDefinition targetTableDef, Vector<String> fkFields, Vector<String> targetFields) {
        if (!this.generateFKConstraints) {
            return;
        }
        assert (fkFields.size() > 0 && fkFields.size() == targetFields.size());
        Vector<String> fkFieldNames = fkFields;
        Vector<String> targetFieldNames = targetFields;
        if (fkFields.size() > 1) {
            boolean resolved = false;
            boolean error = false;
            HashMap<String, String> targetToFkField = new HashMap<String, String>();
            for (int index = 0; index < fkFields.size(); ++index) {
                String targetField = targetFields.get(index);
                if (targetToFkField.containsKey(targetField)) {
                    error = true;
                    break;
                }
                targetToFkField.put(targetField, fkFields.get(index));
            }
            Vector<String> orderedFkFields = new Vector<String>(fkFields.size());
            Vector<String> orderedTargetFields = new Vector<String>(targetFields.size());
            if (!error) {
                resolved = true;
                for (String pkField : targetTableDef.getPrimaryKeyFieldNames()) {
                    String fkField = (String)targetToFkField.get(pkField);
                    if (fkField == null) {
                        resolved = false;
                        break;
                    }
                    orderedFkFields.add(fkField);
                    orderedTargetFields.add(pkField);
                }
            }
            if (!error && !resolved) {
                for (UniqueKeyConstraint uniqueConstraint : targetTableDef.getUniqueKeys()) {
                    orderedFkFields.setSize(0);
                    orderedTargetFields.setSize(0);
                    resolved = true;
                    for (String ukField : uniqueConstraint.getSourceFields()) {
                        String fkField = (String)targetToFkField.get(ukField);
                        if (fkField == null) {
                            resolved = false;
                            break;
                        }
                        orderedFkFields.add(fkField);
                        orderedTargetFields.add(ukField);
                    }
                    if (!resolved) continue;
                    break;
                }
            }
            if (resolved) {
                fkFieldNames = orderedFkFields;
                targetFieldNames = orderedTargetFields;
            }
        }
        ForeignKeyConstraint fkc = sourceTableDef.buildForeignKeyConstraint(fkFieldNames, targetFieldNames, targetTableDef, this.databasePlatform);
        sourceTableDef.addForeignKeyConstraint(fkc);
    }

    private void addUniqueKeyConstraints(TableDefinition sourceTableDef, Map<String, Vector<List<String>>> uniqueConstraintsMap) {
        int serialNumber = -1;
        for (String name : uniqueConstraintsMap.keySet()) {
            Vector<List<String>> uniqueConstraints = uniqueConstraintsMap.get(name);
            for (List<String> uniqueConstraint : uniqueConstraints) {
                if (uniqueConstraint == null) continue;
                if (name == null || name.equals("")) {
                    ++serialNumber;
                }
                sourceTableDef.addUniqueKeyConstraint(sourceTableDef.buildUniqueKeyConstraint(name, uniqueConstraint, serialNumber, this.databasePlatform));
            }
        }
    }
}

