/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.entitystore;

import com.netflix.astyanax.ColumnListMutation;
import com.netflix.astyanax.Serializer;
import com.netflix.astyanax.entitystore.AbstractColumnMapper;
import com.netflix.astyanax.entitystore.MappingUtils;
import com.netflix.astyanax.model.Column;
import java.lang.reflect.Field;
import java.util.Iterator;

class LeafColumnMapper
extends AbstractColumnMapper {
    private final Serializer<?> serializer;

    LeafColumnMapper(Field field) {
        super(field);
        this.serializer = MappingUtils.getSerializerForField(field);
    }

    @Override
    public String getColumnName() {
        return this.columnName;
    }

    Serializer<?> getSerializer() {
        return this.serializer;
    }

    @Override
    public boolean fillMutationBatch(Object entity, ColumnListMutation<String> clm, String prefix) throws Exception {
        Object value = this.field.get(entity);
        if (value == null) {
            if (this.columnAnnotation.nullable()) {
                return false;
            }
            throw new IllegalArgumentException("cannot write non-nullable column with null value: " + this.columnName);
        }
        Serializer<?> valueSerializer = this.serializer;
        clm.putColumn(prefix + this.columnName, value, valueSerializer, null);
        return true;
    }

    @Override
    public boolean setField(Object entity, Iterator<String> name, Column<String> column) throws Exception {
        if (name.hasNext()) {
            return false;
        }
        Object fieldValue = column.getValue(this.serializer);
        this.field.set(entity, fieldValue);
        return true;
    }

    @Override
    public void validate(Object entity) throws Exception {
        if (this.field.get(entity) == null && !this.columnAnnotation.nullable()) {
            throw new IllegalArgumentException("cannot find non-nullable column: " + this.columnName);
        }
    }
}

