/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.impl;

import com.google.common.collect.Maps;
import com.netflix.astyanax.Keyspace;
import com.netflix.astyanax.connectionpool.exceptions.ConnectionException;
import com.netflix.astyanax.connectionpool.exceptions.NotFoundException;
import com.netflix.astyanax.model.Column;
import com.netflix.astyanax.model.ColumnFamily;
import com.netflix.astyanax.model.ColumnList;
import com.netflix.astyanax.query.CheckpointManager;
import com.netflix.astyanax.serializers.ByteBufferSerializer;
import com.netflix.astyanax.serializers.LongSerializer;
import com.netflix.astyanax.serializers.StringSerializer;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.Comparator;
import java.util.SortedMap;
import java.util.TreeMap;

public class AstyanaxCheckpointManager
implements CheckpointManager {
    private final ByteBuffer bbKey;
    private final Keyspace keyspace;
    private final ColumnFamily<ByteBuffer, String> columnFamily;
    private static final Comparator tokenComparator = new Comparator(){

        public int compare(Object arg0, Object arg1) {
            return new BigInteger((String)arg0).compareTo(new BigInteger((String)arg1));
        }
    };

    public AstyanaxCheckpointManager(Keyspace keyspace, String columnFamily, String id) {
        this(keyspace, columnFamily, StringSerializer.get().toByteBuffer(id));
    }

    public AstyanaxCheckpointManager(Keyspace keyspace, String columnFamily, Long id) {
        this(keyspace, columnFamily, LongSerializer.get().toByteBuffer(id));
    }

    public AstyanaxCheckpointManager(Keyspace keyspace, String columnFamily, ByteBuffer bbKey) {
        this.keyspace = keyspace;
        this.bbKey = bbKey;
        this.columnFamily = ColumnFamily.newColumnFamily(columnFamily, ByteBufferSerializer.get(), StringSerializer.get());
    }

    @Override
    public void trackCheckpoint(String startToken, String checkpointToken) throws ConnectionException {
        this.keyspace.prepareColumnMutation(this.columnFamily, this.bbKey, startToken).putValue(checkpointToken, null).execute();
    }

    @Override
    public String getCheckpoint(String startToken) throws ConnectionException {
        try {
            return ((Column)this.keyspace.prepareQuery(this.columnFamily).getKey(this.bbKey).getColumn(startToken).execute().getResult()).getStringValue();
        }
        catch (NotFoundException e) {
            return startToken;
        }
    }

    @Override
    public SortedMap<String, String> getCheckpoints() throws ConnectionException {
        TreeMap checkpoints = Maps.newTreeMap((Comparator)tokenComparator);
        for (Column column : (ColumnList)this.keyspace.prepareQuery(this.columnFamily).getKey(this.bbKey).execute().getResult()) {
            checkpoints.put(column.getName(), column.getStringValue());
        }
        return checkpoints;
    }
}

