/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.recipes.queue.shard;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Queues;
import com.netflix.astyanax.recipes.queue.MessageQueueSettings;
import com.netflix.astyanax.recipes.queue.MessageQueueShard;
import com.netflix.astyanax.recipes.queue.MessageQueueShardStats;
import com.netflix.astyanax.recipes.queue.shard.ShardReaderReaderStrategy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

public class TimePartitionedShardStrategy
implements ShardReaderReaderStrategy {
    private static final String SEPARATOR = ":";
    private final MessageQueueSettings settings;
    private final List<MessageQueueShard> shards;
    private final Map<String, MessageQueueShardStats> shardStats;
    private LinkedBlockingQueue<MessageQueueShard> workQueue = Queues.newLinkedBlockingQueue();
    private LinkedBlockingQueue<MessageQueueShard> idleQueue = Queues.newLinkedBlockingQueue();
    private int currentTimePartition = -1;

    public TimePartitionedShardStrategy(MessageQueueSettings config) {
        this.settings = config;
        this.shards = Lists.newArrayListWithCapacity((int)(config.getPartitionCount() * config.getShardCount()));
        for (int i = 0; i < config.getPartitionCount(); ++i) {
            for (int j = 0; j < config.getShardCount(); ++j) {
                this.shards.add(new MessageQueueShard(config.getQueueName() + SEPARATOR + i + SEPARATOR + j, i, j));
            }
        }
        this.shardStats = Maps.newHashMapWithExpectedSize((int)this.shards.size());
        for (MessageQueueShard shard : this.shards) {
            this.idleQueue.add(shard);
            this.shardStats.put(shard.getName(), shard);
        }
    }

    private int getCurrentPartitionIndex() {
        if (this.settings.getPartitionCount() <= 1) {
            return 0;
        }
        return (int)(TimeUnit.MICROSECONDS.convert(System.currentTimeMillis(), TimeUnit.MILLISECONDS) / this.settings.getPartitionDuration() % (long)this.settings.getPartitionCount());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MessageQueueShard nextShard() throws InterruptedException {
        int timePartition = this.getCurrentPartitionIndex();
        if (timePartition != this.currentTimePartition) {
            TimePartitionedShardStrategy timePartitionedShardStrategy = this;
            synchronized (timePartitionedShardStrategy) {
                if (timePartition != this.currentTimePartition) {
                    this.currentTimePartition = timePartition;
                    ArrayList temp = Lists.newArrayListWithCapacity((int)this.idleQueue.size());
                    this.idleQueue.drainTo(temp);
                    for (MessageQueueShard partition : this.shards) {
                        if (partition.getPartition() == this.currentTimePartition) {
                            this.workQueue.add(partition);
                            continue;
                        }
                        this.idleQueue.add(partition);
                    }
                }
            }
        }
        return this.workQueue.poll(this.settings.getPollInterval(), TimeUnit.MILLISECONDS);
    }

    @Override
    public void releaseShard(MessageQueueShard shard, int messagesRead) {
        if (shard.getPartition() != this.currentTimePartition && messagesRead == 0) {
            this.idleQueue.add(shard);
        } else {
            this.workQueue.add(shard);
        }
    }

    @Override
    public Collection<MessageQueueShard> listShards() {
        return Collections.unmodifiableList(this.shards);
    }

    @Override
    public Map<String, MessageQueueShardStats> getShardStats() {
        return this.shardStats;
    }
}

