/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.retry;

import com.netflix.astyanax.retry.ExponentialBackoff;
import com.netflix.astyanax.retry.RetryPolicy;
import com.netflix.astyanax.util.StringUtils;

public class BoundedExponentialBackoff
extends ExponentialBackoff {
    private final int maxSleepTimeMs;

    public BoundedExponentialBackoff(int baseSleepTimeMs, int maxSleepTimeMs, int max) {
        super(baseSleepTimeMs, max);
        this.maxSleepTimeMs = maxSleepTimeMs;
    }

    @Override
    public long getSleepTimeMs() {
        return Math.max((long)this.maxSleepTimeMs, super.getSleepTimeMs());
    }

    @Override
    public RetryPolicy duplicate() {
        return new BoundedExponentialBackoff(this.getBaseSleepTimeMs(), this.maxSleepTimeMs, this.getMaxAttemptCount());
    }

    @Override
    public String toString() {
        return StringUtils.joinClassAttributeValues(this, "BoundedExponentialBackoff", BoundedExponentialBackoff.class);
    }
}

