/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.serializers;

import com.netflix.astyanax.model.ByteBufferRange;
import com.netflix.astyanax.model.Equality;
import com.netflix.astyanax.serializers.ByteBufferOutputStream;
import java.nio.ByteBuffer;

public abstract class CompositeRangeBuilder
implements ByteBufferRange {
    private ByteBufferOutputStream start = new ByteBufferOutputStream();
    private ByteBufferOutputStream end = new ByteBufferOutputStream();
    private int limit = Integer.MAX_VALUE;
    private boolean reversed = false;
    private boolean lockComponent = false;

    protected abstract void nextComponent();

    protected abstract void append(ByteBufferOutputStream var1, Object var2, Equality var3);

    public CompositeRangeBuilder withPrefix(Object object) {
        if (this.lockComponent) {
            throw new IllegalStateException("Prefix cannot be added once equality has been specified");
        }
        this.append(this.start, object, Equality.EQUAL);
        this.append(this.end, object, Equality.EQUAL);
        this.nextComponent();
        return this;
    }

    public CompositeRangeBuilder limit(int count) {
        this.limit = count;
        return this;
    }

    public CompositeRangeBuilder reverse() {
        this.reversed = true;
        ByteBufferOutputStream temp = this.start;
        this.start = this.end;
        this.end = temp;
        return this;
    }

    public CompositeRangeBuilder greaterThan(Object value) {
        this.lockComponent = true;
        this.append(this.start, value, Equality.GREATER_THAN);
        return this;
    }

    public CompositeRangeBuilder greaterThanEquals(Object value) {
        this.lockComponent = true;
        this.append(this.start, value, Equality.GREATER_THAN_EQUALS);
        return this;
    }

    public CompositeRangeBuilder lessThan(Object value) {
        this.lockComponent = true;
        this.append(this.end, value, Equality.LESS_THAN);
        return this;
    }

    public CompositeRangeBuilder lessThanEquals(Object value) {
        this.lockComponent = true;
        this.append(this.end, value, Equality.LESS_THAN_EQUALS);
        return this;
    }

    @Override
    @Deprecated
    public ByteBuffer getStart() {
        return this.start.getByteBuffer();
    }

    @Override
    @Deprecated
    public ByteBuffer getEnd() {
        return this.end.getByteBuffer();
    }

    @Override
    @Deprecated
    public boolean isReversed() {
        return this.reversed;
    }

    @Override
    @Deprecated
    public int getLimit() {
        return this.limit;
    }

    public ByteBufferRange build() {
        return new ByteBufferRange(){

            @Override
            public ByteBuffer getStart() {
                return CompositeRangeBuilder.this.start.getByteBuffer();
            }

            @Override
            public ByteBuffer getEnd() {
                return CompositeRangeBuilder.this.end.getByteBuffer();
            }

            @Override
            public boolean isReversed() {
                return CompositeRangeBuilder.this.reversed;
            }

            @Override
            public int getLimit() {
                return CompositeRangeBuilder.this.limit;
            }
        };
    }
}

