/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.thrift;

import com.netflix.astyanax.Serializer;
import com.netflix.astyanax.model.ByteBufferRange;
import com.netflix.astyanax.model.ColumnFamily;
import com.netflix.astyanax.model.ColumnSlice;
import com.netflix.astyanax.query.IndexColumnExpression;
import com.netflix.astyanax.query.IndexOperationExpression;
import com.netflix.astyanax.query.IndexQuery;
import com.netflix.astyanax.query.IndexValueExpression;
import com.netflix.astyanax.query.PreparedIndexExpression;
import com.netflix.astyanax.serializers.BooleanSerializer;
import com.netflix.astyanax.serializers.ByteBufferSerializer;
import com.netflix.astyanax.serializers.BytesArraySerializer;
import com.netflix.astyanax.serializers.DateSerializer;
import com.netflix.astyanax.serializers.DoubleSerializer;
import com.netflix.astyanax.serializers.IntegerSerializer;
import com.netflix.astyanax.serializers.LongSerializer;
import com.netflix.astyanax.serializers.StringSerializer;
import com.netflix.astyanax.serializers.UUIDSerializer;
import com.netflix.astyanax.thrift.ThriftUtils;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.UUID;
import org.apache.cassandra.thrift.IndexClause;
import org.apache.cassandra.thrift.IndexOperator;
import org.apache.cassandra.thrift.SlicePredicate;
import org.apache.cassandra.thrift.SliceRange;

public abstract class AbstractIndexQueryImpl<K, C>
implements IndexQuery<K, C> {
    protected final IndexClause indexClause = new IndexClause();
    protected SlicePredicate predicate = new SlicePredicate().setSlice_range(ThriftUtils.createAllInclusiveSliceRange());
    protected boolean isPaginating = false;
    protected boolean paginateNoMore = false;
    protected boolean firstPage = true;
    protected ColumnFamily<K, C> columnFamily;

    public AbstractIndexQueryImpl(ColumnFamily<K, C> columnFamily) {
        this.columnFamily = columnFamily;
        this.indexClause.setStart_key(ByteBuffer.allocate(0));
    }

    @Override
    public IndexQuery<K, C> withColumnSlice(C ... columns) {
        if (columns != null) {
            this.predicate.setColumn_names(this.columnFamily.getColumnSerializer().toBytesList(Arrays.asList(columns))).setSlice_rangeIsSet(false);
        }
        return this;
    }

    @Override
    public IndexQuery<K, C> withColumnSlice(Collection<C> columns) {
        if (columns != null) {
            this.predicate.setColumn_names(this.columnFamily.getColumnSerializer().toBytesList(columns)).setSlice_rangeIsSet(false);
        }
        return this;
    }

    @Override
    public IndexQuery<K, C> withColumnSlice(ColumnSlice<C> slice) {
        if (slice.getColumns() != null) {
            this.predicate.setColumn_names(this.columnFamily.getColumnSerializer().toBytesList(slice.getColumns())).setSlice_rangeIsSet(false);
        } else {
            this.predicate.setSlice_range(ThriftUtils.createSliceRange(this.columnFamily.getColumnSerializer(), slice.getStartColumn(), slice.getEndColumn(), slice.getReversed(), slice.getLimit()));
        }
        return this;
    }

    @Override
    public IndexQuery<K, C> withColumnRange(C startColumn, C endColumn, boolean reversed, int count) {
        this.predicate.setSlice_range(ThriftUtils.createSliceRange(this.columnFamily.getColumnSerializer(), startColumn, endColumn, reversed, count));
        return this;
    }

    @Override
    public IndexQuery<K, C> withColumnRange(ByteBufferRange range) {
        this.predicate.setSlice_range(new SliceRange().setStart(range.getStart()).setFinish(range.getEnd()).setCount(range.getLimit()).setReversed(range.isReversed()));
        return this;
    }

    @Override
    public IndexQuery<K, C> withColumnRange(ByteBuffer startColumn, ByteBuffer endColumn, boolean reversed, int count) {
        this.predicate.setSlice_range(new SliceRange(startColumn, endColumn, reversed, count));
        return this;
    }

    @Override
    public IndexQuery<K, C> setLimit(int count) {
        return this.setRowLimit(count);
    }

    @Override
    public IndexQuery<K, C> setRowLimit(int count) {
        this.indexClause.setCount(count);
        return this;
    }

    @Override
    public IndexQuery<K, C> setStartKey(K key) {
        this.indexClause.setStart_key(this.columnFamily.getKeySerializer().toByteBuffer(key));
        return this;
    }

    protected void setNextStartKey(ByteBuffer byteBuffer) {
        this.indexClause.setStart_key(byteBuffer);
        if (this.firstPage) {
            this.firstPage = false;
            if (this.indexClause.getCount() != Integer.MAX_VALUE) {
                this.indexClause.setCount(this.indexClause.getCount() + 1);
            }
        }
    }

    private IndexQuery<K, C> getThisQuery() {
        return this;
    }

    @Override
    public IndexQuery<K, C> addPreparedExpressions(Collection<PreparedIndexExpression<K, C>> expressions) {
        for (PreparedIndexExpression<K, C> expression : expressions) {
            org.apache.cassandra.thrift.IndexExpression expr = new org.apache.cassandra.thrift.IndexExpression().setColumn_name(expression.getColumn().duplicate()).setValue(expression.getValue().duplicate());
            switch (expression.getOperator()) {
                case EQ: {
                    expr.setOp(IndexOperator.EQ);
                    break;
                }
                case LT: {
                    expr.setOp(IndexOperator.LT);
                    break;
                }
                case GT: {
                    expr.setOp(IndexOperator.GT);
                    break;
                }
                case GTE: {
                    expr.setOp(IndexOperator.GTE);
                    break;
                }
                case LTE: {
                    expr.setOp(IndexOperator.LTE);
                    break;
                }
                default: {
                    throw new RuntimeException("Invalid operator type: " + expression.getOperator().name());
                }
            }
            this.indexClause.addToExpressions(expr);
        }
        return this;
    }

    @Override
    public IndexColumnExpression<K, C> addExpression() {
        return new IndexExpression<K, C>(){
            private final org.apache.cassandra.thrift.IndexExpression internalExpression = new org.apache.cassandra.thrift.IndexExpression();

            @Override
            public IndexOperationExpression<K, C> whereColumn(C columnName) {
                this.internalExpression.setColumn_name(AbstractIndexQueryImpl.this.columnFamily.getColumnSerializer().toBytes(columnName));
                return this;
            }

            @Override
            public IndexValueExpression<K, C> equals() {
                this.internalExpression.setOp(IndexOperator.EQ);
                return this;
            }

            @Override
            public IndexValueExpression<K, C> greaterThan() {
                this.internalExpression.setOp(IndexOperator.GT);
                return this;
            }

            @Override
            public IndexValueExpression<K, C> lessThan() {
                this.internalExpression.setOp(IndexOperator.LT);
                return this;
            }

            @Override
            public IndexValueExpression<K, C> greaterThanEquals() {
                this.internalExpression.setOp(IndexOperator.GTE);
                return this;
            }

            @Override
            public IndexValueExpression<K, C> lessThanEquals() {
                this.internalExpression.setOp(IndexOperator.LTE);
                return this;
            }

            @Override
            public IndexQuery<K, C> value(String value) {
                this.internalExpression.setValue(StringSerializer.get().toBytes(value));
                AbstractIndexQueryImpl.this.indexClause.addToExpressions(this.internalExpression);
                return AbstractIndexQueryImpl.this.getThisQuery();
            }

            @Override
            public IndexQuery<K, C> value(long value) {
                this.internalExpression.setValue(LongSerializer.get().toBytes(value));
                AbstractIndexQueryImpl.this.indexClause.addToExpressions(this.internalExpression);
                return AbstractIndexQueryImpl.this.getThisQuery();
            }

            @Override
            public IndexQuery<K, C> value(int value) {
                this.internalExpression.setValue(IntegerSerializer.get().toBytes(value));
                AbstractIndexQueryImpl.this.indexClause.addToExpressions(this.internalExpression);
                return AbstractIndexQueryImpl.this.getThisQuery();
            }

            @Override
            public IndexQuery<K, C> value(boolean value) {
                this.internalExpression.setValue(BooleanSerializer.get().toBytes(value));
                AbstractIndexQueryImpl.this.indexClause.addToExpressions(this.internalExpression);
                return AbstractIndexQueryImpl.this.getThisQuery();
            }

            @Override
            public IndexQuery<K, C> value(Date value) {
                this.internalExpression.setValue(DateSerializer.get().toBytes(value));
                AbstractIndexQueryImpl.this.indexClause.addToExpressions(this.internalExpression);
                return AbstractIndexQueryImpl.this.getThisQuery();
            }

            @Override
            public IndexQuery<K, C> value(byte[] value) {
                this.internalExpression.setValue(BytesArraySerializer.get().toBytes(value));
                AbstractIndexQueryImpl.this.indexClause.addToExpressions(this.internalExpression);
                return AbstractIndexQueryImpl.this.getThisQuery();
            }

            @Override
            public IndexQuery<K, C> value(ByteBuffer value) {
                this.internalExpression.setValue(ByteBufferSerializer.get().toBytes(value));
                AbstractIndexQueryImpl.this.indexClause.addToExpressions(this.internalExpression);
                return AbstractIndexQueryImpl.this.getThisQuery();
            }

            @Override
            public IndexQuery<K, C> value(double value) {
                this.internalExpression.setValue(DoubleSerializer.get().toBytes(value));
                AbstractIndexQueryImpl.this.indexClause.addToExpressions(this.internalExpression);
                return AbstractIndexQueryImpl.this.getThisQuery();
            }

            @Override
            public IndexQuery<K, C> value(UUID value) {
                this.internalExpression.setValue(UUIDSerializer.get().toBytes(value));
                AbstractIndexQueryImpl.this.indexClause.addToExpressions(this.internalExpression);
                return AbstractIndexQueryImpl.this.getThisQuery();
            }

            @Override
            public <V> IndexQuery<K, C> value(V value, Serializer<V> valueSerializer) {
                this.internalExpression.setValue(valueSerializer.toBytes(value));
                AbstractIndexQueryImpl.this.indexClause.addToExpressions(this.internalExpression);
                return AbstractIndexQueryImpl.this.getThisQuery();
            }
        };
    }

    @Override
    public IndexQuery<K, C> setIsPaginating() {
        return this.autoPaginateRows(true);
    }

    @Override
    public IndexQuery<K, C> autoPaginateRows(boolean autoPaginate) {
        this.isPaginating = autoPaginate;
        return this;
    }

    static interface IndexExpression<K, C>
    extends IndexColumnExpression<K, C>,
    IndexOperationExpression<K, C>,
    IndexValueExpression<K, C> {
    }
}

