/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.thrift.model;

import com.google.common.collect.Maps;
import com.netflix.astyanax.Serializer;
import com.netflix.astyanax.model.AbstractColumnList;
import com.netflix.astyanax.model.Column;
import com.netflix.astyanax.thrift.model.ThriftCounterColumnImpl;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.thrift.CounterColumn;

public class ThriftCounterColumnListImpl<C>
extends AbstractColumnList<C> {
    private final List<CounterColumn> columns;
    private Map<C, CounterColumn> lookup;
    private final Serializer<C> colSer;

    public ThriftCounterColumnListImpl(List<CounterColumn> columns, Serializer<C> colSer) {
        this.columns = columns;
        this.colSer = colSer;
    }

    @Override
    public Iterator<Column<C>> iterator() {
        class IteratorImpl
        implements Iterator<Column<C>> {
            Iterator<CounterColumn> base;

            public IteratorImpl(Iterator<CounterColumn> base) {
                this.base = base;
            }

            @Override
            public boolean hasNext() {
                return this.base.hasNext();
            }

            @Override
            public Column<C> next() {
                CounterColumn c = this.base.next();
                return new ThriftCounterColumnImpl(ThriftCounterColumnListImpl.this.colSer.fromBytes(c.getName()), c);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Iterator is immutable");
            }
        }
        return new IteratorImpl(this.columns.iterator());
    }

    @Override
    public Column<C> getColumnByName(C columnName) {
        this.constructMap();
        CounterColumn c = this.lookup.get(columnName);
        if (c == null) {
            return null;
        }
        return new ThriftCounterColumnImpl<C>(this.colSer.fromBytes(c.getName()), c);
    }

    @Override
    public Column<C> getColumnByIndex(int idx) {
        CounterColumn c = this.columns.get(idx);
        return new ThriftCounterColumnImpl<C>(this.colSer.fromBytes(c.getName()), c);
    }

    @Override
    public <C2> Column<C2> getSuperColumn(C columnName, Serializer<C2> colSer) {
        throw new UnsupportedOperationException("Call getCounter");
    }

    @Override
    public <C2> Column<C2> getSuperColumn(int idx, Serializer<C2> colSer) {
        throw new UnsupportedOperationException("Call getCounter");
    }

    @Override
    public boolean isEmpty() {
        return this.columns.isEmpty();
    }

    @Override
    public int size() {
        return this.columns.size();
    }

    @Override
    public boolean isSuperColumn() {
        return false;
    }

    @Override
    public Collection<C> getColumnNames() {
        this.constructMap();
        return this.lookup.keySet();
    }

    private void constructMap() {
        if (this.lookup == null) {
            this.lookup = Maps.newHashMap();
            for (CounterColumn column : this.columns) {
                this.lookup.put(this.colSer.fromBytes(column.getName()), column);
            }
        }
    }
}

