/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.thrift.model;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.netflix.astyanax.Serializer;
import com.netflix.astyanax.model.Row;
import com.netflix.astyanax.model.Rows;
import com.netflix.astyanax.thrift.model.ThriftColumnListImpl;
import com.netflix.astyanax.thrift.model.ThriftRowImpl;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.cassandra.thrift.CqlRow;

public class ThriftCqlRowsImpl<K, C>
implements Rows<K, C> {
    private List<Row<K, C>> rows;
    private Map<K, Row<K, C>> lookup;

    public ThriftCqlRowsImpl(List<CqlRow> rows, Serializer<K> keySer, Serializer<C> colSer) {
        this.rows = Lists.newArrayListWithCapacity((int)rows.size());
        for (CqlRow row : rows) {
            this.rows.add(new ThriftRowImpl<K, C>(keySer.fromBytes(row.getKey()), ByteBuffer.wrap(row.getKey()), new ThriftColumnListImpl<C>(row.getColumns(), colSer)));
        }
    }

    @Override
    public Iterator<Row<K, C>> iterator() {
        return this.rows.iterator();
    }

    @Override
    public Row<K, C> getRow(K key) {
        this.lazyBuildLookup();
        return this.lookup.get(key);
    }

    @Override
    public int size() {
        return this.rows.size();
    }

    @Override
    public boolean isEmpty() {
        return this.rows.isEmpty();
    }

    @Override
    public Row<K, C> getRowByIndex(int i) {
        return this.rows.get(i);
    }

    @Override
    public Collection<K> getKeys() {
        return Lists.transform(this.rows, (Function)new Function<Row<K, C>, K>(){

            public K apply(@Nullable Row<K, C> input) {
                return input.getKey();
            }
        });
    }

    private void lazyBuildLookup() {
        if (this.lookup == null) {
            this.lookup = Maps.newHashMap();
            for (Row<K, C> row : this.rows) {
                this.lookup.put(row.getKey(), row);
            }
        }
    }
}

