/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.util;

import com.eaio.uuid.UUIDGen;
import com.netflix.astyanax.Clock;
import com.netflix.astyanax.clock.MicrosecondsSyncClock;
import java.nio.ByteBuffer;
import java.util.UUID;

public final class TimeUUIDUtils {
    static final long NUM_100NS_INTERVALS_SINCE_UUID_EPOCH = 122192928000000000L;
    static final Clock microsClock = new MicrosecondsSyncClock();

    public static UUID getUniqueTimeUUIDinMillis() {
        return new UUID(UUIDGen.newTime(), UUIDGen.getClockSeqAndNode());
    }

    public static UUID getUniqueTimeUUIDinMicros() {
        return new UUID(TimeUUIDUtils.createTimeFromMicros(microsClock.getCurrentTime()), UUIDGen.getClockSeqAndNode());
    }

    public static UUID getTimeUUID(Clock clock) {
        return TimeUUIDUtils.getTimeUUID(clock.getCurrentTime());
    }

    public static UUID getTimeUUID(long time) {
        return new UUID(TimeUUIDUtils.createTime(time), UUIDGen.getClockSeqAndNode());
    }

    public static UUID getMicrosTimeUUID(long time) {
        return new UUID(TimeUUIDUtils.createTimeFromMicros(time), UUIDGen.getClockSeqAndNode());
    }

    private static long createTime(long currentTime) {
        long timeToUse = currentTime * 10000L + 122192928000000000L;
        long time = timeToUse << 32;
        time |= (timeToUse & 0xFFFF00000000L) >> 16;
        return time |= 0x1000L | timeToUse >> 48 & 0xFFFL;
    }

    private static long createTimeFromMicros(long currentTime) {
        long timeToUse = currentTime * 10L + 122192928000000000L;
        long time = timeToUse << 32;
        time |= (timeToUse & 0xFFFF00000000L) >> 16;
        return time |= 0x1000L | timeToUse >> 48 & 0xFFFL;
    }

    public static UUID toUUID(byte[] uuid) {
        return TimeUUIDUtils.uuid(uuid, 0);
    }

    public static long getTimeFromUUID(byte[] uuid) {
        return TimeUUIDUtils.getTimeFromUUID(TimeUUIDUtils.toUUID(uuid));
    }

    public static long getTimeFromUUID(UUID uuid) {
        return (uuid.timestamp() - 122192928000000000L) / 10000L;
    }

    public static long getMicrosTimeFromUUID(UUID uuid) {
        return (uuid.timestamp() - 122192928000000000L) / 10L;
    }

    public static byte[] asByteArray(UUID uuid) {
        int i;
        long msb = uuid.getMostSignificantBits();
        long lsb = uuid.getLeastSignificantBits();
        byte[] buffer = new byte[16];
        for (i = 0; i < 8; ++i) {
            buffer[i] = (byte)(msb >>> 8 * (7 - i));
        }
        for (i = 8; i < 16; ++i) {
            buffer[i] = (byte)(lsb >>> 8 * (7 - i));
        }
        return buffer;
    }

    public static ByteBuffer asByteBuffer(UUID uuid) {
        if (uuid == null) {
            return null;
        }
        return ByteBuffer.wrap(TimeUUIDUtils.asByteArray(uuid));
    }

    public static UUID uuid(byte[] uuid, int offset) {
        ByteBuffer bb = ByteBuffer.wrap(uuid, offset, 16);
        return new UUID(bb.getLong(), bb.getLong());
    }

    public static UUID uuid(ByteBuffer bb) {
        bb = bb.slice();
        return new UUID(bb.getLong(), bb.getLong());
    }
}

