/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.DialogListener;
import ij.gui.GenericDialog;
import ij.gui.Overlay;
import ij.plugin.Colors;
import ij.plugin.PlugIn;
import ij.util.Tools;
import java.awt.AWTEvent;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Font;
import java.util.Vector;

public class OverlayLabels
implements PlugIn,
DialogListener {
    private static final String[] fontSizes = new String[]{"7", "8", "9", "10", "12", "14", "18", "24", "28", "36", "48", "72"};
    private static Overlay defaultOverlay = new Overlay();
    private ImagePlus imp;
    private Overlay overlay;
    private GenericDialog gd;
    private boolean showLabels;
    private boolean showNames;
    private boolean drawBackgrounds;
    private String colorName;
    private int fontSize;
    private boolean bold;

    public void run(String arg) {
        this.imp = WindowManager.getCurrentImage();
        Overlay overlay = this.overlay = this.imp != null ? this.imp.getOverlay() : null;
        if (this.overlay == null) {
            this.overlay = defaultOverlay;
        }
        this.showDialog();
        if (!this.gd.wasCanceled()) {
            defaultOverlay.drawLabels(this.overlay.getDrawLabels());
            defaultOverlay.drawNames(this.overlay.getDrawNames());
            defaultOverlay.drawBackgrounds(this.overlay.getDrawBackgrounds());
            defaultOverlay.setLabelColor(this.overlay.getLabelColor());
            defaultOverlay.setLabelFont(this.overlay.getLabelFont());
        }
    }

    public void showDialog() {
        this.showLabels = this.overlay.getDrawLabels();
        this.showNames = this.overlay.getDrawNames();
        this.drawBackgrounds = this.overlay.getDrawBackgrounds();
        this.colorName = Colors.getColorName(this.overlay.getLabelColor(), "white");
        this.fontSize = 12;
        Font font = this.overlay.getLabelFont();
        if (font != null) {
            this.fontSize = font.getSize();
            this.bold = font.getStyle() == 1;
        }
        this.gd = new GenericDialog("Labels");
        this.gd.addChoice("Color:", Colors.colors, this.colorName);
        this.gd.addChoice("Font size:", fontSizes, "" + this.fontSize);
        this.gd.addCheckbox("Show labels", this.showLabels);
        this.gd.addCheckbox("Use names as labels", this.showNames);
        this.gd.addCheckbox("Draw backgrounds", this.drawBackgrounds);
        this.gd.addCheckbox("Bold", this.bold);
        this.gd.addDialogListener(this);
        this.gd.showDialog();
    }

    public boolean dialogItemChanged(GenericDialog gd, AWTEvent e) {
        boolean changes;
        if (gd.wasCanceled()) {
            return false;
        }
        String colorName2 = this.colorName;
        boolean showLabels2 = this.showLabels;
        boolean showNames2 = this.showNames;
        boolean drawBackgrounds2 = this.drawBackgrounds;
        boolean bold2 = this.bold;
        int fontSize2 = this.fontSize;
        this.colorName = gd.getNextChoice();
        this.fontSize = (int)Tools.parseDouble(gd.getNextChoice(), 12.0);
        this.showLabels = gd.getNextBoolean();
        this.showNames = gd.getNextBoolean();
        this.drawBackgrounds = gd.getNextBoolean();
        this.bold = gd.getNextBoolean();
        boolean colorChanged = !this.colorName.equals(colorName2);
        boolean sizeChanged = this.fontSize != fontSize2;
        boolean bl = changes = this.showLabels != showLabels2 || this.showNames != showNames2 || this.drawBackgrounds != drawBackgrounds2 || colorChanged || sizeChanged || this.bold != bold2;
        if (changes) {
            if (this.showNames || colorChanged || sizeChanged) {
                this.showLabels = true;
                Vector checkboxes = gd.getCheckboxes();
                ((Checkbox)checkboxes.elementAt(0)).setState(true);
            }
            this.overlay.drawLabels(this.showLabels);
            this.overlay.drawNames(this.showNames);
            this.overlay.drawBackgrounds(this.drawBackgrounds);
            Color color = Colors.getColor(this.colorName, Color.white);
            this.overlay.setLabelColor(color);
            if (sizeChanged || this.bold || this.bold != bold2) {
                this.overlay.setLabelFont(new Font("SansSerif", this.bold ? 1 : 0, this.fontSize));
            }
            if (this.imp != null && this.imp.getOverlay() != null) {
                this.imp.draw();
            }
        }
        return true;
    }

    static Overlay createOverlay() {
        return defaultOverlay.duplicate();
    }
}

