/*
 * Decompiled with CFR 0.152.
 */
package ij.process;

import ij.process.Blitter;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import java.awt.Color;
import java.awt.Rectangle;

public class ByteBlitter
implements Blitter {
    private ByteProcessor ip;
    private int width;
    private int height;
    private byte[] pixels;
    private int transparent = 255;

    public ByteBlitter(ByteProcessor ip) {
        this.ip = ip;
        this.width = ip.getWidth();
        this.height = ip.getHeight();
        this.pixels = (byte[])ip.getPixels();
    }

    public void setTransparentColor(Color c) {
        this.transparent = this.ip.getBestIndex(c);
    }

    public void copyBits(ImageProcessor ip, int xloc, int yloc, int mode) {
        byte[] srcPixels;
        int srcWidth = ip.getWidth();
        int srcHeight = ip.getHeight();
        Rectangle r1 = new Rectangle(srcWidth, srcHeight);
        r1.setLocation(xloc, yloc);
        Rectangle r2 = new Rectangle(this.width, this.height);
        if (!r1.intersects(r2)) {
            return;
        }
        if (ip instanceof ColorProcessor) {
            int i;
            int[] pixels32 = (int[])ip.getPixels();
            int size = ip.getWidth() * ip.getHeight();
            srcPixels = new byte[size];
            if (this.ip.isInvertedLut()) {
                for (i = 0; i < size; ++i) {
                    srcPixels[i] = (byte)(255 - pixels32[i] & 0xFF);
                }
            } else {
                for (i = 0; i < size; ++i) {
                    srcPixels[i] = (byte)(pixels32[i] & 0xFF);
                }
            }
        } else {
            ip = ip.convertToByte(true);
            srcPixels = (byte[])ip.getPixels();
        }
        r1 = r1.intersection(r2);
        int xSrcBase = xloc < 0 ? -xloc : 0;
        int ySrcBase = yloc < 0 ? -yloc : 0;
        for (int y = r1.y; y < r1.y + r1.height; ++y) {
            int srcIndex = (y - yloc) * srcWidth + (r1.x - xloc);
            int dstIndex = y * this.width + r1.x;
            switch (mode) {
                case 0: {
                    int i = r1.width;
                    while (--i >= 0) {
                        this.pixels[dstIndex++] = srcPixels[srcIndex++];
                    }
                    break;
                }
                case 1: {
                    int i = r1.width;
                    while (--i >= 0) {
                        this.pixels[dstIndex++] = (byte)(255 - srcPixels[srcIndex++] & 0xFF);
                    }
                    break;
                }
                case 2: {
                    int dst;
                    int i = r1.width;
                    while (--i >= 0) {
                        int src;
                        dst = (src = srcPixels[srcIndex++] & 0xFF) == this.transparent ? this.pixels[dstIndex] : src;
                        this.pixels[dstIndex++] = (byte)dst;
                    }
                    break;
                }
                case 14: {
                    int dst;
                    int i = r1.width;
                    while (--i >= 0) {
                        int src;
                        dst = (src = srcPixels[srcIndex++] & 0xFF) == 0 ? this.pixels[dstIndex] : src;
                        this.pixels[dstIndex++] = (byte)dst;
                    }
                    break;
                }
                case 3: {
                    int dst;
                    int i = r1.width;
                    while (--i >= 0) {
                        if ((dst = (srcPixels[srcIndex++] & 0xFF) + (this.pixels[dstIndex] & 0xFF)) > 255) {
                            dst = 255;
                        }
                        this.pixels[dstIndex++] = (byte)dst;
                    }
                    break;
                }
                case 7: {
                    int dst;
                    int i = r1.width;
                    while (--i >= 0) {
                        dst = ((srcPixels[srcIndex++] & 0xFF) + (this.pixels[dstIndex] & 0xFF)) / 2;
                        this.pixels[dstIndex++] = (byte)dst;
                    }
                    break;
                }
                case 4: {
                    int dst;
                    int i = r1.width;
                    while (--i >= 0) {
                        if ((dst = (this.pixels[dstIndex] & 0xFF) - (srcPixels[srcIndex++] & 0xFF)) < 0) {
                            dst = 0;
                        }
                        this.pixels[dstIndex++] = (byte)dst;
                    }
                    break;
                }
                case 8: {
                    int dst;
                    int i = r1.width;
                    while (--i >= 0) {
                        if ((dst = (this.pixels[dstIndex] & 0xFF) - (srcPixels[srcIndex++] & 0xFF)) < 0) {
                            dst = -dst;
                        }
                        this.pixels[dstIndex++] = (byte)dst;
                    }
                    break;
                }
                case 5: {
                    int dst;
                    int i = r1.width;
                    while (--i >= 0) {
                        if ((dst = (srcPixels[srcIndex++] & 0xFF) * (this.pixels[dstIndex] & 0xFF)) > 255) {
                            dst = 255;
                        }
                        this.pixels[dstIndex++] = (byte)dst;
                    }
                    break;
                }
                case 6: {
                    int dst;
                    int i = r1.width;
                    while (--i >= 0) {
                        int src;
                        dst = (src = srcPixels[srcIndex++] & 0xFF) == 0 ? 255 : (this.pixels[dstIndex] & 0xFF) / src;
                        this.pixels[dstIndex++] = (byte)dst;
                    }
                    break;
                }
                case 9: {
                    int dst;
                    int i = r1.width;
                    while (--i >= 0) {
                        dst = srcPixels[srcIndex++] & this.pixels[dstIndex];
                        this.pixels[dstIndex++] = (byte)dst;
                    }
                    break;
                }
                case 10: {
                    int dst;
                    int i = r1.width;
                    while (--i >= 0) {
                        dst = srcPixels[srcIndex++] | this.pixels[dstIndex];
                        this.pixels[dstIndex++] = (byte)dst;
                    }
                    break;
                }
                case 11: {
                    int dst;
                    int i = r1.width;
                    while (--i >= 0) {
                        dst = srcPixels[srcIndex++] ^ this.pixels[dstIndex];
                        this.pixels[dstIndex++] = (byte)dst;
                    }
                    break;
                }
                case 12: {
                    int dst;
                    int i = r1.width;
                    while (--i >= 0) {
                        int src;
                        dst = this.pixels[dstIndex] & 0xFF;
                        if ((src = srcPixels[srcIndex++] & 0xFF) < dst) {
                            dst = src;
                        }
                        this.pixels[dstIndex++] = (byte)dst;
                    }
                    break;
                }
                case 13: {
                    int dst;
                    int i = r1.width;
                    while (--i >= 0) {
                        int src;
                        dst = this.pixels[dstIndex] & 0xFF;
                        if ((src = srcPixels[srcIndex++] & 0xFF) > dst) {
                            dst = src;
                        }
                        this.pixels[dstIndex++] = (byte)dst;
                    }
                    break;
                }
            }
            if (y % 20 != 0) continue;
            ip.showProgress((double)(y - r1.y) / (double)r1.height);
        }
        ip.hideProgress();
    }
}

