/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.io.archive.zip;

import de.schlichtherle.io.File;
import de.schlichtherle.io.OutputArchiveMetaData;
import de.schlichtherle.io.archive.spi.ArchiveEntry;
import de.schlichtherle.io.archive.spi.OutputArchive;
import de.schlichtherle.io.archive.spi.OutputArchiveBusyException;
import de.schlichtherle.io.archive.spi.RfsEntry;
import de.schlichtherle.io.archive.zip.ZipEntry;
import de.schlichtherle.io.archive.zip.ZipInputArchive;
import de.schlichtherle.io.util.Temps;
import de.schlichtherle.util.JointEnumeration;
import de.schlichtherle.util.zip.BasicZipOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.zip.CRC32;
import java.util.zip.CheckedOutputStream;

public class ZipOutputArchive
extends BasicZipOutputStream
implements OutputArchive {
    private static final String TEMP_FILE_PREFIX = "tzp-zip";
    private final ZipInputArchive source;
    private OutputArchiveMetaData metaData;
    private ZipEntry tempEntry;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ZipOutputArchive(OutputStream out, String charset, ZipInputArchive source) throws NullPointerException, UnsupportedEncodingException, IOException {
        this(out, charset, 9, source);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ZipOutputArchive(OutputStream out, String charset, int level, ZipInputArchive source) throws NullPointerException, UnsupportedEncodingException, IOException {
        super(out, charset);
        super.setLevel(level);
        this.source = source;
        if (source != null) {
            super.setComment(source.getComment());
            if (source.getPreambleLength() > 0L) {
                InputStream in = source.getPreambleInputStream();
                try {
                    File.cat(in, source.offsetsConsiderPreamble() ? this : out);
                }
                finally {
                    in.close();
                }
            }
        }
    }

    public int getNumArchiveEntries() {
        return this.size() + (this.tempEntry != null ? 1 : 0);
    }

    public Enumeration getArchiveEntries() {
        if (this.tempEntry == null) {
            return super.entries();
        }
        return new JointEnumeration(super.entries(), Collections.enumeration(Collections.singletonList(this.tempEntry)));
    }

    public ArchiveEntry getArchiveEntry(String entryName) {
        ZipEntry e = (ZipEntry)this.getEntry(entryName);
        if (e != null) {
            return e;
        }
        e = this.tempEntry;
        return e != null && entryName.equals(e.getName()) ? e : null;
    }

    public OutputStream getOutputStream(ArchiveEntry dstEntry, ArchiveEntry srcEntry) throws IOException {
        ZipEntry entry = (ZipEntry)dstEntry;
        if (this.isBusy()) {
            throw new OutputArchiveBusyException(entry);
        }
        if (entry.isDirectory()) {
            entry.setMethod(0);
            entry.setCrc(0L);
            entry.setCompressedSize(0L);
            entry.setSize(0L);
            return new EntryOutputStream(entry);
        }
        if (srcEntry instanceof ZipEntry) {
            ZipEntry srcZipEntry = (ZipEntry)srcEntry;
            if (entry.getMethod() == -1) {
                entry.setMethod(srcZipEntry.getMethod());
            }
            if (entry.getMethod() == srcZipEntry.getMethod()) {
                entry.setCompressedSize(srcZipEntry.getCompressedSize());
            }
            entry.setCrc(srcZipEntry.getCrc());
            entry.setSize(srcZipEntry.getSize());
            return new EntryOutputStream(entry, srcZipEntry.getMethod() != 8);
        }
        if (srcEntry != null) {
            entry.setSize(srcEntry.getSize());
        }
        switch (entry.getMethod()) {
            case -1: {
                entry.setMethod(8);
                break;
            }
            case 0: {
                if (entry.getCrc() != -1L && entry.getCompressedSize() != -1L && entry.getSize() != -1L) break;
                if (!(srcEntry instanceof RfsEntry)) {
                    java.io.File temp = Temps.createTempFile(TEMP_FILE_PREFIX);
                    return new TempEntryOutputStream(entry, temp);
                }
                java.io.File file = ((RfsEntry)srcEntry).getFile();
                long length = file.length();
                FileInputStream in = new FileInputStream(file);
                Crc32OutputStream out = new Crc32OutputStream();
                File.cp(in, out);
                entry.setCrc(out.crc.getValue());
                entry.setCompressedSize(length);
                entry.setSize(length);
                break;
            }
            case 8: {
                break;
            }
            default: {
                if (!$assertionsDisabled) {
                    throw new AssertionError((Object)"unsupported method");
                }
                break;
            }
        }
        return new EntryOutputStream(entry);
    }

    public final boolean isBusy() {
        return super.isBusy() || this.tempEntry != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeTempEntry(ZipEntry entry, java.io.File temp) throws IOException {
        if (!$assertionsDisabled && entry.getMethod() != 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && entry.getCrc() == -1L) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && entry.getCompressedSize() == -1L) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && entry.getSize() == -1L) {
            throw new AssertionError();
        }
        try {
            FileInputStream in = new FileInputStream(temp);
            try {
                this.putNextEntry(entry);
                try {
                    File.cat(in, this);
                }
                finally {
                    this.closeEntry();
                }
            }
            finally {
                ((InputStream)in).close();
            }
        }
        finally {
            if (!temp.delete()) {
                temp.deleteOnExit();
            }
        }
    }

    public final void storeDirectory(ArchiveEntry entry) throws IOException {
        if (!$assertionsDisabled) {
            throw new AssertionError((Object)"Since TrueZIP 6.5, this is not used anymore!");
        }
        if (!entry.isDirectory()) {
            throw new IllegalArgumentException();
        }
        this.getOutputStream(entry, null).close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finish() throws IOException {
        super.finish();
        if (this.source == null) {
            return;
        }
        long ipl = this.source.getPostambleLength();
        if (ipl <= 0L) {
            return;
        }
        long il = this.source.length();
        long ol = this.length();
        InputStream in = this.source.getPostambleInputStream();
        try {
            if (ol + ipl != il) {
                this.write(new byte[(int)(ol % 4L)]);
            }
            File.cat(in, this);
        }
        finally {
            in.close();
        }
    }

    public OutputArchiveMetaData getMetaData() {
        return this.metaData;
    }

    public void setMetaData(OutputArchiveMetaData metaData) {
        this.metaData = metaData;
    }

    static {
        $assertionsDisabled = !ZipOutputArchive.class.desiredAssertionStatus();
    }

    private static class Crc32OutputStream
    extends OutputStream {
        private final CRC32 crc = new CRC32();

        private Crc32OutputStream() {
        }

        public void write(int b) {
            this.crc.update(b);
        }

        public void write(byte[] b, int off, int len) {
            this.crc.update(b, off, len);
        }
    }

    private class TempEntryOutputStream
    extends CheckedOutputStream {
        private final java.io.File temp;
        private boolean closed;
        static final /* synthetic */ boolean $assertionsDisabled;

        public TempEntryOutputStream(ZipEntry entry, java.io.File temp) throws IOException {
            super(new FileOutputStream(temp), new CRC32());
            if (!$assertionsDisabled && entry.getMethod() != 0) {
                throw new AssertionError();
            }
            this.temp = temp;
            ZipOutputArchive.this.tempEntry = entry;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            this.closed = true;
            try {
                try {
                    super.close();
                }
                finally {
                    long length = this.temp.length();
                    if (length > Integer.MAX_VALUE) {
                        throw new IOException("file too large");
                    }
                    ZipOutputArchive.this.tempEntry.setCrc(this.getChecksum().getValue());
                    ZipOutputArchive.this.tempEntry.setCompressedSize(length);
                    ZipOutputArchive.this.tempEntry.setSize(length);
                    ZipOutputArchive.this.storeTempEntry(ZipOutputArchive.this.tempEntry, this.temp);
                }
            }
            finally {
                ZipOutputArchive.this.tempEntry = null;
            }
        }

        static {
            $assertionsDisabled = !(class$de$schlichtherle$io$archive$zip$ZipOutputArchive == null ? (class$de$schlichtherle$io$archive$zip$ZipOutputArchive = ZipOutputArchive.class$("de.schlichtherle.io.archive.zip.ZipOutputArchive")) : class$de$schlichtherle$io$archive$zip$ZipOutputArchive).desiredAssertionStatus();
        }
    }

    private class EntryOutputStream
    extends FilterOutputStream {
        private EntryOutputStream(ZipEntry entry) throws IOException {
            this(entry, true);
        }

        private EntryOutputStream(ZipEntry entry, boolean deflate) throws IOException {
            super(ZipOutputArchive.this);
            ZipOutputArchive.this.putNextEntry(entry, deflate);
        }

        public void write(byte[] b) throws IOException {
            this.out.write(b, 0, b.length);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.out.write(b, off, len);
        }

        public void close() throws IOException {
            ZipOutputArchive.this.closeEntry();
        }
    }
}

