/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.util.zip;

import de.schlichtherle.util.zip.DateTimeConverter;
import de.schlichtherle.util.zip.DefaultExtraField;
import de.schlichtherle.util.zip.ExtraField;
import de.schlichtherle.util.zip.ExtraFields;
import de.schlichtherle.util.zip.LittleEndian;
import de.schlichtherle.util.zip.UByte;
import de.schlichtherle.util.zip.UInt;
import de.schlichtherle.util.zip.ULong;
import de.schlichtherle.util.zip.UShort;
import de.schlichtherle.util.zip.ZIP;
import java.io.UnsupportedEncodingException;

public class ZipEntry
implements Cloneable {
    private static final int NAME = 0;
    private static final int PLATFORM = 1;
    private static final int GENERAL = 2;
    private static final int METHOD = 3;
    private static final int CRC = 4;
    public static final byte UNKNOWN = -1;
    public static final short PLATFORM_FAT = 0;
    public static final short PLATFORM_UNIX = 3;
    public static final int STORED = 0;
    public static final int DEFLATED = 8;
    public static final long MIN_DOS_TIME = 0x210000L;
    private byte init;
    private String name;
    private byte platform = (byte)-1;
    private short general = (short)-1;
    private short method = (short)-1;
    private long jTime = -1L;
    private int crc = -1;
    private long csize = -1L;
    private long size = -1L;
    private long offset = -1L;
    private ExtraFields fields;
    private String comment;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ZipEntry(String name) {
        this.setName0(name);
    }

    public ZipEntry(ZipEntry blueprint) {
        this.init = blueprint.init;
        this.name = blueprint.name;
        this.platform = blueprint.platform;
        this.general = blueprint.general;
        this.method = blueprint.method;
        this.jTime = blueprint.jTime;
        this.crc = blueprint.crc;
        this.csize = blueprint.csize;
        this.size = blueprint.size;
        this.offset = blueprint.offset;
        this.setExtra(blueprint.getExtra());
        this.comment = blueprint.comment;
        this.setInit(0, false);
    }

    public Object clone() {
        try {
            ZipEntry entry = (ZipEntry)super.clone();
            entry.setExtra(this.getExtra());
            entry.setInit(0, false);
            return entry;
        }
        catch (CloneNotSupportedException cannotHappen) {
            throw new AssertionError((Object)cannotHappen);
        }
    }

    private final boolean isInit(int index) {
        if (!($assertionsDisabled || 0 <= index && index < 8)) {
            throw new AssertionError((Object)("Bit index out of range: " + index));
        }
        return (this.init & 1 << index) != 0;
    }

    private final void setInit(int index, boolean init) {
        if (!($assertionsDisabled || 0 <= index && index < 8)) {
            throw new AssertionError((Object)("Bit index out of range: " + index));
        }
        this.init = init ? (byte)(this.init | 1 << index) : (byte)(this.init & ~(1 << index));
    }

    public String getName() {
        return this.name;
    }

    final int getNameLength(String charset) throws UnsupportedEncodingException {
        return this.name != null ? this.name.getBytes(charset).length : 0;
    }

    protected void setName(String name) {
        this.setName0(name);
    }

    private void setName0(String name) {
        if (this.isInit(0)) {
            throw new IllegalStateException("'name' has already been set!");
        }
        if (name == null) {
            throw new NullPointerException("'name' must not be null!");
        }
        UShort.check(name.length());
        this.setInit(0, true);
        this.name = name;
    }

    public boolean isDirectory() {
        return this.name.endsWith("/");
    }

    public short getPlatform() {
        return this.isInit(1) ? (short)(this.platform & 0xFF) : (short)-1;
    }

    public void setPlatform(short platform) {
        boolean known;
        boolean bl = known = platform != -1;
        if (known) {
            UByte.check(platform, this.name, "Platform out of range");
        }
        this.setInit(1, known);
        this.platform = (byte)platform;
    }

    int getGeneral() {
        return this.isInit(2) ? this.general & 0xFFFF : -1;
    }

    void setGeneral(int general) {
        boolean known;
        boolean bl = known = general != -1;
        if (known) {
            UShort.check(general, this.name, "General Purpose Bit Flag out of range");
        }
        this.setInit(2, known);
        this.general = (short)general;
    }

    final boolean getGeneralBit(int index) {
        if (!this.isInit(2)) {
            throw new IllegalStateException(this.name + ": General Purpose Bit Flag not initialized!");
        }
        if (index < 0 || 15 < index) {
            throw new IllegalArgumentException(this.name + ": General Purpose Bit Flag index out of range: " + index);
        }
        return (this.general & 1 << index) != 0;
    }

    final void setGeneralBit(int index, boolean bit) {
        if (index < 0 || 15 < index) {
            throw new IllegalArgumentException(this.name + ": General Purpose Bit Flag index out of range: " + index);
        }
        this.setInit(2, true);
        this.general = bit ? (short)(this.general | 1 << index) : (short)(this.general & ~(1 << index));
    }

    public int getMethod() {
        return this.isInit(3) ? this.method & 0xFFFF : -1;
    }

    public void setMethod(int method) {
        boolean known;
        boolean bl = known = method != -1;
        if (known && method != 0 && method != 8) {
            throw new IllegalArgumentException(this.name + ": unsupported Compression Method: " + method);
        }
        this.setInit(3, known);
        this.method = (short)method;
    }

    protected long getDosTime() {
        return this.jTime != -1L ? this.getDateTimeConverter().toDosTime(this.jTime) : -1L;
    }

    protected void setDosTime(long dTime) {
        this.jTime = dTime != -1L ? this.getDateTimeConverter().toJavaTime(dTime) : -1L;
    }

    public long getTime() {
        return this.jTime;
    }

    public void setTime(long jTime) {
        this.jTime = jTime != -1L ? this.getDateTimeConverter().toJavaTime(this.getDateTimeConverter().toDosTime(jTime)) : -1L;
    }

    protected DateTimeConverter getDateTimeConverter() {
        return DateTimeConverter.JAR;
    }

    public long getCrc() {
        return this.isInit(4) ? (long)this.crc & 0xFFFFFFFFL : -1L;
    }

    public void setCrc(long crc) {
        boolean known;
        boolean bl = known = crc != -1L;
        if (known) {
            UInt.check(crc, this.name, "CRC-32 out of range");
        }
        this.setInit(4, known);
        this.crc = (int)crc;
    }

    long getCompressedSize32() {
        if (this.csize == -1L) {
            return -1L;
        }
        return this.csize > 0xFFFFFFFFL || ZIP.ZIP64_EXT ? 0xFFFFFFFFL : this.csize;
    }

    void setCompressedSize32(long csize) {
        if (csize != -1L) {
            UInt.check(csize, this.name, "Compressed Size out of range");
        }
        this.csize = csize;
    }

    public long getCompressedSize() {
        return this.csize;
    }

    public void setCompressedSize(long csize) {
        this.setCompressedSize64(csize);
    }

    private final void setCompressedSize64(long csize) {
        if (csize != -1L) {
            ULong.check(csize, this.name, "Compressed Size out of range");
        }
        this.csize = csize;
    }

    long getSize32() {
        if (this.size == -1L) {
            return -1L;
        }
        return this.size > 0xFFFFFFFFL || ZIP.ZIP64_EXT ? 0xFFFFFFFFL : this.size;
    }

    void setSize32(long size) {
        if (size != -1L) {
            UInt.check(size, this.name, "Uncompressed Size out of range");
        }
        this.size = size;
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        this.setSize64(size);
    }

    private final void setSize64(long size) {
        if (size != -1L) {
            ULong.check(size, this.name, "Uncompressed Size out of range");
        }
        this.size = size;
    }

    long getOffset32() {
        if (this.offset == -1L) {
            return -1L;
        }
        return this.offset > 0xFFFFFFFFL || ZIP.ZIP64_EXT ? 0xFFFFFFFFL : this.offset;
    }

    void setOffset32(long offset) {
        if (offset != -1L) {
            UInt.check(offset, this.name, "Relative Header Offset out of range");
        }
        this.offset = offset;
    }

    long getOffset() {
        return this.offset;
    }

    void setOffset(long offset) {
        this.setOffset64(offset);
    }

    private final void setOffset64(long offset) {
        if (offset != -1L) {
            ULong.check(offset, this.name, "Relative Header Offset out of range");
        }
        this.offset = offset;
    }

    public byte[] getExtra() {
        return this.getExtra(true);
    }

    byte[] getExtra(boolean zip64) {
        ExtraFields fields = this.getFields(zip64);
        return fields != null ? fields.getExtra() : ZIP.EMPTY;
    }

    private ExtraFields getFields(boolean zip64) {
        ExtraField field;
        ExtraFields fields = this.fields;
        if (zip64) {
            ExtraField field2 = this.compileZip64ExtraField();
            if (field2 != null) {
                fields = fields != null ? (ExtraFields)fields.clone() : new ExtraFields();
                fields.put(field2);
            }
        } else if (fields != null && (field = fields.get(1)) != null) {
            fields = (ExtraFields)fields.clone();
            field = fields.remove(1);
            if (!$assertionsDisabled && 1 != field.getHeaderID()) {
                throw new AssertionError();
            }
        }
        return fields;
    }

    final int getExtraLength() {
        return this.getExtra(true).length;
    }

    public void setExtra(byte[] data) {
        if (data == null || data.length <= 0) {
            this.fields = null;
        } else {
            if (this.fields == null) {
                this.fields = new ExtraFields();
            }
            this.fields.readFrom(data, 0, data.length);
            this.parseZip64ExtraField();
            this.fields.remove(1);
            if (this.fields.size() <= 0) {
                if (!$assertionsDisabled && this.fields.size() != 0) {
                    throw new AssertionError();
                }
                this.fields = null;
            }
        }
    }

    private void parseZip64ExtraField() {
        long offset;
        long csize;
        if (this.fields == null) {
            return;
        }
        ExtraField ef = this.fields.get(1);
        if (ef == null) {
            return;
        }
        byte[] data = ef.getDataBlock();
        int off = 0;
        long size = this.getSize32();
        if (size >= 0xFFFFFFFFL) {
            if (!$assertionsDisabled && size != 0xFFFFFFFFL) {
                throw new AssertionError();
            }
            this.setSize64(LittleEndian.readLong(data, off));
            off += 8;
        }
        if ((csize = this.getCompressedSize32()) >= 0xFFFFFFFFL) {
            if (!$assertionsDisabled && csize != 0xFFFFFFFFL) {
                throw new AssertionError();
            }
            this.setCompressedSize64(LittleEndian.readLong(data, off));
            off += 8;
        }
        if ((offset = this.getOffset32()) >= 0xFFFFFFFFL) {
            if (!$assertionsDisabled && offset != 0xFFFFFFFFL) {
                throw new AssertionError();
            }
            this.setOffset64(LittleEndian.readLong(data, off));
        }
    }

    private ExtraField compileZip64ExtraField() {
        DefaultExtraField field;
        long offset;
        long csize;
        byte[] data = new byte[24];
        int off = 0;
        long size = this.getSize();
        if (size >= 0xFFFFFFFFL || ZIP.ZIP64_EXT && size >= 0L) {
            LittleEndian.writeLong(size, data, off);
            off += 8;
        }
        if ((csize = this.getCompressedSize()) >= 0xFFFFFFFFL || ZIP.ZIP64_EXT && csize >= 0L) {
            LittleEndian.writeLong(csize, data, off);
            off += 8;
        }
        if ((offset = this.getOffset()) >= 0xFFFFFFFFL || ZIP.ZIP64_EXT && offset >= 0L) {
            LittleEndian.writeLong(offset, data, off);
            off += 8;
        }
        if (off > 0) {
            field = new DefaultExtraField(1);
            ((ExtraField)field).readFrom(data, 0, off);
        } else {
            field = null;
        }
        return field;
    }

    public String getComment() {
        return this.comment;
    }

    final int getCommentLength(String charset) throws UnsupportedEncodingException {
        return this.comment != null ? this.comment.getBytes(charset).length : 0;
    }

    public void setComment(String comment) {
        if (comment != null) {
            UShort.check(comment.length(), this.name, "Comment too long");
        }
        this.comment = comment;
    }

    public String toString() {
        return this.getName();
    }

    protected static long java2dosTime(long jTime) {
        return DateTimeConverter.JAR.toDosTime(jTime);
    }

    protected static long dos2javaTime(long dTime) {
        return DateTimeConverter.JAR.toJavaTime(dTime);
    }

    static {
        $assertionsDisabled = !ZipEntry.class.desiredAssertionStatus();
    }
}

