/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.bytes;

import it.unimi.dsi.fastutil.bytes.ByteComparator;
import it.unimi.dsi.fastutil.bytes.BytePriorityQueue;

public class BytePriorityQueues {
    private BytePriorityQueues() {
    }

    public static BytePriorityQueue synchronize(BytePriorityQueue q) {
        return new SynchronizedPriorityQueue(q);
    }

    public static BytePriorityQueue synchronize(BytePriorityQueue q, Object sync) {
        return new SynchronizedPriorityQueue(q, sync);
    }

    public static class SynchronizedPriorityQueue
    implements BytePriorityQueue {
        public static final long serialVersionUID = -7046029254386353129L;
        protected final BytePriorityQueue q;
        protected final Object sync;

        protected SynchronizedPriorityQueue(BytePriorityQueue q, Object sync) {
            this.q = q;
            this.sync = sync;
        }

        protected SynchronizedPriorityQueue(BytePriorityQueue q) {
            this.q = q;
            this.sync = this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void enqueue(byte x) {
            Object object = this.sync;
            synchronized (object) {
                this.q.enqueue(x);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public byte dequeueByte() {
            Object object = this.sync;
            synchronized (object) {
                return this.q.dequeueByte();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public byte firstByte() {
            Object object = this.sync;
            synchronized (object) {
                return this.q.firstByte();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public byte lastByte() {
            Object object = this.sync;
            synchronized (object) {
                return this.q.lastByte();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isEmpty() {
            Object object = this.sync;
            synchronized (object) {
                return this.q.isEmpty();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int size() {
            Object object = this.sync;
            synchronized (object) {
                return this.q.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clear() {
            Object object = this.sync;
            synchronized (object) {
                this.q.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void changed() {
            Object object = this.sync;
            synchronized (object) {
                this.q.changed();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ByteComparator comparator() {
            Object object = this.sync;
            synchronized (object) {
                return this.q.comparator();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void enqueue(Byte x) {
            Object object = this.sync;
            synchronized (object) {
                this.q.enqueue(x);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Byte dequeue() {
            Object object = this.sync;
            synchronized (object) {
                return (Byte)this.q.dequeue();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Byte first() {
            Object object = this.sync;
            synchronized (object) {
                return (Byte)this.q.first();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Byte last() {
            Object object = this.sync;
            synchronized (object) {
                return (Byte)this.q.last();
            }
        }
    }
}

