/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.chars;

import it.unimi.dsi.fastutil.chars.AbstractChar2IntSortedMap;
import it.unimi.dsi.fastutil.chars.Char2IntMap;
import it.unimi.dsi.fastutil.chars.Char2IntSortedMap;
import it.unimi.dsi.fastutil.chars.CharBidirectionalIterator;
import it.unimi.dsi.fastutil.chars.CharComparator;
import it.unimi.dsi.fastutil.chars.CharListIterator;
import it.unimi.dsi.fastutil.chars.CharSortedSet;
import it.unimi.dsi.fastutil.ints.AbstractIntCollection;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import it.unimi.dsi.fastutil.objects.AbstractObjectSortedSet;
import it.unimi.dsi.fastutil.objects.ObjectBidirectionalIterator;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import it.unimi.dsi.fastutil.objects.ObjectSortedSet;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Comparator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.SortedMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Char2IntAVLTreeMap
extends AbstractChar2IntSortedMap
implements Serializable,
Cloneable {
    protected transient Entry tree;
    protected int count;
    protected transient Entry firstEntry;
    protected transient Entry lastEntry;
    protected volatile transient ObjectSortedSet<Map.Entry<Character, Integer>> entries;
    protected volatile transient CharSortedSet keys;
    protected volatile transient IntCollection values;
    protected transient boolean modified;
    protected Comparator<? super Character> storedComparator;
    protected transient CharComparator actualComparator;
    public static final long serialVersionUID = -7046029254386353129L;
    private static final boolean ASSERTS = false;
    private transient boolean[] dirPath;

    public Char2IntAVLTreeMap() {
        this.allocatePaths();
        this.tree = null;
        this.count = 0;
    }

    private void setActualComparator() {
        this.actualComparator = this.storedComparator == null || this.storedComparator instanceof CharComparator ? (CharComparator)this.storedComparator : new CharComparator(){

            public int compare(char k1, char k2) {
                return Char2IntAVLTreeMap.this.storedComparator.compare(Character.valueOf(k1), Character.valueOf(k2));
            }

            public int compare(Character ok1, Character ok2) {
                return Char2IntAVLTreeMap.this.storedComparator.compare(ok1, ok2);
            }
        };
    }

    public Char2IntAVLTreeMap(Comparator<? super Character> c) {
        this();
        this.storedComparator = c;
        this.setActualComparator();
    }

    public Char2IntAVLTreeMap(Map<? extends Character, ? extends Integer> m) {
        this();
        this.putAll(m);
    }

    public Char2IntAVLTreeMap(SortedMap<Character, Integer> m) {
        this(m.comparator());
        this.putAll((Map<? extends Character, ? extends Integer>)m);
    }

    public Char2IntAVLTreeMap(Char2IntMap m) {
        this();
        this.putAll(m);
    }

    public Char2IntAVLTreeMap(Char2IntSortedMap m) {
        this(m.comparator());
        this.putAll(m);
    }

    public Char2IntAVLTreeMap(char[] k, int[] v, Comparator<? super Character> c) {
        this(c);
        if (k.length != v.length) {
            throw new IllegalArgumentException("The key array and the value array have different lengths (" + k.length + " and " + v.length + ")");
        }
        for (int i = 0; i < k.length; ++i) {
            this.put(k[i], v[i]);
        }
    }

    public Char2IntAVLTreeMap(char[] k, int[] v) {
        this(k, v, null);
    }

    final int compare(char k1, char k2) {
        return this.actualComparator == null ? (k1 < k2 ? -1 : (k1 == k2 ? 0 : 1)) : this.actualComparator.compare(k1, k2);
    }

    final Entry findKey(char k) {
        int cmp;
        Entry e = this.tree;
        while (e != null && (cmp = this.compare(k, e.key)) != 0) {
            e = cmp < 0 ? e.left() : e.right();
        }
        return e;
    }

    final Entry locateKey(char k) {
        Entry e = this.tree;
        Entry last = this.tree;
        int cmp = 0;
        while (e != null && (cmp = this.compare(k, e.key)) != 0) {
            last = e;
            e = cmp < 0 ? e.left() : e.right();
        }
        return cmp == 0 ? e : last;
    }

    private void allocatePaths() {
        this.dirPath = new boolean[48];
    }

    @Override
    public int put(char k, int v) {
        this.modified = false;
        if (this.tree == null) {
            ++this.count;
            this.lastEntry = this.firstEntry = new Entry(k, v);
            this.tree = this.firstEntry;
            this.modified = true;
        } else {
            Entry p = this.tree;
            Entry q = null;
            Entry y = this.tree;
            Entry z = null;
            Entry e = null;
            Entry w = null;
            int i = 0;
            while (true) {
                int cmp;
                if ((cmp = this.compare(k, p.key)) == 0) {
                    int oldValue = p.value;
                    p.value = v;
                    return oldValue;
                }
                if ((byte)p.info != 0) {
                    i = 0;
                    z = q;
                    y = p;
                }
                if (this.dirPath[i++] = cmp > 0) {
                    if (p.succ()) {
                        ++this.count;
                        e = new Entry(k, v);
                        this.modified = true;
                        if (p.right == null) {
                            this.lastEntry = e;
                        }
                        e.left = p;
                        e.right = p.right;
                        p.right(e);
                        break;
                    }
                    q = p;
                    p = p.right;
                    continue;
                }
                if (p.pred()) {
                    ++this.count;
                    e = new Entry(k, v);
                    this.modified = true;
                    if (p.left == null) {
                        this.firstEntry = e;
                    }
                    e.right = p;
                    e.left = p.left;
                    p.left(e);
                    break;
                }
                q = p;
                p = p.left;
            }
            p = y;
            i = 0;
            while (p != e) {
                if (this.dirPath[i]) {
                    p.incBalance();
                } else {
                    p.decBalance();
                }
                p = this.dirPath[i++] ? p.right : p.left;
            }
            if ((byte)y.info == -2) {
                Entry x = y.left;
                if ((byte)x.info == -1) {
                    w = x;
                    if (x.succ()) {
                        x.succ(false);
                        y.pred(x);
                    } else {
                        y.left = x.right;
                    }
                    x.right = y;
                    x.balance(0);
                    y.balance(0);
                } else {
                    w = x.right;
                    x.right = w.left;
                    w.left = x;
                    y.left = w.right;
                    w.right = y;
                    if ((byte)w.info == -1) {
                        x.balance(0);
                        y.balance(1);
                    } else if ((byte)w.info == 0) {
                        x.balance(0);
                        y.balance(0);
                    } else {
                        x.balance(-1);
                        y.balance(0);
                    }
                    w.balance(0);
                    if (w.pred()) {
                        x.succ(w);
                        w.pred(false);
                    }
                    if (w.succ()) {
                        y.pred(w);
                        w.succ(false);
                    }
                }
            } else if ((byte)y.info == 2) {
                Entry x = y.right;
                if ((byte)x.info == 1) {
                    w = x;
                    if (x.pred()) {
                        x.pred(false);
                        y.succ(x);
                    } else {
                        y.right = x.left;
                    }
                    x.left = y;
                    x.balance(0);
                    y.balance(0);
                } else {
                    w = x.left;
                    x.left = w.right;
                    w.right = x;
                    y.right = w.left;
                    w.left = y;
                    if ((byte)w.info == 1) {
                        x.balance(0);
                        y.balance(-1);
                    } else if ((byte)w.info == 0) {
                        x.balance(0);
                        y.balance(0);
                    } else {
                        x.balance(1);
                        y.balance(0);
                    }
                    w.balance(0);
                    if (w.pred()) {
                        y.succ(w);
                        w.pred(false);
                    }
                    if (w.succ()) {
                        x.pred(w);
                        w.succ(false);
                    }
                }
            } else {
                return this.defRetValue;
            }
            if (z == null) {
                this.tree = w;
            } else if (z.left == y) {
                z.left = w;
            } else {
                z.right = w;
            }
        }
        return this.defRetValue;
    }

    private Entry parent(Entry e) {
        Entry y;
        if (e == this.tree) {
            return null;
        }
        Entry x = y = e;
        while (true) {
            if (y.succ()) {
                Entry p = y.right;
                if (p == null || p.left != e) {
                    while (!x.pred()) {
                        x = x.left;
                    }
                    p = x.left;
                }
                return p;
            }
            if (x.pred()) {
                Entry p = x.left;
                if (p == null || p.right != e) {
                    while (!y.succ()) {
                        y = y.right;
                    }
                    p = y.right;
                }
                return p;
            }
            x = x.left;
            y = y.right;
        }
    }

    @Override
    public int remove(char k) {
        int cmp;
        this.modified = false;
        if (this.tree == null) {
            return this.defRetValue;
        }
        Entry p = this.tree;
        Entry q = null;
        boolean dir = false;
        char kk = k;
        while ((cmp = this.compare(kk, p.key)) != 0) {
            dir = cmp > 0;
            if (dir) {
                q = p;
                if ((p = p.right()) != null) continue;
                return this.defRetValue;
            }
            q = p;
            if ((p = p.left()) != null) continue;
            return this.defRetValue;
        }
        if (p.left == null) {
            this.firstEntry = p.next();
        }
        if (p.right == null) {
            this.lastEntry = p.prev();
        }
        if (p.succ()) {
            if (p.pred()) {
                if (q != null) {
                    if (dir) {
                        q.succ(p.right);
                    } else {
                        q.pred(p.left);
                    }
                } else {
                    this.tree = dir ? p.right : p.left;
                }
            } else {
                p.prev().right = p.right;
                if (q != null) {
                    if (dir) {
                        q.right = p.left;
                    } else {
                        q.left = p.left;
                    }
                } else {
                    this.tree = p.left;
                }
            }
        } else {
            Entry r = p.right;
            if (r.pred()) {
                r.left = p.left;
                r.pred(p.pred());
                if (!r.pred()) {
                    r.prev().right = r;
                }
                if (q != null) {
                    if (dir) {
                        q.right = r;
                    } else {
                        q.left = r;
                    }
                } else {
                    this.tree = r;
                }
                r.balance((byte)p.info);
                q = r;
                dir = true;
            } else {
                Entry s;
                while (!(s = r.left).pred()) {
                    r = s;
                }
                if (s.succ()) {
                    r.pred(s);
                } else {
                    r.left = s.right;
                }
                s.left = p.left;
                if (!p.pred()) {
                    p.prev().right = s;
                    s.pred(false);
                }
                s.right = p.right;
                s.succ(false);
                if (q != null) {
                    if (dir) {
                        q.right = s;
                    } else {
                        q.left = s;
                    }
                } else {
                    this.tree = s;
                }
                s.balance((byte)p.info);
                q = r;
                dir = false;
            }
        }
        while (q != null) {
            Entry w;
            Entry x;
            Entry y = q;
            q = this.parent(y);
            if (!dir) {
                dir = q != null && q.left != y;
                y.incBalance();
                if ((byte)y.info == 1) break;
                if ((byte)y.info != 2) continue;
                x = y.right;
                if ((byte)x.info == -1) {
                    w = x.left;
                    x.left = w.right;
                    w.right = x;
                    y.right = w.left;
                    w.left = y;
                    if ((byte)w.info == 1) {
                        x.balance(0);
                        y.balance(-1);
                    } else if ((byte)w.info == 0) {
                        x.balance(0);
                        y.balance(0);
                    } else {
                        x.balance(1);
                        y.balance(0);
                    }
                    w.balance(0);
                    if (w.pred()) {
                        y.succ(w);
                        w.pred(false);
                    }
                    if (w.succ()) {
                        x.pred(w);
                        w.succ(false);
                    }
                    if (q != null) {
                        if (dir) {
                            q.right = w;
                            continue;
                        }
                        q.left = w;
                        continue;
                    }
                    this.tree = w;
                    continue;
                }
                if (q != null) {
                    if (dir) {
                        q.right = x;
                    } else {
                        q.left = x;
                    }
                } else {
                    this.tree = x;
                }
                if ((byte)x.info == 0) {
                    y.right = x.left;
                    x.left = y;
                    x.balance(-1);
                    y.balance(1);
                    break;
                }
                if (x.pred()) {
                    y.succ(true);
                    x.pred(false);
                } else {
                    y.right = x.left;
                }
                x.left = y;
                y.balance(0);
                x.balance(0);
                continue;
            }
            dir = q != null && q.left != y;
            y.decBalance();
            if ((byte)y.info == -1) break;
            if ((byte)y.info != -2) continue;
            x = y.left;
            if ((byte)x.info == 1) {
                w = x.right;
                x.right = w.left;
                w.left = x;
                y.left = w.right;
                w.right = y;
                if ((byte)w.info == -1) {
                    x.balance(0);
                    y.balance(1);
                } else if ((byte)w.info == 0) {
                    x.balance(0);
                    y.balance(0);
                } else {
                    x.balance(-1);
                    y.balance(0);
                }
                w.balance(0);
                if (w.pred()) {
                    x.succ(w);
                    w.pred(false);
                }
                if (w.succ()) {
                    y.pred(w);
                    w.succ(false);
                }
                if (q != null) {
                    if (dir) {
                        q.right = w;
                        continue;
                    }
                    q.left = w;
                    continue;
                }
                this.tree = w;
                continue;
            }
            if (q != null) {
                if (dir) {
                    q.right = x;
                } else {
                    q.left = x;
                }
            } else {
                this.tree = x;
            }
            if ((byte)x.info == 0) {
                y.left = x.right;
                x.right = y;
                x.balance(1);
                y.balance(-1);
                break;
            }
            if (x.succ()) {
                y.pred(true);
                x.succ(false);
            } else {
                y.left = x.right;
            }
            x.right = y;
            y.balance(0);
            x.balance(0);
        }
        this.modified = true;
        --this.count;
        return p.value;
    }

    @Override
    public Integer put(Character ok, Integer ov) {
        int oldValue = this.put(ok.charValue(), (int)ov);
        return this.modified ? null : Integer.valueOf(oldValue);
    }

    @Override
    public Integer remove(Object ok) {
        int oldValue = this.remove(((Character)ok).charValue());
        return this.modified ? Integer.valueOf(oldValue) : null;
    }

    @Override
    public boolean containsValue(int v) {
        ValueIterator i = new ValueIterator();
        int j = this.count;
        while (j-- != 0) {
            int ev = i.nextInt();
            if (ev != v) continue;
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        this.count = 0;
        this.tree = null;
        this.entries = null;
        this.values = null;
        this.keys = null;
        this.lastEntry = null;
        this.firstEntry = null;
    }

    @Override
    public boolean containsKey(char k) {
        return this.findKey(k) != null;
    }

    @Override
    public int size() {
        return this.count;
    }

    @Override
    public boolean isEmpty() {
        return this.count == 0;
    }

    @Override
    public int get(char k) {
        Entry e = this.findKey(k);
        return e == null ? this.defRetValue : e.value;
    }

    @Override
    public char firstCharKey() {
        if (this.tree == null) {
            throw new NoSuchElementException();
        }
        return this.firstEntry.key;
    }

    @Override
    public char lastCharKey() {
        if (this.tree == null) {
            throw new NoSuchElementException();
        }
        return this.lastEntry.key;
    }

    @Override
    public ObjectSortedSet<Map.Entry<Character, Integer>> entrySet() {
        if (this.entries == null) {
            this.entries = new AbstractObjectSortedSet<Map.Entry<Character, Integer>>(){
                final Comparator<? super Map.Entry<Character, Integer>> comparator = new Comparator<Map.Entry<Character, Integer>>(){

                    @Override
                    public int compare(Map.Entry<Character, Integer> x, Map.Entry<Character, Integer> y) {
                        return Char2IntAVLTreeMap.this.storedComparator.compare(x.getKey(), y.getKey());
                    }
                };

                @Override
                public Comparator<? super Map.Entry<Character, Integer>> comparator() {
                    return this.comparator;
                }

                @Override
                public ObjectBidirectionalIterator<Map.Entry<Character, Integer>> iterator() {
                    return new EntryIterator();
                }

                @Override
                public ObjectBidirectionalIterator<Map.Entry<Character, Integer>> iterator(Map.Entry<Character, Integer> from) {
                    return new EntryIterator(from.getKey().charValue());
                }

                @Override
                public boolean contains(Object o) {
                    if (!(o instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry e = (Map.Entry)o;
                    Entry f = Char2IntAVLTreeMap.this.findKey(((Character)e.getKey()).charValue());
                    return ((Object)e).equals(f);
                }

                @Override
                public boolean remove(Object o) {
                    if (!(o instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry e = (Map.Entry)o;
                    Entry f = Char2IntAVLTreeMap.this.findKey(((Character)e.getKey()).charValue());
                    if (f != null) {
                        Char2IntAVLTreeMap.this.remove(f.key);
                    }
                    return f != null;
                }

                @Override
                public int size() {
                    return Char2IntAVLTreeMap.this.count;
                }

                @Override
                public void clear() {
                    Char2IntAVLTreeMap.this.clear();
                }

                @Override
                public Map.Entry<Character, Integer> first() {
                    return Char2IntAVLTreeMap.this.firstEntry;
                }

                @Override
                public Map.Entry<Character, Integer> last() {
                    return Char2IntAVLTreeMap.this.lastEntry;
                }

                @Override
                public ObjectSortedSet<Map.Entry<Character, Integer>> subSet(Map.Entry<Character, Integer> from, Map.Entry<Character, Integer> to) {
                    return Char2IntAVLTreeMap.this.subMap(from.getKey(), to.getKey()).entrySet();
                }

                @Override
                public ObjectSortedSet<Map.Entry<Character, Integer>> headSet(Map.Entry<Character, Integer> to) {
                    return Char2IntAVLTreeMap.this.headMap(to.getKey()).entrySet();
                }

                @Override
                public ObjectSortedSet<Map.Entry<Character, Integer>> tailSet(Map.Entry<Character, Integer> from) {
                    return Char2IntAVLTreeMap.this.tailMap(from.getKey()).entrySet();
                }
            };
        }
        return this.entries;
    }

    @Override
    public CharSortedSet keySet() {
        if (this.keys == null) {
            this.keys = new KeySet();
        }
        return this.keys;
    }

    @Override
    public IntCollection values() {
        if (this.values == null) {
            this.values = new AbstractIntCollection(){

                public IntIterator iterator() {
                    return new ValueIterator();
                }

                public boolean contains(int k) {
                    return Char2IntAVLTreeMap.this.containsValue(k);
                }

                public int size() {
                    return Char2IntAVLTreeMap.this.count;
                }

                public void clear() {
                    Char2IntAVLTreeMap.this.clear();
                }
            };
        }
        return this.values;
    }

    @Override
    public CharComparator comparator() {
        return this.actualComparator;
    }

    @Override
    public Char2IntSortedMap headMap(char to) {
        return new Submap('\u0000', true, to, false);
    }

    @Override
    public Char2IntSortedMap tailMap(char from) {
        return new Submap(from, false, '\u0000', true);
    }

    @Override
    public Char2IntSortedMap subMap(char from, char to) {
        return new Submap(from, false, to, false);
    }

    public Object clone() {
        Char2IntAVLTreeMap c;
        try {
            c = (Char2IntAVLTreeMap)super.clone();
        }
        catch (CloneNotSupportedException cantHappen) {
            throw new InternalError();
        }
        c.keys = null;
        c.values = null;
        c.entries = null;
        c.allocatePaths();
        if (this.count != 0) {
            Entry rp = new Entry();
            Entry rq = new Entry();
            Entry p = rp;
            rp.left(this.tree);
            Entry q = rq;
            rq.pred(null);
            while (true) {
                Entry e;
                if (!p.pred()) {
                    e = (Entry)p.left.clone();
                    e.pred(q.left);
                    e.succ(q);
                    q.left(e);
                    p = p.left;
                    q = q.left;
                } else {
                    while (p.succ()) {
                        p = p.right;
                        if (p == null) {
                            q.right = null;
                            c.firstEntry = c.tree = rq.left;
                            while (c.firstEntry.left != null) {
                                c.firstEntry = c.firstEntry.left;
                            }
                            c.lastEntry = c.tree;
                            while (c.lastEntry.right != null) {
                                c.lastEntry = c.lastEntry.right;
                            }
                            return c;
                        }
                        q = q.right;
                    }
                    p = p.right;
                    q = q.right;
                }
                if (p.succ()) continue;
                e = (Entry)p.right.clone();
                e.succ(q.right);
                e.pred(q);
                q.right(e);
            }
        }
        return c;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        int n = this.count;
        EntryIterator i = new EntryIterator();
        s.defaultWriteObject();
        while (n-- != 0) {
            Entry e = i.nextEntry();
            s.writeChar(e.key);
            s.writeInt(e.value);
        }
    }

    private Entry readTree(ObjectInputStream s, int n, Entry pred, Entry succ) throws IOException, ClassNotFoundException {
        if (n == 1) {
            Entry top = new Entry(s.readChar(), s.readInt());
            top.pred(pred);
            top.succ(succ);
            return top;
        }
        if (n == 2) {
            Entry top = new Entry(s.readChar(), s.readInt());
            top.right(new Entry(s.readChar(), s.readInt()));
            top.right.pred(top);
            top.balance(1);
            top.pred(pred);
            top.right.succ(succ);
            return top;
        }
        int rightN = n / 2;
        int leftN = n - rightN - 1;
        Entry top = new Entry();
        top.left(this.readTree(s, leftN, pred, top));
        top.key = s.readChar();
        top.value = s.readInt();
        top.right(this.readTree(s, rightN, top, succ));
        if (n == (n & -n)) {
            top.balance(1);
        }
        return top;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.setActualComparator();
        this.allocatePaths();
        if (this.count != 0) {
            Entry e = this.tree = this.readTree(s, this.count, null, null);
            while (e.left() != null) {
                e = e.left();
            }
            this.firstEntry = e;
            e = this.tree;
            while (e.right() != null) {
                e = e.right();
            }
            this.lastEntry = e;
        }
    }

    private static int checkTree(Entry e) {
        return 0;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class Submap
    extends AbstractChar2IntSortedMap
    implements Serializable {
        public static final long serialVersionUID = -7046029254386353129L;
        char from;
        char to;
        boolean bottom;
        boolean top;
        protected volatile transient ObjectSortedSet<Map.Entry<Character, Integer>> entries;
        protected volatile transient CharSortedSet keys;
        protected volatile transient IntCollection values;

        public Submap(char from, boolean bottom, char to, boolean top) {
            if (!bottom && !top && Char2IntAVLTreeMap.this.compare(from, to) > 0) {
                throw new IllegalArgumentException("Start key (" + from + ") is larger than end key (" + to + ")");
            }
            this.from = from;
            this.bottom = bottom;
            this.to = to;
            this.top = top;
            this.defRetValue = Char2IntAVLTreeMap.this.defRetValue;
        }

        @Override
        public void clear() {
            SubmapIterator i = new SubmapIterator();
            while (i.hasNext()) {
                i.nextEntry();
                i.remove();
            }
        }

        final boolean in(char k) {
            return !(!this.bottom && Char2IntAVLTreeMap.this.compare(k, this.from) < 0 || !this.top && Char2IntAVLTreeMap.this.compare(k, this.to) >= 0);
        }

        @Override
        public ObjectSortedSet<Map.Entry<Character, Integer>> entrySet() {
            if (this.entries == null) {
                this.entries = new AbstractObjectSortedSet<Map.Entry<Character, Integer>>(){

                    @Override
                    public ObjectBidirectionalIterator<Map.Entry<Character, Integer>> iterator() {
                        return new SubmapEntryIterator();
                    }

                    @Override
                    public ObjectBidirectionalIterator<Map.Entry<Character, Integer>> iterator(Map.Entry<Character, Integer> from) {
                        return new SubmapEntryIterator(from.getKey().charValue());
                    }

                    @Override
                    public Comparator<? super Map.Entry<Character, Integer>> comparator() {
                        return Char2IntAVLTreeMap.this.entrySet().comparator();
                    }

                    @Override
                    public boolean contains(Object o) {
                        if (!(o instanceof Map.Entry)) {
                            return false;
                        }
                        Map.Entry e = (Map.Entry)o;
                        Entry f = Char2IntAVLTreeMap.this.findKey(((Character)e.getKey()).charValue());
                        return f != null && Submap.this.in(f.key) && ((Object)e).equals(f);
                    }

                    @Override
                    public boolean remove(Object o) {
                        if (!(o instanceof Map.Entry)) {
                            return false;
                        }
                        Map.Entry e = (Map.Entry)o;
                        Entry f = Char2IntAVLTreeMap.this.findKey(((Character)e.getKey()).charValue());
                        if (f != null && Submap.this.in(f.key)) {
                            Submap.this.remove(f.key);
                        }
                        return f != null;
                    }

                    @Override
                    public int size() {
                        int c = 0;
                        ObjectIterator i = this.iterator();
                        while (i.hasNext()) {
                            ++c;
                            i.next();
                        }
                        return c;
                    }

                    @Override
                    public boolean isEmpty() {
                        return !new SubmapIterator().hasNext();
                    }

                    @Override
                    public void clear() {
                        Submap.this.clear();
                    }

                    @Override
                    public Map.Entry<Character, Integer> first() {
                        return Submap.this.firstEntry();
                    }

                    @Override
                    public Map.Entry<Character, Integer> last() {
                        return Submap.this.lastEntry();
                    }

                    @Override
                    public ObjectSortedSet<Map.Entry<Character, Integer>> subSet(Map.Entry<Character, Integer> from, Map.Entry<Character, Integer> to) {
                        return Submap.this.subMap(from.getKey(), to.getKey()).entrySet();
                    }

                    @Override
                    public ObjectSortedSet<Map.Entry<Character, Integer>> headSet(Map.Entry<Character, Integer> to) {
                        return Submap.this.headMap(to.getKey()).entrySet();
                    }

                    @Override
                    public ObjectSortedSet<Map.Entry<Character, Integer>> tailSet(Map.Entry<Character, Integer> from) {
                        return Submap.this.tailMap(from.getKey()).entrySet();
                    }
                };
            }
            return this.entries;
        }

        @Override
        public CharSortedSet keySet() {
            if (this.keys == null) {
                this.keys = new KeySet();
            }
            return this.keys;
        }

        @Override
        public IntCollection values() {
            if (this.values == null) {
                this.values = new AbstractIntCollection(){

                    public IntIterator iterator() {
                        return new SubmapValueIterator();
                    }

                    public boolean contains(int k) {
                        return Submap.this.containsValue(k);
                    }

                    public int size() {
                        return Submap.this.size();
                    }

                    public void clear() {
                        Submap.this.clear();
                    }
                };
            }
            return this.values;
        }

        @Override
        public boolean containsKey(char k) {
            return this.in(k) && Char2IntAVLTreeMap.this.containsKey(k);
        }

        @Override
        public boolean containsValue(int v) {
            SubmapIterator i = new SubmapIterator();
            while (i.hasNext()) {
                int ev = i.nextEntry().value;
                if (ev != v) continue;
                return true;
            }
            return false;
        }

        @Override
        public int get(char k) {
            Entry e;
            char kk = k;
            return this.in(kk) && (e = Char2IntAVLTreeMap.this.findKey(kk)) != null ? e.value : this.defRetValue;
        }

        @Override
        public int put(char k, int v) {
            Char2IntAVLTreeMap.this.modified = false;
            if (!this.in(k)) {
                throw new IllegalArgumentException("Key (" + k + ") out of range [" + (this.bottom ? "-" : String.valueOf(this.from)) + ", " + (this.top ? "-" : String.valueOf(this.to)) + ")");
            }
            int oldValue = Char2IntAVLTreeMap.this.put(k, v);
            return Char2IntAVLTreeMap.this.modified ? this.defRetValue : oldValue;
        }

        @Override
        public Integer put(Character ok, Integer ov) {
            int oldValue = this.put(ok.charValue(), (int)ov);
            return Char2IntAVLTreeMap.this.modified ? null : Integer.valueOf(oldValue);
        }

        @Override
        public int remove(char k) {
            Char2IntAVLTreeMap.this.modified = false;
            if (!this.in(k)) {
                return this.defRetValue;
            }
            int oldValue = Char2IntAVLTreeMap.this.remove(k);
            return Char2IntAVLTreeMap.this.modified ? oldValue : this.defRetValue;
        }

        @Override
        public Integer remove(Object ok) {
            int oldValue = this.remove(((Character)ok).charValue());
            return Char2IntAVLTreeMap.this.modified ? Integer.valueOf(oldValue) : null;
        }

        @Override
        public int size() {
            SubmapIterator i = new SubmapIterator();
            int n = 0;
            while (i.hasNext()) {
                ++n;
                i.nextEntry();
            }
            return n;
        }

        @Override
        public boolean isEmpty() {
            return !new SubmapIterator().hasNext();
        }

        @Override
        public CharComparator comparator() {
            return Char2IntAVLTreeMap.this.actualComparator;
        }

        @Override
        public Char2IntSortedMap headMap(char to) {
            if (this.top) {
                return new Submap(this.from, this.bottom, to, false);
            }
            return Char2IntAVLTreeMap.this.compare(to, this.to) < 0 ? new Submap(this.from, this.bottom, to, false) : this;
        }

        @Override
        public Char2IntSortedMap tailMap(char from) {
            if (this.bottom) {
                return new Submap(from, false, this.to, this.top);
            }
            return Char2IntAVLTreeMap.this.compare(from, this.from) > 0 ? new Submap(from, false, this.to, this.top) : this;
        }

        @Override
        public Char2IntSortedMap subMap(char from, char to) {
            if (this.top && this.bottom) {
                return new Submap(from, false, to, false);
            }
            if (!this.top) {
                char c = to = Char2IntAVLTreeMap.this.compare(to, this.to) < 0 ? to : this.to;
            }
            if (!this.bottom) {
                char c = from = Char2IntAVLTreeMap.this.compare(from, this.from) > 0 ? from : this.from;
            }
            if (!this.top && !this.bottom && from == this.from && to == this.to) {
                return this;
            }
            return new Submap(from, false, to, false);
        }

        public Entry firstEntry() {
            Entry e;
            if (Char2IntAVLTreeMap.this.tree == null) {
                return null;
            }
            if (this.bottom) {
                e = Char2IntAVLTreeMap.this.firstEntry;
            } else {
                e = Char2IntAVLTreeMap.this.locateKey(this.from);
                if (Char2IntAVLTreeMap.this.compare(e.key, this.from) < 0) {
                    e = e.next();
                }
            }
            if (e == null || !this.top && Char2IntAVLTreeMap.this.compare(e.key, this.to) >= 0) {
                return null;
            }
            return e;
        }

        public Entry lastEntry() {
            Entry e;
            if (Char2IntAVLTreeMap.this.tree == null) {
                return null;
            }
            if (this.top) {
                e = Char2IntAVLTreeMap.this.lastEntry;
            } else {
                e = Char2IntAVLTreeMap.this.locateKey(this.to);
                if (Char2IntAVLTreeMap.this.compare(e.key, this.to) >= 0) {
                    e = e.prev();
                }
            }
            if (e == null || !this.bottom && Char2IntAVLTreeMap.this.compare(e.key, this.from) < 0) {
                return null;
            }
            return e;
        }

        @Override
        public char firstCharKey() {
            Entry e = this.firstEntry();
            if (e == null) {
                throw new NoSuchElementException();
            }
            return e.key;
        }

        @Override
        public char lastCharKey() {
            Entry e = this.lastEntry();
            if (e == null) {
                throw new NoSuchElementException();
            }
            return e.key;
        }

        @Override
        public Character firstKey() {
            Entry e = this.firstEntry();
            if (e == null) {
                throw new NoSuchElementException();
            }
            return e.getKey();
        }

        @Override
        public Character lastKey() {
            Entry e = this.lastEntry();
            if (e == null) {
                throw new NoSuchElementException();
            }
            return e.getKey();
        }

        private final class SubmapValueIterator
        extends SubmapIterator
        implements IntListIterator {
            private SubmapValueIterator() {
            }

            public int nextInt() {
                return this.nextEntry().value;
            }

            public int previousInt() {
                return this.previousEntry().value;
            }

            public void set(int v) {
                throw new UnsupportedOperationException();
            }

            public void add(int v) {
                throw new UnsupportedOperationException();
            }

            public Integer next() {
                return this.nextEntry().value;
            }

            public Integer previous() {
                return this.previousEntry().value;
            }

            public void set(Integer ok) {
                throw new UnsupportedOperationException();
            }

            public void add(Integer ok) {
                throw new UnsupportedOperationException();
            }
        }

        private final class SubmapKeyIterator
        extends SubmapIterator
        implements CharListIterator {
            public SubmapKeyIterator() {
            }

            public SubmapKeyIterator(char from) {
                super(from);
            }

            public char nextChar() {
                return this.nextEntry().key;
            }

            public char previousChar() {
                return this.previousEntry().key;
            }

            public void set(char k) {
                throw new UnsupportedOperationException();
            }

            public void add(char k) {
                throw new UnsupportedOperationException();
            }

            public Character next() {
                return Character.valueOf(this.nextEntry().key);
            }

            public Character previous() {
                return Character.valueOf(this.previousEntry().key);
            }

            public void set(Character ok) {
                throw new UnsupportedOperationException();
            }

            public void add(Character ok) {
                throw new UnsupportedOperationException();
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class SubmapEntryIterator
        extends SubmapIterator
        implements ObjectListIterator<Map.Entry<Character, Integer>> {
            SubmapEntryIterator() {
            }

            SubmapEntryIterator(char k) {
                super(k);
            }

            @Override
            public Map.Entry<Character, Integer> next() {
                return this.nextEntry();
            }

            @Override
            public Map.Entry<Character, Integer> previous() {
                return this.previousEntry();
            }

            @Override
            public void set(Map.Entry<Character, Integer> ok) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void add(Map.Entry<Character, Integer> ok) {
                throw new UnsupportedOperationException();
            }
        }

        private class SubmapIterator
        extends TreeIterator {
            SubmapIterator() {
                this.next = Submap.this.firstEntry();
            }

            /*
             * Enabled aggressive block sorting
             */
            SubmapIterator(char k) {
                this();
                if (this.next == null) return;
                if (!submap.bottom && submap.Char2IntAVLTreeMap.this.compare(k, this.next.key) < 0) {
                    this.prev = null;
                    return;
                }
                if (!submap.top) {
                    this.prev = submap.lastEntry();
                    if (submap.Char2IntAVLTreeMap.this.compare(k, this.prev.key) >= 0) {
                        this.next = null;
                        return;
                    }
                }
                this.next = submap.Char2IntAVLTreeMap.this.locateKey(k);
                if (submap.Char2IntAVLTreeMap.this.compare(this.next.key, k) <= 0) {
                    this.prev = this.next;
                    this.next = this.next.next();
                    return;
                }
                this.prev = this.next.prev();
            }

            void updatePrevious() {
                this.prev = this.prev.prev();
                if (!Submap.this.bottom && this.prev != null && Char2IntAVLTreeMap.this.compare(this.prev.key, Submap.this.from) < 0) {
                    this.prev = null;
                }
            }

            void updateNext() {
                this.next = this.next.next();
                if (!Submap.this.top && this.next != null && Char2IntAVLTreeMap.this.compare(this.next.key, Submap.this.to) >= 0) {
                    this.next = null;
                }
            }
        }

        private class KeySet
        extends AbstractChar2IntSortedMap.KeySet {
            private KeySet() {
            }

            public CharBidirectionalIterator iterator() {
                return new SubmapKeyIterator();
            }

            public CharBidirectionalIterator iterator(char from) {
                return new SubmapKeyIterator(from);
            }
        }
    }

    private final class ValueIterator
    extends TreeIterator
    implements IntListIterator {
        private ValueIterator() {
        }

        public int nextInt() {
            return this.nextEntry().value;
        }

        public int previousInt() {
            return this.previousEntry().value;
        }

        public void set(int v) {
            throw new UnsupportedOperationException();
        }

        public void add(int v) {
            throw new UnsupportedOperationException();
        }

        public Integer next() {
            return this.nextEntry().value;
        }

        public Integer previous() {
            return this.previousEntry().value;
        }

        public void set(Integer ok) {
            throw new UnsupportedOperationException();
        }

        public void add(Integer ok) {
            throw new UnsupportedOperationException();
        }
    }

    private class KeySet
    extends AbstractChar2IntSortedMap.KeySet {
        private KeySet() {
        }

        public CharBidirectionalIterator iterator() {
            return new KeyIterator();
        }

        public CharBidirectionalIterator iterator(char from) {
            return new KeyIterator(from);
        }
    }

    private final class KeyIterator
    extends TreeIterator
    implements CharListIterator {
        public KeyIterator() {
        }

        public KeyIterator(char k) {
            super(k);
        }

        public char nextChar() {
            return this.nextEntry().key;
        }

        public char previousChar() {
            return this.previousEntry().key;
        }

        public void set(char k) {
            throw new UnsupportedOperationException();
        }

        public void add(char k) {
            throw new UnsupportedOperationException();
        }

        public Character next() {
            return Character.valueOf(this.nextEntry().key);
        }

        public Character previous() {
            return Character.valueOf(this.previousEntry().key);
        }

        public void set(Character ok) {
            throw new UnsupportedOperationException();
        }

        public void add(Character ok) {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EntryIterator
    extends TreeIterator
    implements ObjectListIterator<Map.Entry<Character, Integer>> {
        EntryIterator() {
        }

        EntryIterator(char k) {
            super(k);
        }

        @Override
        public Map.Entry<Character, Integer> next() {
            return this.nextEntry();
        }

        @Override
        public Map.Entry<Character, Integer> previous() {
            return this.previousEntry();
        }

        @Override
        public void set(Map.Entry<Character, Integer> ok) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(Map.Entry<Character, Integer> ok) {
            throw new UnsupportedOperationException();
        }
    }

    private class TreeIterator {
        Entry prev;
        Entry next;
        Entry curr;
        int index = 0;

        TreeIterator() {
            this.next = Char2IntAVLTreeMap.this.firstEntry;
        }

        TreeIterator(char k) {
            this.next = Char2IntAVLTreeMap.this.locateKey(k);
            if (this.next != null) {
                if (Char2IntAVLTreeMap.this.compare(this.next.key, k) <= 0) {
                    this.prev = this.next;
                    this.next = this.next.next();
                } else {
                    this.prev = this.next.prev();
                }
            }
        }

        public boolean hasNext() {
            return this.next != null;
        }

        public boolean hasPrevious() {
            return this.prev != null;
        }

        void updateNext() {
            this.next = this.next.next();
        }

        Entry nextEntry() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.curr = this.prev = this.next;
            ++this.index;
            this.updateNext();
            return this.curr;
        }

        void updatePrevious() {
            this.prev = this.prev.prev();
        }

        Entry previousEntry() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            this.curr = this.next = this.prev;
            --this.index;
            this.updatePrevious();
            return this.curr;
        }

        public int nextIndex() {
            return this.index;
        }

        public int previousIndex() {
            return this.index - 1;
        }

        public void remove() {
            if (this.curr == null) {
                throw new IllegalStateException();
            }
            if (this.curr == this.prev) {
                --this.index;
            }
            this.next = this.prev = this.curr;
            this.updatePrevious();
            this.updateNext();
            Char2IntAVLTreeMap.this.remove(this.curr.key);
            this.curr = null;
        }

        public int skip(int n) {
            int i = n;
            while (i-- != 0 && this.hasNext()) {
                this.nextEntry();
            }
            return n - i - 1;
        }

        public int back(int n) {
            int i = n;
            while (i-- != 0 && this.hasPrevious()) {
                this.previousEntry();
            }
            return n - i - 1;
        }
    }

    private static final class Entry
    implements Cloneable,
    Char2IntMap.Entry {
        private static final int SUCC_MASK = Integer.MIN_VALUE;
        private static final int PRED_MASK = 0x40000000;
        private static final int BALANCE_MASK = 255;
        char key;
        int value;
        Entry left;
        Entry right;
        int info;

        Entry() {
        }

        Entry(Character k, Integer v) {
            this.key = k.charValue();
            this.value = v;
            this.info = -1073741824;
        }

        Entry(char k, int v) {
            this.key = k;
            this.value = v;
            this.info = -1073741824;
        }

        Entry left() {
            return (this.info & 0x40000000) != 0 ? null : this.left;
        }

        Entry right() {
            return (this.info & Integer.MIN_VALUE) != 0 ? null : this.right;
        }

        boolean pred() {
            return (this.info & 0x40000000) != 0;
        }

        boolean succ() {
            return (this.info & Integer.MIN_VALUE) != 0;
        }

        void pred(boolean pred) {
            this.info = pred ? (this.info |= 0x40000000) : (this.info &= 0xBFFFFFFF);
        }

        void succ(boolean succ) {
            this.info = succ ? (this.info |= Integer.MIN_VALUE) : (this.info &= Integer.MAX_VALUE);
        }

        void pred(Entry pred) {
            this.info |= 0x40000000;
            this.left = pred;
        }

        void succ(Entry succ) {
            this.info |= Integer.MIN_VALUE;
            this.right = succ;
        }

        void left(Entry left) {
            this.info &= 0xBFFFFFFF;
            this.left = left;
        }

        void right(Entry right) {
            this.info &= Integer.MAX_VALUE;
            this.right = right;
        }

        int balance() {
            return (byte)this.info;
        }

        void balance(int level) {
            this.info &= 0xFFFFFF00;
            this.info |= level & 0xFF;
        }

        void incBalance() {
            this.info = this.info & 0xFFFFFF00 | (byte)this.info + 1 & 0xFF;
        }

        protected void decBalance() {
            this.info = this.info & 0xFFFFFF00 | (byte)this.info - 1 & 0xFF;
        }

        Entry next() {
            Entry next = this.right;
            if ((this.info & Integer.MIN_VALUE) == 0) {
                while ((next.info & 0x40000000) == 0) {
                    next = next.left;
                }
            }
            return next;
        }

        Entry prev() {
            Entry prev = this.left;
            if ((this.info & 0x40000000) == 0) {
                while ((prev.info & Integer.MIN_VALUE) == 0) {
                    prev = prev.right;
                }
            }
            return prev;
        }

        public Character getKey() {
            return Character.valueOf(this.key);
        }

        public char getCharKey() {
            return this.key;
        }

        public Integer getValue() {
            return this.value;
        }

        public int getIntValue() {
            return this.value;
        }

        public int setValue(int value) {
            int oldValue = this.value;
            this.value = value;
            return oldValue;
        }

        public Integer setValue(Integer value) {
            return this.setValue((int)value);
        }

        public Object clone() {
            Entry c;
            try {
                c = (Entry)super.clone();
            }
            catch (CloneNotSupportedException cantHappen) {
                throw new InternalError();
            }
            c.key = this.key;
            c.value = this.value;
            c.info = this.info;
            return c;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return this.key == ((Character)e.getKey()).charValue() && this.value == (Integer)e.getValue();
        }

        public int hashCode() {
            return this.key ^ this.value;
        }

        public String toString() {
            return this.key + "=>" + this.value;
        }
    }
}

