/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.longs;

import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.doubles.AbstractDoubleCollection;
import it.unimi.dsi.fastutil.doubles.AbstractDoubleIterator;
import it.unimi.dsi.fastutil.doubles.DoubleCollection;
import it.unimi.dsi.fastutil.doubles.DoubleIterator;
import it.unimi.dsi.fastutil.longs.AbstractLongIterator;
import it.unimi.dsi.fastutil.longs.AbstractLongSet;
import it.unimi.dsi.fastutil.longs.Long2DoubleMap;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractLong2DoubleMap
implements Long2DoubleMap,
Serializable {
    protected double defRetValue;

    protected AbstractLong2DoubleMap() {
    }

    @Override
    public void defaultReturnValue(double rv) {
        this.defRetValue = rv;
    }

    @Override
    public double defaultReturnValue() {
        return this.defRetValue;
    }

    @Override
    public double put(long key, double value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public double remove(long key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Double get(Object ok) {
        long k = (Long)ok;
        return this.containsKey(k) ? Double.valueOf(this.get(k)) : null;
    }

    @Override
    public Double put(Long ok, Double ov) {
        long k = ok;
        double v = this.put(k, (double)ov);
        return this.containsKey(k) ? Double.valueOf(v) : null;
    }

    @Override
    public Double remove(Object ok) {
        long k = (Long)ok;
        double v = this.remove(k);
        return this.containsKey(k) ? Double.valueOf(v) : null;
    }

    @Override
    public boolean containsValue(Object ov) {
        return this.containsValue((Double)ov);
    }

    @Override
    public boolean containsKey(Object ok) {
        return this.containsKey((Long)ok);
    }

    @Override
    public boolean containsValue(double v) {
        return this.values().contains(v);
    }

    @Override
    public boolean containsKey(long k) {
        return this.keySet().contains(k);
    }

    @Override
    public void putAll(Map<? extends Long, ? extends Double> m) {
        int n = m.size();
        Iterator<Map.Entry<? extends Long, ? extends Double>> i = m.entrySet().iterator();
        if (m instanceof Long2DoubleMap) {
            while (n-- != 0) {
                Long2DoubleMap.Entry e = (Long2DoubleMap.Entry)i.next();
                this.put(e.getLongKey(), e.getDoubleValue());
            }
        } else {
            while (n-- != 0) {
                Map.Entry<? extends Long, ? extends Double> e = i.next();
                this.put(e.getKey(), e.getValue());
            }
        }
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public LongSet keySet() {
        return new AbstractLongSet(){

            public boolean contains(long k) {
                return AbstractLong2DoubleMap.this.containsKey(k);
            }

            public int size() {
                return AbstractLong2DoubleMap.this.size();
            }

            public void clear() {
                AbstractLong2DoubleMap.this.clear();
            }

            public LongIterator iterator() {
                return new AbstractLongIterator(){
                    final ObjectIterator<Map.Entry<Long, Double>> i;
                    {
                        this.i = AbstractLong2DoubleMap.this.entrySet().iterator();
                    }

                    public long nextLong() {
                        return ((Long2DoubleMap.Entry)this.i.next()).getLongKey();
                    }

                    public boolean hasNext() {
                        return this.i.hasNext();
                    }
                };
            }
        };
    }

    @Override
    public DoubleCollection values() {
        return new AbstractDoubleCollection(){

            public boolean contains(double k) {
                return AbstractLong2DoubleMap.this.containsValue(k);
            }

            public int size() {
                return AbstractLong2DoubleMap.this.size();
            }

            public void clear() {
                AbstractLong2DoubleMap.this.clear();
            }

            public DoubleIterator iterator() {
                return new AbstractDoubleIterator(){
                    final ObjectIterator<Map.Entry<Long, Double>> i;
                    {
                        this.i = AbstractLong2DoubleMap.this.entrySet().iterator();
                    }

                    public double nextDouble() {
                        return ((Long2DoubleMap.Entry)this.i.next()).getDoubleValue();
                    }

                    public boolean hasNext() {
                        return this.i.hasNext();
                    }
                };
            }
        };
    }

    @Override
    public int hashCode() {
        int h = 0;
        int n = this.size();
        ObjectIterator<Map.Entry<Long, Double>> i = this.entrySet().iterator();
        while (n-- != 0) {
            h += ((Object)((Map.Entry)i.next())).hashCode();
        }
        return h;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map m = (Map)o;
        if (m.size() != this.size()) {
            return false;
        }
        return this.entrySet().containsAll(m.entrySet());
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        ObjectIterator<Map.Entry<Long, Double>> i = this.entrySet().iterator();
        int n = this.size();
        boolean first = true;
        s.append("{");
        while (n-- != 0) {
            if (first) {
                first = false;
            } else {
                s.append(", ");
            }
            Long2DoubleMap.Entry e = (Long2DoubleMap.Entry)i.next();
            s.append(String.valueOf(e.getLongKey()));
            s.append("=>");
            s.append(String.valueOf(e.getDoubleValue()));
        }
        s.append("}");
        return s.toString();
    }

    public static class BasicEntry
    implements Long2DoubleMap.Entry {
        protected long key;
        protected double value;

        public BasicEntry(Long key, Double value) {
            this.key = key;
            this.value = value;
        }

        public BasicEntry(long key, double value) {
            this.key = key;
            this.value = value;
        }

        public Long getKey() {
            return this.key;
        }

        public long getLongKey() {
            return this.key;
        }

        public Double getValue() {
            return this.value;
        }

        public double getDoubleValue() {
            return this.value;
        }

        public double setValue(double value) {
            throw new UnsupportedOperationException();
        }

        public Double setValue(Double value) {
            return this.setValue((double)value);
        }

        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return this.key == (Long)e.getKey() && this.value == (Double)e.getValue();
        }

        public int hashCode() {
            return HashCommon.long2int(this.key) ^ HashCommon.double2int(this.value);
        }

        public String toString() {
            return this.key + "->" + this.value;
        }
    }
}

