package org.gcube.portal.databook.shared;

/**
 * Enum class that specify the possible actions to take when the GCubeSocialNetworking.SHOW_STATISTICS_ACTION_OID parameter
 * is found in the page url
 * @author Costantino Perciante at ISTI-CNR (costantino.perciante@isti.cnr.it)
 */
public enum ShowUserStatisticAction {

	POSTS_MADE_BY_USER("Recent Posts"),
	LIKES_MADE_BY_USER("Recent Likes Made"),
	COMMENTS_MADE_BY_USER("Recent Comments Made"),
	LIKES_GOT_BY_USER("Recent Likes Got"),
	COMMENTS_GOT_BY_USER("Recent Comments Got");
	
	private final String actionHumanFriendly;
	
	private ShowUserStatisticAction(String s) {
		actionHumanFriendly = s;
    }

	public String getHumanFriendlyAction() {
		return this.actionHumanFriendly;
	}
}
