/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.core.Environment;
import freemarker.core.StopException;
import freemarker.core.TemplateElement;
import freemarker.debug.impl.DebuggerService;
import freemarker.template.TemplateException;
import java.io.IOException;

public class DebugBreak
extends TemplateElement {
    private int lineNumber;

    public DebugBreak(TemplateElement nestedBlock, int lineNumber) {
        this.nestedBlock = nestedBlock;
        nestedBlock.parent = this;
        this.lineNumber = lineNumber;
        this.copyLocationFrom(nestedBlock);
    }

    @Override
    protected void accept(Environment env) throws TemplateException, IOException {
        if (DebuggerService.suspendEnvironment(env, this.getTemplate().getName(), this.lineNumber)) {
            throw new StopException(env, "Stopped by debugger");
        }
        this.nestedBlock.accept(env);
    }

    @Override
    public String getDescription() {
        return this.nestedBlock.getDescription();
    }

    @Override
    public String getCanonicalForm() {
        return this.nestedBlock.getCanonicalForm();
    }
}

