/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.rmi.value;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import javax.jcr.Binary;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.ValueFormatException;
import org.apache.jackrabbit.rmi.value.BinaryValue;
import org.apache.jackrabbit.rmi.value.BooleanValue;
import org.apache.jackrabbit.rmi.value.DateValue;
import org.apache.jackrabbit.rmi.value.DecimalValue;
import org.apache.jackrabbit.rmi.value.DoubleValue;
import org.apache.jackrabbit.rmi.value.LongValue;
import org.apache.jackrabbit.rmi.value.NameValue;
import org.apache.jackrabbit.rmi.value.PathValue;
import org.apache.jackrabbit.rmi.value.ReferenceValue;
import org.apache.jackrabbit.rmi.value.SerializableBinary;
import org.apache.jackrabbit.rmi.value.StringValue;

public class SerialValueFactory
implements ValueFactory {
    private static final SerialValueFactory INSTANCE = new SerialValueFactory();

    public static final SerialValueFactory getInstance() {
        return INSTANCE;
    }

    public static Value[] makeSerialValueArray(Value[] values) throws RepositoryException {
        ArrayList<Value> serials = new ArrayList<Value>();
        if (values != null) {
            Value[] valueArray = values;
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                Value value = valueArray[n2];
                if (value != null) {
                    serials.add(SerialValueFactory.makeSerialValue(value));
                }
                ++n2;
            }
        }
        return serials.toArray(new Value[serials.size()]);
    }

    public static Value makeSerialValue(Value value) throws RepositoryException {
        if (value == null || value instanceof Serializable) {
            return value;
        }
        return INSTANCE.createValue(value);
    }

    public static Value[] makeSerialValueArray(String[] values) {
        ArrayList<Value> serials = new ArrayList<Value>();
        if (values != null) {
            String[] stringArray = values;
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                String value = stringArray[n2];
                if (value != null) {
                    serials.add(INSTANCE.createValue(value));
                }
                ++n2;
            }
        }
        return serials.toArray(new Value[serials.size()]);
    }

    protected SerialValueFactory() {
    }

    public Value createValue(String value) {
        return new StringValue(value);
    }

    public final Value createValue(String value, int type) throws ValueFormatException {
        try {
            return this.createValue(new StringValue(value), type);
        }
        catch (ValueFormatException e) {
            throw e;
        }
        catch (RepositoryException e) {
            throw new ValueFormatException("Unexpected error when creating value: " + value, (Throwable)e);
        }
    }

    private Value createValue(Value value) throws RepositoryException {
        return this.createValue(value, value.getType());
    }

    private Value createValue(Value value, int type) throws RepositoryException {
        switch (type) {
            case 2: {
                Binary binary = value.getBinary();
                try {
                    Value value2 = this.createValue(binary.getStream());
                    return value2;
                }
                finally {
                    binary.dispose();
                }
            }
            case 6: {
                return this.createValue(value.getBoolean());
            }
            case 5: {
                return this.createValue(value.getDate());
            }
            case 12: {
                return this.createValue(value.getDecimal());
            }
            case 4: {
                return this.createValue(value.getDouble());
            }
            case 3: {
                return this.createValue(value.getLong());
            }
            case 7: {
                return new NameValue(value.getString());
            }
            case 8: {
                return new PathValue(value.getString());
            }
            case 9: {
                return new ReferenceValue(value.getString());
            }
            case 1: {
                return this.createValue(value.getString());
            }
        }
        throw new ValueFormatException("Unknown value type " + type);
    }

    public final Value createValue(long value) {
        return new LongValue(value);
    }

    public final Value createValue(double value) {
        return new DoubleValue(value);
    }

    public final Value createValue(boolean value) {
        return new BooleanValue(value);
    }

    public Value createValue(BigDecimal value) {
        return new DecimalValue(value);
    }

    public final Value createValue(Calendar value) {
        return new DateValue(value);
    }

    public final Value createValue(InputStream value) {
        try {
            return this.createValue(this.createBinary(value));
        }
        catch (RepositoryException e) {
            throw new RuntimeException("Unable to create a binary value", e);
        }
    }

    public final Value createValue(Node value) throws RepositoryException {
        return this.createValue(value.getUUID(), 9);
    }

    public Binary createBinary(InputStream stream) throws RepositoryException {
        SerializableBinary serializableBinary;
        try {
            serializableBinary = new SerializableBinary(stream);
        }
        catch (Throwable throwable) {
            try {
                stream.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new RepositoryException("Unable to read binary stream", (Throwable)e);
            }
        }
        stream.close();
        return serializableBinary;
    }

    public Value createValue(Binary value) {
        return new BinaryValue(value);
    }

    public Value createValue(Node value, boolean weak) throws RepositoryException {
        return new ReferenceValue(value.getUUID());
    }
}

