/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.io.DataInput;
import java.io.DataOutput;
import java.util.ArrayList;
import java.util.List;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Header;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.annotations.Experimental;
import org.jgroups.annotations.Property;
import org.jgroups.annotations.Unsupported;
import org.jgroups.stack.Protocol;
import org.jgroups.util.Util;

@Experimental
@Unsupported
public class HTOTAL
extends Protocol {
    Address coord = null;
    Address neighbor = null;
    Address local_addr = null;
    List<Address> mbrs = new ArrayList<Address>();
    boolean is_coord = false;
    @Property
    private boolean use_multipoint_forwarding = false;

    @Override
    public Object down(Event evt) {
        switch (evt.getType()) {
            case 6: {
                this.determineCoordinatorAndNextMember((View)evt.getArg());
                break;
            }
            case 8: {
                this.local_addr = (Address)evt.getArg();
                break;
            }
            case 1: {
                Message msg = (Message)evt.getArg();
                Address dest = msg.getDest();
                if (dest != null) break;
                if (this.coord == null) {
                    this.log.error("coordinator is null, cannot send message to coordinator");
                } else {
                    if (msg.getSrc() == null) {
                        msg.setSrc(this.local_addr);
                    }
                    this.forwardTo(this.coord, msg);
                }
                return null;
            }
        }
        return this.down_prot.down(evt);
    }

    @Override
    public Object up(Event evt) {
        switch (evt.getType()) {
            case 6: {
                this.determineCoordinatorAndNextMember((View)evt.getArg());
                break;
            }
            case 1: {
                Message msg = (Message)evt.getArg();
                HTotalHeader hdr = (HTotalHeader)msg.getHeader(this.id);
                if (hdr == null) break;
                Message copy = msg.copy(false);
                if (this.use_multipoint_forwarding) {
                    copy.setDest(null);
                    this.down_prot.down(new Event(1, copy));
                } else if (this.neighbor != null) {
                    this.forwardTo(this.neighbor, copy);
                }
                msg.setDest(hdr.dest);
                msg.setSrc(hdr.src);
                return this.up_prot.up(evt);
            }
        }
        return this.up_prot.up(evt);
    }

    private void forwardTo(Address destination, Message msg) {
        HTotalHeader hdr = (HTotalHeader)msg.getHeader(this.id);
        if (hdr == null) {
            hdr = new HTotalHeader(msg.getDest(), msg.getSrc());
            msg.putHeader(this.id, hdr);
        }
        msg.setDest(destination);
        if (this.log.isTraceEnabled()) {
            this.log.trace("forwarding message to " + destination + ", hdr=" + hdr);
        }
        this.down_prot.down(new Event(1, msg));
    }

    private void determineCoordinatorAndNextMember(View v) {
        Address retval = null;
        this.mbrs.clear();
        this.mbrs.addAll(v.getMembers());
        this.coord = this.mbrs != null && !this.mbrs.isEmpty() ? this.mbrs.get(0) : null;
        boolean bl = this.is_coord = this.coord != null && this.local_addr != null && this.coord.equals(this.local_addr);
        if (this.mbrs == null || this.mbrs.size() < 2 || this.local_addr == null) {
            this.neighbor = null;
        } else {
            for (int i = 0; i < this.mbrs.size(); ++i) {
                Address tmp = this.mbrs.get(i);
                if (!this.local_addr.equals(tmp)) continue;
                if (i + 1 >= this.mbrs.size()) {
                    retval = null;
                    break;
                }
                retval = this.mbrs.get(i + 1);
                break;
            }
        }
        this.neighbor = retval;
        if (this.log.isTraceEnabled()) {
            this.log.trace("coord=" + this.coord + ", neighbor=" + this.neighbor);
        }
    }

    public static class HTotalHeader
    extends Header {
        Address dest;
        Address src;

        public HTotalHeader() {
        }

        public HTotalHeader(Address dest, Address src) {
            this.dest = dest;
            this.src = src;
        }

        @Override
        public void writeTo(DataOutput out) throws Exception {
            Util.writeAddress(this.dest, out);
            Util.writeAddress(this.src, out);
        }

        @Override
        public void readFrom(DataInput in) throws Exception {
            this.dest = Util.readAddress(in);
            this.src = Util.readAddress(in);
        }

        @Override
        public int size() {
            return Util.size(this.dest) + Util.size(this.src);
        }

        @Override
        public String toString() {
            return "dest=" + this.dest + ", src=" + this.src;
        }
    }
}

