/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.filter;

import org.apache.cassandra.db.DecoratedKey;

public class TombstoneOverwhelmingException
extends RuntimeException {
    private final int numTombstones;
    private final int numRequested;
    private final String ksName;
    private final String cfName;
    private final String lastCellName;
    private final String slicesInfo;
    private String partitionKey = null;

    public TombstoneOverwhelmingException(int numTombstones, int numRequested, String ksName, String cfName, String lastCellName, String slicesInfo) {
        this.numTombstones = numTombstones;
        this.numRequested = numRequested;
        this.ksName = ksName;
        this.cfName = cfName;
        this.lastCellName = lastCellName;
        this.slicesInfo = slicesInfo;
    }

    public void setKey(DecoratedKey key) {
        if (key != null) {
            this.partitionKey = key.toString();
        }
    }

    @Override
    public String getLocalizedMessage() {
        return this.getMessage();
    }

    @Override
    public String getMessage() {
        return String.format("Scanned over %d tombstones in %s.%s; %d columns were requested; query aborted (see tombstone_failure_threshold); partitionKey=%s; lastCell=%s; slices=%s", this.numTombstones, this.ksName, this.cfName, this.numRequested, this.partitionKey, this.lastCellName, this.slicesInfo);
    }
}

