/*
 * Decompiled with CFR 0.152.
 */
package org.walluck.oscar.handlers;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.walluck.oscar.AIMConnection;
import org.walluck.oscar.AIMFrame;
import org.walluck.oscar.AIMInputStream;
import org.walluck.oscar.AIMOutputStream;
import org.walluck.oscar.AIMSession;
import org.walluck.oscar.ClientInfo;
import org.walluck.oscar.FLAP;
import org.walluck.oscar.LoginResponseInfo;
import org.walluck.oscar.SNAC;
import org.walluck.oscar.TLV;
import org.walluck.oscar.TLVChain;
import org.walluck.oscar.handlers.LoginListener;
import org.walluck.oscar.handlers.SNACHandler;
import org.walluck.oscar.handlers.icq.ICQClientInfo;

public class LoginHandler
extends SNACHandler {
    private static final Logger LOG = Logger.getLogger((String)(class$org$walluck$oscar$handlers$LoginHandler == null ? (class$org$walluck$oscar$handlers$LoginHandler = LoginHandler.class$("org.walluck.oscar.handlers.LoginHandler")) : class$org$walluck$oscar$handlers$LoginHandler).getName());
    public static final int REG_X1 = 671089408;
    public static final int REG_X2 = -1641611264;
    public static final int REG_X3 = 770;
    static /* synthetic */ Class class$org$walluck$oscar$handlers$LoginHandler;

    public LoginHandler() {
        this.setFamily(23);
        this.setVersion(1);
    }

    public void sendCookie(AIMSession sess, AIMConnection conn, byte[] cookie) throws IOException {
        FLAP flap = new FLAP(1);
        TLVChain tlvchain = new TLVChain(1);
        tlvchain.addBytes(6, cookie);
        AIMOutputStream buffer = new AIMOutputStream(4 + tlvchain.length());
        buffer.writeInt(1);
        buffer.writeTLVChain(tlvchain);
        conn.enqueueFrame(new AIMFrame(conn, 0, flap, null, buffer));
    }

    public void sendFLAPVer(AIMSession sess, AIMConnection conn) throws IOException {
        FLAP flap = new FLAP(1);
        AIMOutputStream buffer = new AIMOutputStream(4);
        buffer.writeInt(1);
        conn.enqueueFrame(new AIMFrame(conn, 0, flap, null, buffer));
    }

    private void godDamnICQ(AIMSession sess, AIMConnection conn, String sn) {
        AIMFrame frame = new AIMFrame();
        frame.setConn(conn);
        sess.setFlags(sess.getFlags() & 0xFFFFFFFE);
        sess.setFlags(sess.getFlags() | 2);
        Iterator i = conn.getListeners(23, 3);
        while (i.hasNext()) {
            ((LoginListener)i.next()).godDamnICQ(sess, frame, "");
        }
    }

    public void requestLogin(AIMSession sess, AIMConnection conn, String sn) throws IOException {
        if (sess == null || conn == null || sn == null) {
            throw new NullPointerException();
        }
        if (Character.isDigit(sn.charAt(0))) {
            this.godDamnICQ(sess, conn, sn);
            return;
        }
        sess.setFlags(sess.getFlags() | 1);
        this.sendFLAPVer(sess, conn);
        FLAP flap = new FLAP(2);
        SNAC snac = new SNAC(23, 6, 0, null, true);
        TLVChain tlvchain = new TLVChain(3);
        tlvchain.addString(1, sn);
        tlvchain.addNull(75);
        tlvchain.addNull(90);
        AIMOutputStream buffer = new AIMOutputStream(tlvchain.length());
        buffer.writeTLVChain(tlvchain);
        conn.enqueueFrame(new AIMFrame(conn, 0, flap, snac, buffer));
    }

    private void godDamnICQ2(AIMSession sess, AIMConnection conn, String sn, String password) throws IOException {
        ICQClientInfo ci = new ICQClientInfo();
        byte[] encoded = this.encodePassword(password);
        FLAP flap = new FLAP(1);
        TLVChain tlvchain = new TLVChain(11);
        tlvchain.addString(1, sn);
        tlvchain.addBytes(2, encoded);
        tlvchain.addString(3, ci.getClientString());
        tlvchain.addShort(22, ci.getClientId());
        tlvchain.addShort(23, ci.getMajor());
        tlvchain.addShort(24, ci.getMinor());
        tlvchain.addShort(25, ci.getPoint());
        tlvchain.addShort(26, ci.getBuild());
        tlvchain.addInt(20, ci.getDistributionCode());
        tlvchain.addString(15, ci.getLang());
        tlvchain.addString(14, ci.getCountry());
        AIMOutputStream buffer = new AIMOutputStream(4 + tlvchain.length());
        buffer.writeInt(1);
        buffer.writeTLVChain(tlvchain);
        conn.enqueueFrame(new AIMFrame(conn, 0, flap, null, buffer));
    }

    public void sendLogin(AIMSession sess, AIMConnection conn, String sn, String password, ClientInfo ci, String key, String clientString) throws IOException {
        if (sn == null || password == null) {
            throw new NullPointerException();
        }
        if ((sess.getFlags() & 2) != 0) {
            this.godDamnICQ2(sess, conn, sn, password);
            return;
        }
        FLAP flap = new FLAP(2);
        SNAC snac = new SNAC(23, 2, 0, null, true);
        TLVChain tlvchain = new TLVChain(10);
        tlvchain.addString(1, sn);
        tlvchain.addBytes(37, this.encodePasswordMD5(password, key, clientString));
        tlvchain.addString(3, ci.getClientString());
        tlvchain.addShort(22, ci.getClientId());
        tlvchain.addShort(23, ci.getMajor());
        tlvchain.addShort(24, ci.getMinor());
        tlvchain.addShort(25, ci.getPoint());
        tlvchain.addShort(26, ci.getBuild());
        if (ci.getDistributionCode() != 0) {
            tlvchain.addInt(20, ci.getDistributionCode());
        }
        tlvchain.addString(14, ci.getCountry());
        tlvchain.addString(15, ci.getLang());
        tlvchain.addByte(74, 1);
        tlvchain.addNull(76);
        AIMOutputStream buffer = new AIMOutputStream(tlvchain.length());
        buffer.writeTLVChain(tlvchain);
        conn.enqueueFrame(new AIMFrame(conn, 0, flap, snac, buffer));
    }

    private byte[] encodePasswordMD5(String password, String key, String clientString) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] passwordBytes = md.digest(password.getBytes("US-ASCII"));
            md.reset();
            md.update(key.getBytes("US-ASCII"));
            md.update(passwordBytes);
            md.update(clientString.getBytes("US-ASCII"));
            return md.digest();
        }
        catch (NoSuchAlgorithmException nsae) {
            LOG.error((Object)"NoSuchAlgorithmException", (Throwable)nsae);
            LOG.warn((Object)"encodePasswordMD5 failed, falling back to encodePassword");
            return this.encodePassword(password);
        }
        catch (UnsupportedEncodingException uee) {
            LOG.error((Object)"UnsupportedEncodingException", (Throwable)uee);
            LOG.warn((Object)"encodePasswordMD5 failed, falling back to encodePassword");
            return this.encodePassword(password);
        }
    }

    private byte[] encodePassword(String password) {
        int length = password.length();
        byte[] encodingTable = new byte[]{-13, 38, -127, -60, 57, -122, -37, -110, 113, -93, -71, -26, 83, 122, -107, 124};
        byte[] encoded = password.getBytes();
        for (int i = 0; i < length; ++i) {
            int n = i;
            encoded[n] = (byte)(encoded[n] ^ encodingTable[i]);
        }
        return encoded;
    }

    public void registerUIN(AIMSession sess, AIMConnection conn, String password) throws IOException {
        FLAP flap = new FLAP(2);
        SNAC snac = new SNAC(23, 4, 0, null, true);
        AIMOutputStream buffer2 = new AIMOutputStream(50 + password.length() + 1);
        buffer2.writeIntLE(0);
        buffer2.writeIntLE(671089408);
        buffer2.writeIntLE(0);
        buffer2.writeIntLE(0);
        buffer2.writeIntLE(-1641611264);
        buffer2.writeIntLE(-1641611264);
        buffer2.writeIntLE(0);
        buffer2.writeIntLE(0);
        buffer2.writeIntLE(0);
        buffer2.writeIntLE(0);
        buffer2.writeStringLLLE0(password);
        buffer2.writeIntLE(-1641611264);
        buffer2.writeIntLE(770);
        TLVChain tlvchain = new TLVChain(1);
        tlvchain.addBytes(1, buffer2.getBytes());
        AIMOutputStream buffer = new AIMOutputStream(tlvchain.length());
        buffer.writeTLVChain(tlvchain);
        conn.enqueueFrame(new AIMFrame(conn, 0, flap, snac, buffer));
    }

    public void sendSecurID(AIMSession sess, AIMConnection conn, String securID) throws IOException {
        FLAP flap = new FLAP(2);
        SNAC snac = new SNAC(23, 11, 0, null, false);
        AIMOutputStream buffer = new AIMOutputStream(1 + securID.length());
        buffer.writeStringL(securID);
        conn.enqueueFrame(new AIMFrame(conn, 0, flap, snac, buffer));
    }

    private void parse(AIMSession sess, SNACHandler handler, AIMFrame frame, SNAC snac, AIMInputStream buffer) throws IOException {
        LoginResponseInfo info = new LoginResponseInfo();
        TLVChain tlvchain = buffer.readTLVChain();
        TLV tlv = tlvchain.getTLV(1, 1);
        if (tlv != null) {
            info.setSN(tlv.getValueString());
        }
        if ((tlv = tlvchain.getTLV(8, 1)) != null) {
            info.setErrorCode(tlv.getValueShort());
        }
        if ((tlv = tlvchain.getTLV(4, 1)) != null) {
            info.setErrorURL(tlv.getValueString());
        }
        if ((tlv = tlvchain.getTLV(5, 1)) != null) {
            info.setBosip(tlv.getValueString());
        }
        if ((tlv = tlvchain.getTLV(6, 1)) != null) {
            info.setCookie(tlv.getValue());
        }
        if ((tlv = tlvchain.getTLV(17, 1)) != null) {
            info.setEmail(tlv.getValueString());
        }
        if ((tlv = tlvchain.getTLV(19, 1)) != null) {
            info.setRegStatus(tlv.getValueShort());
        }
        if ((tlv = tlvchain.getTLV(64, 1)) != null) {
            info.getLatestBeta().setBuild(tlv.getValueInt());
        }
        if ((tlv = tlvchain.getTLV(65, 1)) != null) {
            info.getLatestBeta().setURL(tlv.getValueString());
        }
        if ((tlv = tlvchain.getTLV(66, 1)) != null) {
            info.getLatestBeta().setInfo(tlv.getValueString());
        }
        if ((tlv = tlvchain.getTLV(67, 1)) != null) {
            info.getLatestBeta().setName(tlv.getValueString());
        }
        if ((tlv = tlvchain.getTLV(72, 1)) != null) {
            info.getLatestBeta().setChecksum(tlv.getValueString());
        }
        if ((tlv = tlvchain.getTLV(68, 1)) != null) {
            info.getLatestRelease().setBuild(tlv.getValueInt());
        }
        if ((tlv = tlvchain.getTLV(69, 1)) != null) {
            info.getLatestRelease().setURL(tlv.getValueString());
        }
        if ((tlv = tlvchain.getTLV(70, 1)) != null) {
            info.getLatestRelease().setInfo(tlv.getValueString());
        }
        if ((tlv = tlvchain.getTLV(71, 1)) != null) {
            info.getLatestRelease().setName(tlv.getValueString());
        }
        if ((tlv = tlvchain.getTLV(73, 1)) != null) {
            info.getLatestRelease().setChecksum(tlv.getValueString());
        }
        if ((tlv = tlvchain.getTLV(84, 1)) != null) {
            info.setChangePasswordURL(tlv.getValueString());
        }
        if ((tlv = tlvchain.getTLV(85, 1)) != null) {
            info.setMac(tlv.getValueShort());
        }
        sess.setLoginInfo(info);
        int family = snac.getFamily();
        int subtype = snac.getSubtype();
        Iterator i = frame.getConn().getListeners(23, 3);
        while (i.hasNext()) {
            ((LoginListener)i.next()).parse(sess, frame, info, family, subtype);
        }
    }

    private void newUIN(AIMSession sess, SNACHandler handler, AIMFrame frame, SNAC snac, AIMInputStream buffer) throws IOException {
        TLVChain tlvchain = buffer.readTLVChain();
        TLV tlv = tlvchain.getTLV(1, 1);
        if (tlv != null) {
            int zero1 = buffer.readInt();
            int unknown = buffer.readInt();
            int port = buffer.readInt();
            int ip = buffer.readInt();
            int direct = buffer.readInt();
            int cookie = buffer.readInt();
            int zero2 = buffer.readInt();
            int zero3 = buffer.readInt();
            int zero4 = buffer.readInt();
            int zero5 = buffer.readInt();
            int uin = buffer.readIntLE();
            int cookie2 = buffer.readInt();
            Iterator i = frame.getConn().getListeners(23, 5);
            while (i.hasNext()) {
                ((LoginListener)i.next()).newUIN(sess, frame, uin, ip, port);
            }
        }
    }

    private void keyParse(AIMSession sess, SNACHandler handler, AIMFrame frame, SNAC snac, AIMInputStream buffer) throws IOException {
        String keystr = buffer.readStringLL();
        Iterator i = frame.getConn().getListeners(23, 7);
        while (i.hasNext()) {
            ((LoginListener)i.next()).keyParse(sess, frame, keystr);
        }
    }

    private void securID(AIMSession sess, SNACHandler handler, AIMFrame frame, SNAC snac, AIMInputStream buffer) throws IOException {
        Iterator i = frame.getConn().getListeners(23, 10);
        while (i.hasNext()) {
            ((LoginListener)i.next()).securID(sess, frame);
        }
    }

    public void handleSNAC(AIMSession sess, SNACHandler handler, AIMFrame frame, SNAC snac, AIMInputStream buffer) throws IOException {
        if (snac.getSubtype() == 3) {
            this.parse(sess, handler, frame, snac, buffer);
        } else if (snac.getSubtype() == 5) {
            this.newUIN(sess, handler, frame, snac, buffer);
        } else if (snac.getSubtype() == 7) {
            this.keyParse(sess, handler, frame, snac, buffer);
        } else if (snac.getSubtype() == 10) {
            this.securID(sess, handler, frame, snac, buffer);
        } else {
            LOG.warn((Object)("Unrecognized SNAC(" + Integer.toHexString(snac.getFamily()) + ", " + Integer.toHexString(snac.getSubtype()) + ")"));
            frame.setHandled(false);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

