/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.thrift;

import com.google.common.collect.Iterables;
import com.netflix.astyanax.model.ColumnFamily;
import com.netflix.astyanax.model.Row;
import com.netflix.astyanax.model.Rows;
import com.netflix.astyanax.partitioner.Partitioner;
import com.netflix.astyanax.thrift.ThriftAllRowsQueryImpl;
import com.netflix.astyanax.thrift.model.ThriftColumnOrSuperColumnListImpl;
import com.netflix.astyanax.thrift.model.ThriftRowImpl;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.cassandra.thrift.KeyRange;
import org.apache.cassandra.thrift.KeySlice;
import org.apache.commons.lang.NotImplementedException;

public class ThriftAllRowsImpl<K, C>
implements Rows<K, C> {
    private ColumnFamily<K, C> columnFamily;
    private ThriftAllRowsQueryImpl<K, C> query;
    private final Partitioner partitioner;

    public ThriftAllRowsImpl(Partitioner partitioner, ThriftAllRowsQueryImpl<K, C> query, ColumnFamily<K, C> columnFamily) {
        this.columnFamily = columnFamily;
        this.query = query;
        this.partitioner = partitioner;
    }

    public Iterator<Row<K, C>> iterator() {
        return new Iterator<Row<K, C>>(){
            private KeyRange range;
            private KeySlice lastRow;
            private List<KeySlice> list = null;
            private Iterator<KeySlice> iter = null;
            private boolean bContinueSearch = true;
            private boolean bIgnoreTombstones = true;
            {
                String startToken = ThriftAllRowsImpl.this.query.getStartToken() == null ? ThriftAllRowsImpl.this.partitioner.getMinToken() : ThriftAllRowsImpl.this.query.getStartToken();
                String endToken = ThriftAllRowsImpl.this.query.getEndToken() == null ? ThriftAllRowsImpl.this.partitioner.getMaxToken() : ThriftAllRowsImpl.this.query.getEndToken();
                this.range = new KeyRange().setCount(ThriftAllRowsImpl.this.query.getBlockSize()).setStart_token(startToken).setEnd_token(endToken);
                if (ThriftAllRowsImpl.this.query.getIncludeEmptyRows() == null) {
                    if (ThriftAllRowsImpl.this.query.getPredicate().isSetSlice_range() && ThriftAllRowsImpl.this.query.getPredicate().getSlice_range().getCount() == 0) {
                        this.bIgnoreTombstones = false;
                    }
                } else {
                    this.bIgnoreTombstones = ThriftAllRowsImpl.this.query.getIncludeEmptyRows() == false;
                }
            }

            @Override
            public boolean hasNext() {
                while (this.iter == null || !this.iter.hasNext() && this.bContinueSearch) {
                    if (this.lastRow != null) {
                        String token = ThriftAllRowsImpl.this.partitioner.getTokenForKey(ByteBuffer.wrap(this.lastRow.getKey()));
                        if (ThriftAllRowsImpl.this.query.getRepeatLastToken()) {
                            this.range.setStart_token(ThriftAllRowsImpl.this.partitioner.getTokenMinusOne(token));
                        } else {
                            this.range.setStart_token(token);
                        }
                    }
                    this.list = ThriftAllRowsImpl.this.query.getNextBlock(this.range);
                    if (this.list == null || this.list.isEmpty()) {
                        return false;
                    }
                    this.bContinueSearch = this.list.size() == ThriftAllRowsImpl.this.query.getBlockSize();
                    this.iter = this.list.iterator();
                    if (this.iter == null || !this.iter.hasNext()) {
                        return false;
                    }
                    KeySlice previousLastRow = this.lastRow;
                    this.lastRow = (KeySlice)Iterables.getLast(this.list);
                    if (ThriftAllRowsImpl.this.query.getRepeatLastToken() && previousLastRow != null) {
                        this.iter.next();
                        this.iter.remove();
                    }
                    if (!this.iter.hasNext() || !this.bIgnoreTombstones) continue;
                    while (this.iter.hasNext()) {
                        KeySlice row = this.iter.next();
                        if (!row.getColumns().isEmpty()) continue;
                        this.iter.remove();
                    }
                    this.iter = this.list.iterator();
                }
                return this.iter.hasNext();
            }

            @Override
            public Row<K, C> next() {
                KeySlice row = this.iter.next();
                return new ThriftRowImpl(ThriftAllRowsImpl.this.columnFamily.getKeySerializer().fromBytes(row.getKey()), ByteBuffer.wrap(row.getKey()), new ThriftColumnOrSuperColumnListImpl(row.getColumns(), ThriftAllRowsImpl.this.columnFamily.getColumnSerializer()));
            }

            @Override
            public void remove() {
                throw new IllegalStateException();
            }
        };
    }

    public Row<K, C> getRow(K key) {
        throw new NotImplementedException("Only iterator based access is implemented");
    }

    public int size() {
        throw new NotImplementedException("Only iterator based access is implemented");
    }

    public boolean isEmpty() {
        throw new NotImplementedException("Only iterator based access is implemented");
    }

    public Row<K, C> getRowByIndex(int i) {
        throw new NotImplementedException("Only iterator based access is implemented");
    }

    public Collection<K> getKeys() {
        throw new NotImplementedException("Only iterator based access is implemented");
    }
}

