/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.model;

import java.io.Serializable;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import net.fortuna.ical4j.model.Date;
import net.fortuna.ical4j.model.DateTime;
import net.fortuna.ical4j.model.TimeZone;
import net.fortuna.ical4j.model.parameter.Value;

public class DateList
extends ArrayList
implements Serializable {
    private static final long serialVersionUID = 5925108767897130313L;
    private final Value type;
    private TimeZone timeZone;
    private boolean utc;

    public DateList() {
        this.type = Value.DATE_TIME;
    }

    public DateList(int initialCapacity) {
        super(initialCapacity);
        this.type = Value.DATE_TIME;
    }

    public DateList(Value aType) {
        this(aType, null);
    }

    public DateList(Value aType, TimeZone timezone) {
        this.type = aType != null ? aType : Value.DATE_TIME;
        this.timeZone = timezone;
    }

    public DateList(String aValue, Value aType) throws ParseException {
        this(aValue, aType, null);
    }

    public DateList(String aValue, Value aType, TimeZone timezone) throws ParseException {
        this(aType, timezone);
        StringTokenizer t = new StringTokenizer(aValue, ",");
        while (t.hasMoreTokens()) {
            if (Value.DATE.equals(this.type)) {
                this.add((Object)new Date(t.nextToken()));
                continue;
            }
            this.add((Object)new DateTime(t.nextToken(), timezone));
        }
    }

    public DateList(DateList list, Value type) {
        if (!Value.DATE.equals(type) && !Value.DATE_TIME.equals(type)) {
            throw new IllegalArgumentException("Type must be either DATE or DATE-TIME");
        }
        this.type = type;
        if (Value.DATE.equals(type)) {
            Iterator i = list.iterator();
            while (i.hasNext()) {
                this.add(new Date((Date)i.next()));
            }
        } else {
            Iterator i = list.iterator();
            while (i.hasNext()) {
                this.add(new DateTime((Date)i.next()));
            }
        }
    }

    public final String toString() {
        StringBuffer b = new StringBuffer();
        Iterator i = this.iterator();
        while (i.hasNext()) {
            b.append(i.next());
            if (!i.hasNext()) continue;
            b.append(',');
        }
        return b.toString();
    }

    public final boolean add(Date date) {
        if (date instanceof DateTime) {
            if (this.isUtc()) {
                ((DateTime)date).setUtc(true);
            } else {
                ((DateTime)date).setTimeZone(this.getTimeZone());
            }
        } else if (!Value.DATE.equals(this.getType())) {
            DateTime dateTime = new DateTime(date);
            dateTime.setTimeZone(this.getTimeZone());
            return this.add((Object)dateTime);
        }
        return this.add((Object)date);
    }

    public final boolean add(Object date) {
        if (!(date instanceof Date)) {
            throw new IllegalArgumentException("Argument not a " + Date.class.getName());
        }
        return super.add(date);
    }

    public final boolean remove(Date date) {
        return this.remove((Object)date);
    }

    public final Value getType() {
        return this.type;
    }

    public final boolean isUtc() {
        return this.utc;
    }

    public final void setUtc(boolean utc) {
        if (!Value.DATE.equals(this.type)) {
            Iterator i = this.iterator();
            while (i.hasNext()) {
                ((DateTime)i.next()).setUtc(utc);
            }
        }
        this.timeZone = null;
        this.utc = utc;
    }

    public final void setTimeZone(TimeZone timeZone) {
        if (!Value.DATE.equals(this.type)) {
            Iterator i = this.iterator();
            while (i.hasNext()) {
                ((DateTime)i.next()).setTimeZone(timeZone);
            }
        }
        this.timeZone = timeZone;
        this.utc = false;
    }

    public final TimeZone getTimeZone() {
        return this.timeZone;
    }
}

