/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.alloy.util;

import com.liferay.alloy.tools.model.Attribute;
import com.liferay.alloy.tools.model.Component;
import com.liferay.portal.kernel.util.StringUtil;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class ReservedAttributeUtil {
    public static final List<String> RESERVED_ATTRIBUTES = Arrays.asList("values", "value", "servletRequest", "servletResponse", "servletContext", "scopedAttribute", "scopedAttributes", "previousOut", "parent", "namespacedAttribute", "attributeNamespace", "bodyContent", "class", "dynamicAttribute", "dynamicAttributes", "id", "scriptPosition", "page", "locale");

    public static String getOriginalName(String componentName, String attributeName) {
        String originalName = StringUtils.uncapitalize((String)StringUtil.replaceFirst((String)attributeName, (String)componentName.toLowerCase(), (String)""));
        if (ReservedAttributeUtil.isReserved(originalName)) {
            attributeName = originalName;
        }
        return attributeName;
    }

    public static String getSafeName(Attribute attribute) {
        String name = attribute.getName();
        Component component = attribute.getComponent();
        if (ReservedAttributeUtil.isReserved(attribute) && component != null) {
            String componentName = component.getName();
            name = componentName.toLowerCase().concat(StringUtils.capitalize((String)name));
        }
        return name;
    }

    public static boolean isReserved(Attribute attribute) {
        return ReservedAttributeUtil.isReserved(attribute.getName());
    }

    public static boolean isReserved(String attributeName) {
        return RESERVED_ATTRIBUTES.contains(attributeName);
    }
}

