/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.connectionpool.impl;

import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.netflix.astyanax.connectionpool.HostConnectionPool;
import com.netflix.astyanax.connectionpool.LatencyScoreStrategy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.cliffc.high_scale_lib.NonBlockingHashSet;

public abstract class AbstractLatencyScoreStrategyImpl
implements LatencyScoreStrategy {
    public static final int DEFAULT_UPDATE_INTERVAL = 1000;
    public static final int DEFAULT_RESET_INTERVAL = 0;
    public static final int DEFAULT_BLOCKED_THREAD_THRESHOLD = 10;
    public static final double DEFAULT_KEEP_RATIO = 0.65;
    public static final double DEFAULT_SCORE_THRESHOLD = 2.0;
    private final ScheduledExecutorService executor;
    private final Set<LatencyScoreStrategy.Instance> instances;
    private final int updateInterval;
    private final int resetInterval;
    private final double scoreThreshold;
    private final int blockedThreshold;
    private final String name;
    private final double keepRatio;
    private boolean bOwnedExecutor = false;
    private Comparator<HostConnectionPool<?>> scoreComparator = new Comparator<HostConnectionPool<?>>(){

        @Override
        public int compare(HostConnectionPool<?> p1, HostConnectionPool<?> p2) {
            double score2;
            double score1 = p1.getScore();
            if (score1 < (score2 = p2.getScore())) {
                return -1;
            }
            if (score1 > score2) {
                return 1;
            }
            return 0;
        }
    };
    private Comparator<HostConnectionPool<?>> busyComparator = new Comparator<HostConnectionPool<?>>(){

        @Override
        public int compare(HostConnectionPool<?> p1, HostConnectionPool<?> p2) {
            return p1.getBusyConnectionCount() + p1.getBlockedThreadCount() - p2.getBusyConnectionCount() - p2.getBlockedThreadCount();
        }
    };

    public AbstractLatencyScoreStrategyImpl(String name, int updateInterval, int resetInterval, int blockedThreshold, double keepRatio, double scoreThreshold, ScheduledExecutorService executor) {
        this.updateInterval = updateInterval;
        this.resetInterval = resetInterval;
        this.name = name;
        this.scoreThreshold = scoreThreshold;
        this.blockedThreshold = blockedThreshold;
        this.keepRatio = keepRatio;
        this.executor = executor;
        this.instances = new NonBlockingHashSet();
    }

    public AbstractLatencyScoreStrategyImpl(String name, int updateInterval, int resetInterval, int blockedThreshold, double keepRatio, double scoreThreshold) {
        this(name, updateInterval, resetInterval, blockedThreshold, keepRatio, scoreThreshold, Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().setDaemon(true).build()));
        this.bOwnedExecutor = true;
    }

    public AbstractLatencyScoreStrategyImpl(String name, int updateInterval, int resetInterval) {
        this(name, updateInterval, resetInterval, 10, 0.65, 2.0);
    }

    public AbstractLatencyScoreStrategyImpl(String name) {
        this(name, 1000, 0, 10, 0.65, 2.0);
    }

    @Override
    public final LatencyScoreStrategy.Instance createInstance() {
        LatencyScoreStrategy.Instance instance = this.newInstance();
        this.instances.add(instance);
        return instance;
    }

    protected abstract LatencyScoreStrategy.Instance newInstance();

    @Override
    public void start(final LatencyScoreStrategy.Listener listener) {
        if (this.updateInterval > 0) {
            this.executor.schedule(new Runnable(){

                @Override
                public void run() {
                    Thread.currentThread().setName(AbstractLatencyScoreStrategyImpl.this.name + "_ScoreUpdate");
                    AbstractLatencyScoreStrategyImpl.this.update();
                    listener.onUpdate();
                    AbstractLatencyScoreStrategyImpl.this.executor.schedule(this, (long)AbstractLatencyScoreStrategyImpl.this.getUpdateInterval(), TimeUnit.MILLISECONDS);
                }
            }, (long)new Random().nextInt(this.getUpdateInterval()), TimeUnit.MILLISECONDS);
        }
        if (this.resetInterval > 0) {
            this.executor.schedule(new Runnable(){

                @Override
                public void run() {
                    Thread.currentThread().setName(AbstractLatencyScoreStrategyImpl.this.name + "_ScoreReset");
                    AbstractLatencyScoreStrategyImpl.this.reset();
                    listener.onReset();
                    AbstractLatencyScoreStrategyImpl.this.executor.schedule(this, (long)AbstractLatencyScoreStrategyImpl.this.getResetInterval(), TimeUnit.MILLISECONDS);
                }
            }, (long)new Random().nextInt(this.getResetInterval()), TimeUnit.MILLISECONDS);
        }
    }

    @Override
    public void shutdown() {
        if (this.bOwnedExecutor) {
            this.executor.shutdown();
        }
    }

    @Override
    public void removeInstance(LatencyScoreStrategy.Instance instance) {
        this.instances.remove(instance);
    }

    @Override
    public <CL> List<HostConnectionPool<CL>> sortAndfilterPartition(List<HostConnectionPool<CL>> srcPools, AtomicBoolean prioritized) {
        ArrayList pools = Lists.newArrayList(srcPools);
        Collections.sort(pools, this.scoreComparator);
        prioritized.set(false);
        int poolSize = pools.size();
        int keep = (int)Math.max(1.0, Math.ceil((double)poolSize * this.getKeepRatio()));
        Iterator iter = pools.iterator();
        while (iter.hasNext()) {
            HostConnectionPool pool = (HostConnectionPool)iter.next();
            if (!pool.isReconnecting()) continue;
            iter.remove();
        }
        if (pools.size() > 0) {
            double scoreFirst;
            int first;
            for (first = 0; ((HostConnectionPool)pools.get(0)).getScore() == 0.0 && first < pools.size(); ++first) {
            }
            if (first < pools.size() && (scoreFirst = ((HostConnectionPool)pools.get(first)).getScore()) > 0.0) {
                HostConnectionPool pool;
                for (int i = pools.size() - 1; i >= keep && i > first && (pool = (HostConnectionPool)pools.get(i)).getScore() / scoreFirst > this.getScoreThreshold(); --i) {
                    pools.remove(i);
                }
            }
        }
        if (pools.size() > keep) {
            Collections.sort(pools, this.busyComparator);
            HostConnectionPool poolFirst = (HostConnectionPool)pools.get(0);
            int firstBusy = poolFirst.getBusyConnectionCount() - poolFirst.getBlockedThreadCount();
            for (int i = pools.size() - 1; i >= keep; --i) {
                HostConnectionPool pool = (HostConnectionPool)pools.get(i);
                int busy = pool.getBusyConnectionCount() + pool.getBlockedThreadCount();
                if (busy - firstBusy <= this.getBlockedThreshold()) continue;
                pools.remove(i);
            }
        }
        Collections.shuffle(pools);
        return pools;
    }

    @Override
    public void update() {
        for (LatencyScoreStrategy.Instance inst : this.instances) {
            inst.update();
        }
    }

    @Override
    public void reset() {
        for (LatencyScoreStrategy.Instance inst : this.instances) {
            inst.reset();
        }
    }

    @Override
    public int getUpdateInterval() {
        return this.updateInterval;
    }

    @Override
    public int getResetInterval() {
        return this.resetInterval;
    }

    @Override
    public double getScoreThreshold() {
        return this.scoreThreshold;
    }

    @Override
    public int getBlockedThreshold() {
        return this.blockedThreshold;
    }

    @Override
    public double getKeepRatio() {
        return this.keepRatio;
    }
}

