/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.mapping;

import com.google.common.collect.Maps;
import com.netflix.astyanax.mapping.AnnotationSet;
import com.netflix.astyanax.mapping.DefaultAnnotationSet;
import com.netflix.astyanax.mapping.Mapping;
import java.util.Map;

public class MappingCache {
    private final Map<Class<?>, Mapping<?>> cache = Maps.newConcurrentMap();

    public <T> Mapping<T> getMapping(Class<T> clazz, boolean includeParentFields) {
        return this.getMapping(clazz, new DefaultAnnotationSet(), includeParentFields);
    }

    public <T> Mapping<T> getMapping(Class<T> clazz) {
        return this.getMapping(clazz, false);
    }

    public <T> Mapping<T> getMapping(Class<T> clazz, AnnotationSet<?, ?> annotationSet, boolean includeParentFields) {
        Mapping<Object> mapping = this.cache.get(clazz);
        if (mapping == null) {
            mapping = new Mapping<T>(clazz, annotationSet, includeParentFields);
            this.cache.put(clazz, mapping);
        }
        return mapping;
    }

    public <T> Mapping<T> getMapping(Class<T> clazz, AnnotationSet<?, ?> annotationSet) {
        return this.getMapping(clazz, annotationSet, false);
    }
}

