/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.sql.compile.ExpressionClassBuilderInterface;
import org.apache.derby.iapi.sql.compile.JoinStrategy;
import org.apache.derby.iapi.sql.compile.Optimizable;
import org.apache.derby.iapi.sql.compile.OptimizablePredicateList;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.ConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.store.access.StaticCompiledOpenConglomInfo;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.util.PropertyUtil;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;

abstract class BaseJoinStrategy
implements JoinStrategy {
    BaseJoinStrategy() {
    }

    public boolean bulkFetchOK() {
        return true;
    }

    public boolean ignoreBulkFetch() {
        return false;
    }

    void fillInScanArgs1(TransactionController transactionController, MethodBuilder methodBuilder, Optimizable optimizable, OptimizablePredicateList optimizablePredicateList, ExpressionClassBuilderInterface expressionClassBuilderInterface, int n) throws StandardException {
        boolean bl = optimizablePredicateList.sameStartStopPosition();
        ExpressionClassBuilder expressionClassBuilder = (ExpressionClassBuilder)expressionClassBuilderInterface;
        long l = optimizable.getTrulyTheBestAccessPath().getConglomerateDescriptor().getConglomerateNumber();
        StaticCompiledOpenConglomInfo staticCompiledOpenConglomInfo = transactionController.getStaticCompiledConglomInfo(l);
        expressionClassBuilder.pushThisAsActivation(methodBuilder);
        methodBuilder.push(l);
        methodBuilder.push(expressionClassBuilder.addItem(staticCompiledOpenConglomInfo));
        methodBuilder.push(n);
        methodBuilder.push(optimizable.getResultSetNumber());
        optimizablePredicateList.generateStartKey(expressionClassBuilder, methodBuilder, optimizable);
        methodBuilder.push(optimizablePredicateList.startOperator(optimizable));
        if (!bl) {
            optimizablePredicateList.generateStopKey(expressionClassBuilder, methodBuilder, optimizable);
        } else {
            methodBuilder.pushNull("org.apache.derby.iapi.services.loader.GeneratedMethod");
        }
        methodBuilder.push(optimizablePredicateList.stopOperator(optimizable));
        methodBuilder.push(bl);
        optimizablePredicateList.generateQualifiers(expressionClassBuilder, methodBuilder, optimizable, true);
        methodBuilder.upCast("org.apache.derby.iapi.store.access.Qualifier[][]");
    }

    final void fillInScanArgs2(MethodBuilder methodBuilder, Optimizable optimizable, int n, int n2, int n3, int n4, boolean bl, int n5) throws StandardException {
        methodBuilder.push(optimizable.getBaseTableName());
        if (optimizable.getProperties() != null) {
            methodBuilder.push(PropertyUtil.sortProperties(optimizable.getProperties()));
        } else {
            methodBuilder.pushNull("java.lang.String");
        }
        ConglomerateDescriptor conglomerateDescriptor = optimizable.getTrulyTheBestAccessPath().getConglomerateDescriptor();
        if (conglomerateDescriptor.isConstraint()) {
            DataDictionary dataDictionary = optimizable.getDataDictionary();
            TableDescriptor tableDescriptor = optimizable.getTableDescriptor();
            ConstraintDescriptor constraintDescriptor = dataDictionary.getConstraintDescriptor(tableDescriptor, conglomerateDescriptor.getUUID());
            methodBuilder.push(constraintDescriptor.getConstraintName());
        } else if (conglomerateDescriptor.isIndex()) {
            methodBuilder.push(conglomerateDescriptor.getConglomerateName());
        } else {
            methodBuilder.pushNull("java.lang.String");
        }
        methodBuilder.push(conglomerateDescriptor.isConstraint());
        methodBuilder.push(optimizable.forUpdate());
        methodBuilder.push(n2);
        methodBuilder.push(n3);
        methodBuilder.push(n4);
        methodBuilder.push(bl);
        methodBuilder.push(n5);
        if (n > 0) {
            methodBuilder.push(n);
            methodBuilder.push(optimizable.hasLargeObjectColumns());
        }
        if (this.validForOutermostTable()) {
            methodBuilder.push(optimizable.isOneRowScan());
        }
        methodBuilder.push(optimizable.getTrulyTheBestAccessPath().getCostEstimate().rowCount());
        methodBuilder.push(optimizable.getTrulyTheBestAccessPath().getCostEstimate().getEstimatedCost());
    }

    public boolean isHashJoin() {
        return false;
    }

    protected boolean validForOutermostTable() {
        return false;
    }
}

