/*
 * Decompiled with CFR 0.152.
 */
package org.jabsorb.serializer.impl;

import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import org.jabsorb.serializer.AbstractSerializer;
import org.jabsorb.serializer.MarshallException;
import org.jabsorb.serializer.ObjectMatch;
import org.jabsorb.serializer.SerializerState;
import org.jabsorb.serializer.UnmarshallException;
import org.json.JSONException;
import org.json.JSONObject;

public class DateSerializer
extends AbstractSerializer {
    private static final long serialVersionUID = 2L;
    private static Class[] _serializableClasses = new Class[]{Date.class, Timestamp.class, java.sql.Date.class, Time.class};
    private static Class[] _JSONClasses = new Class[]{JSONObject.class};

    public Class[] getJSONClasses() {
        return _JSONClasses;
    }

    public Class[] getSerializableClasses() {
        return _serializableClasses;
    }

    public Object marshall(SerializerState state, Object p, Object o) throws MarshallException {
        if (!(o instanceof Date)) {
            throw new MarshallException("cannot marshall date using class " + o.getClass());
        }
        long time = ((Date)o).getTime();
        JSONObject obj = new JSONObject();
        try {
            if (this.ser.getMarshallClassHints()) {
                obj.put("javaClass", (Object)o.getClass().getName());
            }
            obj.put("time", time);
        }
        catch (JSONException e) {
            throw new MarshallException(e.getMessage(), e);
        }
        return obj;
    }

    public ObjectMatch tryUnmarshall(SerializerState state, Class clazz, Object o) throws UnmarshallException {
        String java_class;
        JSONObject jso = (JSONObject)o;
        try {
            java_class = jso.getString("javaClass");
        }
        catch (JSONException e) {
            throw new UnmarshallException("no type hint", e);
        }
        if (java_class == null) {
            throw new UnmarshallException("no type hint");
        }
        if (!(java_class.equals("java.util.Date") || java_class.equals("java.sql.Timestamp") || java_class.equals("java.sql.Time") || java_class.equals("java.sql.Date"))) {
            throw new UnmarshallException("not a Date");
        }
        state.setSerialized(o, ObjectMatch.OKAY);
        return ObjectMatch.OKAY;
    }

    public Object unmarshall(SerializerState state, Class clazz, Object o) throws UnmarshallException {
        long time;
        JSONObject jso = (JSONObject)o;
        try {
            time = jso.getLong("time");
        }
        catch (JSONException e) {
            throw new UnmarshallException("Could not get the time in date serialiser", e);
        }
        if (jso.has("javaClass")) {
            try {
                clazz = Class.forName(jso.getString("javaClass"));
            }
            catch (ClassNotFoundException e) {
                throw new UnmarshallException(e.getMessage(), e);
            }
            catch (JSONException e) {
                throw new UnmarshallException("Could not find javaClass", e);
            }
        }
        Date returnValue = null;
        if (Date.class.equals(clazz)) {
            returnValue = new Date(time);
        } else if (Timestamp.class.equals(clazz)) {
            returnValue = new Timestamp(time);
        } else if (java.sql.Date.class.equals(clazz)) {
            returnValue = new java.sql.Date(time);
        } else if (Time.class.equals(clazz)) {
            returnValue = new Time(time);
        }
        if (returnValue == null) {
            throw new UnmarshallException("invalid class " + clazz);
        }
        state.setSerialized(o, returnValue);
        return returnValue;
    }
}

