/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.gcubesearchlibrary.model.beans;

import gr.uoa.di.madgik.gcubesearchlibrary.model.beans.FieldBean;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ResultBean
implements Serializable {
    private static final long serialVersionUID = 2125040520162650307L;
    private String objectURI = null;
    private String collectionID = null;
    private List<FieldBean> fields;

    public ResultBean(List<FieldBean> fields, String objectURI, String collectionID) {
        this.fields = fields;
        this.objectURI = objectURI;
        this.collectionID = collectionID;
    }

    public List<FieldBean> getResultRecord() {
        ArrayList<FieldBean> detailedFields = new ArrayList<FieldBean>();
        for (FieldBean f : this.fields) {
            if (!f.isPartOfDetailedResult()) continue;
            detailedFields.add(f);
        }
        Collections.sort(detailedFields);
        return detailedFields;
    }

    public List<FieldBean> getShortResultRecord() {
        ArrayList<FieldBean> sFields = new ArrayList<FieldBean>();
        for (FieldBean f : this.fields) {
            if (!f.isPartOfShortResult()) continue;
            sFields.add(f);
        }
        if (!sFields.isEmpty()) {
            return sFields;
        }
        return this.fields;
    }

    public String getShortResultRecordInHtml() {
        String result = "";
        String title = null;
        String snippet = null;
        for (FieldBean f : this.fields) {
            if (f.getName().equalsIgnoreCase("title")) {
                title = f.getId();
                continue;
            }
            if (!f.getName().equalsIgnoreCase("S")) continue;
            snippet = f.getId();
        }
        if (title != null) {
            result = result + "<b>" + title + "</b><br>";
        }
        if (snippet != null) {
            result = result + snippet;
        }
        return result;
    }

    public String getObjectURI() {
        return this.objectURI;
    }

    public String getCollectionID() {
        return this.collectionID;
    }
}

