/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.statement.create.table;

import java.util.List;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.StatementVisitor;
import net.sf.jsqlparser.statement.create.table.ColumnDefinition;
import net.sf.jsqlparser.statement.create.table.Index;
import net.sf.jsqlparser.statement.select.PlainSelect;

public class CreateTable
implements Statement {
    private Table table;
    private List<String> tableOptionsStrings;
    private List<ColumnDefinition> columnDefinitions;
    private List<Index> indexes;

    @Override
    public void accept(StatementVisitor statementVisitor) {
        statementVisitor.visit(this);
    }

    public Table getTable() {
        return this.table;
    }

    public void setTable(Table table) {
        this.table = table;
    }

    public List<ColumnDefinition> getColumnDefinitions() {
        return this.columnDefinitions;
    }

    public void setColumnDefinitions(List<ColumnDefinition> list) {
        this.columnDefinitions = list;
    }

    public List<?> getTableOptionsStrings() {
        return this.tableOptionsStrings;
    }

    public void setTableOptionsStrings(List<String> list) {
        this.tableOptionsStrings = list;
    }

    public List<Index> getIndexes() {
        return this.indexes;
    }

    public void setIndexes(List<Index> list) {
        this.indexes = list;
    }

    public String toString() {
        String sql = "";
        sql = "CREATE TABLE " + this.table + " (";
        sql = sql + PlainSelect.getStringList(this.columnDefinitions, true, false);
        if (this.indexes != null && this.indexes.size() != 0) {
            sql = sql + ", ";
            sql = sql + PlainSelect.getStringList(this.indexes);
        }
        sql = sql + ")";
        String options = PlainSelect.getStringList(this.tableOptionsStrings, false, false);
        if (options != null && options.length() > 0) {
            sql = sql + " " + options;
        }
        return sql;
    }
}

