/*
 * Decompiled with CFR 0.152.
 */
package JOscarLib.Packet.Received;

import JOscarLib.Core.Exceptions.LoginException;
import JOscarLib.Core.OscarClient;
import JOscarLib.Core.OscarConnection;
import JOscarLib.Packet.Received.ReceivedPacket;
import JOscarLib.Tlv;
import java.io.IOException;

public class AuthorizationReply
extends ReceivedPacket {
    private Tlv uin;
    private Tlv bosServerAddress;
    private Tlv cookie;
    private Tlv errorCode;
    private Tlv url;
    private boolean readyToConnect = false;

    public AuthorizationReply(byte[] packet) {
        super(packet, false);
        int position = 0;
        this.uin = new Tlv(this.getDataFieldByteArray(), position);
        Tlv tempTlv = new Tlv(this.getDataFieldByteArray(), position += this.uin.getStringValue().length() + 4);
        if (tempTlv.getType() == 4) {
            this.url = tempTlv;
        } else if (tempTlv.getType() == 5) {
            this.bosServerAddress = tempTlv;
            this.cookie = new Tlv(this.getDataFieldByteArray(), position += tempTlv.getLength() + 4);
            this.readyToConnect = true;
        } else if (tempTlv.getType() == 8) {
            this.errorCode = tempTlv;
            position += tempTlv.getLength() + 4;
            if (this.getDataFieldByteArray().length > 14) {
                this.url = new Tlv(this.getDataFieldByteArray(), position);
            }
        }
    }

    public void execute(OscarConnection connection) throws LoginException {
        try {
            if (!this.readyToConnect) {
                throw new LoginException("Error Code (" + this.errorCode.getValue() + ") : " + this.getErrorExplanation());
            }
            this.connectToBos(connection);
        }
        catch (IOException IOE) {
            throw new LoginException(IOE.getMessage());
        }
    }

    public void connectToBos(OscarConnection connection) throws IOException {
        connection.getClient().disconnect();
        OscarClient bosClient = new OscarClient(this.getBosServerAddress(), this.getBosServerPort(), connection.getPacketAnalyser());
        connection.setClient(bosClient);
        connection.setCookie(this.cookie);
        connection.getClient().connectToServer();
    }

    public String getUin() {
        return this.uin.getStringValue();
    }

    public String getBosServerAddress() {
        int dbpt = this.bosServerAddress.getStringValue().indexOf(58);
        return this.bosServerAddress.getStringValue().substring(0, dbpt);
    }

    public int getBosServerPort() {
        int dbpt = this.bosServerAddress.getStringValue().indexOf(58);
        return Integer.parseInt(this.bosServerAddress.getStringValue().substring(dbpt + 1, this.bosServerAddress.getStringValue().length()));
    }

    public Tlv getCookie() {
        return this.cookie;
    }

    public int getErrorcode() {
        return this.errorCode.getValue();
    }

    public String getUrl() {
        return this.url.getStringValue();
    }

    private String getErrorExplanation() {
        String explanation = "Unknown Error";
        switch (this.errorCode.getValue()) {
            case 1: {
                explanation = "Bad UIN.";
                break;
            }
            case 4: 
            case 5: {
                explanation = "Password incorrect.";
                break;
            }
            case 7: 
            case 8: {
                explanation = "This ICQ number does not exist.";
                break;
            }
            case 22: 
            case 23: {
                explanation = "The amount of users connected from this IP has reached the maximum.";
                break;
            }
            case 24: 
            case 29: {
                explanation = "Rate limit exceeded. Please try to reconnect in a few minutes.";
                break;
            }
            case 27: 
            case 28: {
                explanation = "You are using an older version of ICQ. Please upgrade.";
                break;
            }
            case 30: {
                explanation = "Can't register on the ICQ network. Reconnect in a few minutes.";
            }
        }
        return explanation;
    }
}

