/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.cache.index;

import com.liferay.portal.kernel.cache.CacheListener;
import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.cache.index.IndexEncoder;
import com.liferay.portal.kernel.concurrent.ConcurrentHashSet;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class PortalCacheIndexer<I, K extends Serializable, V> {
    private final ConcurrentMap<I, Set<K>> _indexedCacheKeys = new ConcurrentHashMap<I, Set<K>>();
    private final IndexEncoder<I, K> _indexEncoder;
    private final PortalCache<K, V> _portalCache;

    public PortalCacheIndexer(IndexEncoder<I, K> indexEncoder, PortalCache<K, V> portalCache) {
        this._indexEncoder = indexEncoder;
        this._portalCache = portalCache;
        this._portalCache.registerCacheListener(new IndexerCacheListener());
        for (Serializable indexedCacheKey : this._portalCache.getKeys()) {
            this._addIndexedCacheKey(indexedCacheKey);
        }
    }

    public Set<K> getKeys(I index) {
        Set keys = (Set)this._indexedCacheKeys.get(index);
        if (keys == null) {
            return Collections.emptySet();
        }
        return new HashSet(keys);
    }

    public void removeKeys(I index) {
        Set keys = (Set)this._indexedCacheKeys.remove(index);
        if (keys == null) {
            return;
        }
        for (Serializable key : keys) {
            this._portalCache.remove(key);
        }
    }

    private void _addIndexedCacheKey(K key) {
        I index = this._indexEncoder.encode(key);
        Set keys = (Set)this._indexedCacheKeys.get(index);
        if (keys == null) {
            ConcurrentHashSet<K> newKeys = new ConcurrentHashSet<K>();
            newKeys.add(key);
            keys = this._indexedCacheKeys.putIfAbsent(index, newKeys);
            if (keys == null) {
                return;
            }
        }
        keys.add(key);
    }

    private void _removeIndexedCacheKey(K key) {
        I index = this._indexEncoder.encode(key);
        Set keys = (Set)this._indexedCacheKeys.get(index);
        if (keys == null) {
            return;
        }
        keys.remove(key);
        if (keys.isEmpty() && this._indexedCacheKeys.remove(index, keys)) {
            for (Serializable victimIndexedCacheKey : keys) {
                this._addIndexedCacheKey(victimIndexedCacheKey);
            }
        }
    }

    private class IndexerCacheListener
    implements CacheListener<K, V> {
        private IndexerCacheListener() {
        }

        @Override
        public void notifyEntryEvicted(PortalCache<K, V> portalCache, K key, V value) {
            PortalCacheIndexer.this._removeIndexedCacheKey(key);
        }

        @Override
        public void notifyEntryExpired(PortalCache<K, V> portalCache, K key, V value) {
            PortalCacheIndexer.this._removeIndexedCacheKey(key);
        }

        @Override
        public void notifyEntryPut(PortalCache<K, V> portalCache, K key, V value) {
            PortalCacheIndexer.this._addIndexedCacheKey(key);
        }

        @Override
        public void notifyEntryRemoved(PortalCache<K, V> portalCache, K key, V value) {
            PortalCacheIndexer.this._removeIndexedCacheKey(key);
        }

        @Override
        public void notifyEntryUpdated(PortalCache<K, V> portalCache, K key, V value) {
        }

        @Override
        public void notifyRemoveAll(PortalCache<K, V> portalCache) {
            PortalCacheIndexer.this._indexedCacheKeys.clear();
        }
    }
}

