/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.messaging.proxy;

import com.liferay.portal.kernel.messaging.proxy.ExecutingClassLoaders;
import com.liferay.portal.kernel.messaging.proxy.ProxyRequest;
import com.liferay.portal.kernel.util.AggregateClassLoader;
import com.liferay.portal.kernel.util.ArrayUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class MultiClassLoaderProxyRequest
extends ProxyRequest {
    private ClassLoader _clientClassLoaders;

    public MultiClassLoaderProxyRequest(Method method, Object[] arguments) throws Exception {
        super(method, arguments);
        ClassLoader[] classLoaders = this.inspectForClassLoaders(method);
        this._clientClassLoaders = AggregateClassLoader.getAggregateClassLoader(classLoaders);
    }

    @Override
    public Object execute(Object object) throws Exception {
        ClassLoader contextClassLoader = null;
        if (this._clientClassLoaders != null) {
            Thread currentThread = Thread.currentThread();
            contextClassLoader = currentThread.getContextClassLoader();
            ClassLoader invocationClassLoader = AggregateClassLoader.getAggregateClassLoader(new ClassLoader[]{contextClassLoader, this._clientClassLoaders});
            currentThread.setContextClassLoader(invocationClassLoader);
        }
        try {
            Object object2 = super.execute(object);
            return object2;
        }
        catch (InvocationTargetException ite) {
            throw new Exception(ite.getTargetException());
        }
        finally {
            if (contextClassLoader != null) {
                Thread currentThread = Thread.currentThread();
                currentThread.setContextClassLoader(contextClassLoader);
            }
        }
    }

    protected ClassLoader[] inspectForClassLoaders(Method method) throws Exception {
        Annotation[][] annotationsArray = method.getParameterAnnotations();
        if (ArrayUtil.isEmpty((Object[])annotationsArray)) {
            return null;
        }
        int i = 0;
        while (i < annotationsArray.length) {
            Object[] annotations = annotationsArray[i];
            if (!ArrayUtil.isEmpty(annotations)) {
                Object[] objectArray = annotations;
                int n = annotations.length;
                int n2 = 0;
                while (n2 < n) {
                    Object annotation = objectArray[n2];
                    if (ExecutingClassLoaders.class.isAssignableFrom(annotation.annotationType())) {
                        return (ClassLoader[])this.getArguments()[i];
                    }
                    ++n2;
                }
            }
            ++i;
        }
        return null;
    }
}

