/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.monitoring.statistics;

import com.liferay.portal.kernel.monitoring.statistics.DataSample;
import com.liferay.portal.kernel.util.AutoResetThreadLocal;
import com.liferay.portal.kernel.util.ListUtil;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

public class DataSampleThreadLocal {
    private static ThreadLocal<DataSampleThreadLocal> _dataSampleThreadLocal = new AutoResetThreadLocal<DataSampleThreadLocal>(DataSampleThreadLocal.class + "._dataSampleThreadLocal"){

        @Override
        protected DataSampleThreadLocal copy(DataSampleThreadLocal dataSampleThreadLocal) {
            return dataSampleThreadLocal;
        }

        @Override
        protected DataSampleThreadLocal initialValue() {
            return new DataSampleThreadLocal(null);
        }
    };
    private Queue<DataSample> _dataSamples = new ConcurrentLinkedQueue<DataSample>();
    private long _monitorTime = System.currentTimeMillis();

    public static void addDataSample(DataSample dataSample) {
        DataSampleThreadLocal dataSampleThreadLocal = _dataSampleThreadLocal.get();
        dataSampleThreadLocal._addDataSample(dataSample);
    }

    public static void clearDataSamples() {
        _dataSampleThreadLocal.remove();
    }

    public static List<DataSample> getDataSamples() {
        DataSampleThreadLocal dataSampleThreadLocal = _dataSampleThreadLocal.get();
        return ListUtil.fromCollection(dataSampleThreadLocal._getDataSamples());
    }

    public static void initialize() {
        _dataSampleThreadLocal.get();
    }

    public Object clone() {
        return new DataSampleThreadLocal();
    }

    public long getMonitorTime() {
        return this._monitorTime;
    }

    private DataSampleThreadLocal() {
    }

    private void _addDataSample(DataSample dataSample) {
        this._dataSamples.add(dataSample);
    }

    private Queue<DataSample> _getDataSamples() {
        return this._dataSamples;
    }

    /* synthetic */ DataSampleThreadLocal(DataSampleThreadLocal dataSampleThreadLocal) {
        this();
    }
}

