/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PropertiesUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.SystemEnv;
import com.liferay.portal.kernel.util.Validator;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;

public class SystemProperties {
    @Deprecated
    public static final String SYSTEM_PROPERTIES_FINAL = "system.properties.final";
    @Deprecated
    public static final String SYSTEM_PROPERTIES_LOAD = "system.properties.load";
    public static final String SYSTEM_PROPERTIES_QUIET = "system.properties.quiet";
    public static final String SYSTEM_PROPERTIES_SET = "system.properties.set";
    public static final String SYSTEM_PROPERTIES_SET_OVERRIDE = "system.properties.set.override";
    public static final String TMP_DIR = "java.io.tmpdir";
    @Deprecated
    private static boolean _loaded;
    private static Map<String, String> _properties;

    static {
        InputStream inputStream;
        URL url;
        Properties properties = new Properties();
        Thread currentThread = Thread.currentThread();
        ClassLoader classLoader = currentThread.getContextClassLoader();
        ArrayList<URL> urls = null;
        if (!GetterUtil.getBoolean(System.getProperty(SYSTEM_PROPERTIES_QUIET))) {
            urls = new ArrayList<URL>();
        }
        try {
            url = classLoader.getResource("system.properties");
            if (url != null) {
                inputStream = url.openStream();
                properties.load(inputStream);
                inputStream.close();
                if (urls != null) {
                    urls.add(url);
                }
            }
        }
        catch (IOException ioe) {
            throw new ExceptionInInitializerError(ioe);
        }
        try {
            url = classLoader.getResource("system-ext.properties");
            if (url != null) {
                inputStream = url.openStream();
                properties.load(inputStream);
                inputStream.close();
                if (urls != null) {
                    urls.add(url);
                }
            }
        }
        catch (IOException ioe) {
            throw new ExceptionInInitializerError(ioe);
        }
        SystemEnv.setProperties(properties);
        if (GetterUtil.getBoolean(System.getProperty(SYSTEM_PROPERTIES_SET), true)) {
            boolean systemPropertiesSetOverride = GetterUtil.getBoolean(System.getProperty(SYSTEM_PROPERTIES_SET_OVERRIDE), true);
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                String key = String.valueOf(entry.getKey());
                if (!systemPropertiesSetOverride && !Validator.isNull(System.getProperty(key))) continue;
                System.setProperty(key, String.valueOf(entry.getValue()));
            }
        }
        _properties = new ConcurrentHashMap<String, String>();
        PropertiesUtil.fromProperties(properties, _properties);
        if (urls != null) {
            for (URL url2 : urls) {
                System.out.println("Loading " + url2);
            }
        }
    }

    public static String get(String key) {
        String value = _properties.get(key);
        if (value == null) {
            value = System.getProperty(key);
        }
        return value;
    }

    @Deprecated
    public static String[] getArray(String key) {
        String value = SystemProperties.get(key);
        if (value == null) {
            return new String[0];
        }
        return StringUtil.split(value);
    }

    public static Properties getProperties() {
        return PropertiesUtil.fromMap(_properties);
    }

    @Deprecated
    public static void reload() {
        InputStream inputStream;
        URL url;
        if (_loaded) {
            return;
        }
        Properties properties = new Properties();
        Thread currentThread = Thread.currentThread();
        ClassLoader classLoader = currentThread.getContextClassLoader();
        boolean systemPropertiesQuiet = GetterUtil.getBoolean(System.getProperty(SYSTEM_PROPERTIES_QUIET));
        try {
            url = classLoader.getResource("system.properties");
            if (url != null) {
                inputStream = url.openStream();
                properties.load(inputStream);
                inputStream.close();
                if (!systemPropertiesQuiet) {
                    System.out.println("Loading " + url);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            url = classLoader.getResource("system-ext.properties");
            if (url != null) {
                _loaded = true;
                inputStream = url.openStream();
                properties.load(inputStream);
                inputStream.close();
                if (!systemPropertiesQuiet) {
                    System.out.println("Loading " + url);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        SystemEnv.setProperties(properties);
        boolean systemPropertiesLoad = GetterUtil.getBoolean(System.getProperty(SYSTEM_PROPERTIES_LOAD), true);
        boolean systemPropertiesFinal = GetterUtil.getBoolean(System.getProperty(SYSTEM_PROPERTIES_FINAL), true);
        if (systemPropertiesLoad) {
            Enumeration<?> enu = properties.propertyNames();
            while (enu.hasMoreElements()) {
                String key = (String)enu.nextElement();
                if (!systemPropertiesFinal && !Validator.isNull(System.getProperty(key))) continue;
                System.setProperty(key, properties.getProperty(key));
            }
        }
        _properties = new ConcurrentHashMap<String, String>();
        PropertiesUtil.fromProperties(properties, _properties);
    }

    public static void set(String key, String value) {
        System.setProperty(key, value);
        _properties.put(key, value);
    }
}

