/*
 * Decompiled with CFR 0.152.
 */
package org.portletbridge.portlet;

import java.io.IOException;
import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.GenericPortlet;
import javax.portlet.PortletException;
import javax.portlet.PortletPreferences;
import javax.portlet.ReadOnlyException;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.portletbridge.portlet.PortletFunctions;

public class BridgeEditPortlet
extends GenericPortlet {
    private Templates templates = null;

    public void init() throws PortletException {
    }

    protected void doEdit(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        PortletPreferences preferences = request.getPreferences();
        String secureEdit = preferences.getValue("secureEdit", "false");
        if ("true".equalsIgnoreCase(secureEdit) && !request.isUserInRole("portletbridge")) {
            throw new PortletException(this.getPortletConfig().getResourceBundle(request.getLocale()).getString("error.invalid.role"));
        }
        response.setContentType("text/html");
        try {
            Transformer transformer = this.templates.newTransformer();
            transformer.setParameter("portlet", new PortletFunctions(request, response));
            transformer.transform(new StreamSource(new StringReader("<xml/>")), new StreamResult(response.getWriter()));
        }
        catch (TransformerConfigurationException e) {
            throw new PortletException((Throwable)e);
        }
        catch (TransformerException e) {
            throw new PortletException((Throwable)e);
        }
        catch (IOException e) {
            throw new PortletException((Throwable)e);
        }
    }

    public void processAction(ActionRequest request, ActionResponse response) throws PortletException, IOException {
        PortletPreferences preferences = request.getPreferences();
        String initUrlParameter = request.getParameter("initUrl");
        if (initUrlParameter != null && initUrlParameter.trim().length() > 0) {
            try {
                URI initUrl = new URI(initUrlParameter);
                if (initUrl.getPath() == null || "".equals(initUrl.getPath())) {
                    initUrl = new URI(initUrlParameter + "/");
                }
                preferences.setValue("initUrl", initUrl.toString());
            }
            catch (URISyntaxException e) {
                throw new PortletException((Throwable)e);
            }
        }
        this.setIfNotNull(request, preferences, "scope");
        this.setIfNotNull(request, preferences, "proxyHost");
        this.setIfNotNull(request, preferences, "proxyPort");
        this.setIfNotNull(request, preferences, "proxyAuthentication");
        this.setIfNotNull(request, preferences, "proxyAuthenticationUsername");
        this.setIfNotNull(request, preferences, "proxyAuthenticationPassword");
        this.setIfNotNull(request, preferences, "proxyAuthenticationHost");
        this.setIfNotNull(request, preferences, "proxyAuthenticationDomain");
        this.setIfNotNull(request, preferences, "stylesheet");
        preferences.store();
    }

    protected void setIfNotNull(ActionRequest request, PortletPreferences preferences, String parameterName) throws ReadOnlyException {
        String parameterValue = request.getParameter(parameterName);
        if (parameterValue != null) {
            preferences.setValue(parameterName, parameterValue);
        }
    }

    public void setTemplates(Templates templates) {
        this.templates = templates;
    }
}

