/*
 * Decompiled with CFR 0.152.
 */
package org.portletbridge.portlet;

import java.net.URI;
import java.util.regex.Pattern;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.portletbridge.portlet.BridgeRequest;
import org.portletbridge.portlet.ContentRewriter;
import org.portletbridge.portlet.IdGenerator;
import org.portletbridge.portlet.LinkRewriter;
import org.portletbridge.portlet.PerPortletMemento;
import org.portletbridge.portlet.PortletBridgeMemento;

public class BridgeFunctions
implements LinkRewriter {
    private static final Log log = LogFactory.getLog((Class)(class$org$portletbridge$portlet$BridgeFunctions == null ? (class$org$portletbridge$portlet$BridgeFunctions = BridgeFunctions.class$("org.portletbridge.portlet.BridgeFunctions")) : class$org$portletbridge$portlet$BridgeFunctions));
    private final URI currentUrl;
    private final RenderRequest request;
    private final RenderResponse response;
    private final String servletName;
    private final PortletBridgeMemento memento;
    private final Pattern scope;
    private final PerPortletMemento perPortletMemento;
    private final IdGenerator idGenerator;
    private final ContentRewriter javascriptRewriter;
    private final ContentRewriter cssRewriter;
    static /* synthetic */ Class class$org$portletbridge$portlet$BridgeFunctions;

    public BridgeFunctions(ContentRewriter javascriptRewriter, ContentRewriter cssRewriter, IdGenerator idGenerator, PortletBridgeMemento memento, PerPortletMemento perPortletMemento, String servletName, URI currentUrl, RenderRequest request, RenderResponse response) {
        this.javascriptRewriter = javascriptRewriter;
        this.cssRewriter = cssRewriter;
        this.idGenerator = idGenerator;
        this.memento = memento;
        this.perPortletMemento = perPortletMemento;
        this.servletName = servletName;
        this.currentUrl = currentUrl;
        this.request = request;
        this.response = response;
        this.scope = perPortletMemento != null ? perPortletMemento.getScope() : Pattern.compile(".*");
    }

    public String link(String baseUrl, String link) {
        if (link.startsWith("javascript:")) {
            return this.script(baseUrl, link);
        }
        if (link.equals("#")) {
            return link;
        }
        return this.rewrite(baseUrl, link, true);
    }

    private String rewrite(String baseUrl, String link, boolean checkScope) {
        String trim = link.trim().replace(' ', '+');
        URI url = null;
        if (baseUrl != null && baseUrl.trim().length() > 0) {
            URI baseUri = this.currentUrl.resolve(baseUrl);
            url = baseUri.resolve(trim);
        } else {
            url = this.currentUrl.resolve(trim);
        }
        if (url.getScheme().equals("http") || url.getScheme().equals("https")) {
            if (!checkScope || this.shouldRewrite(url)) {
                BridgeRequest bridgeRequest = this.memento.createBridgeRequest(this.response, this.idGenerator.nextId(), url);
                String name = url.getPath();
                int lastIndex = name.lastIndexOf(47);
                if (lastIndex != -1 && (name = name.substring(lastIndex + 1)).equals("") && lastIndex > 0) {
                    name = url.getPath().substring(url.getPath().lastIndexOf(47, lastIndex - 1));
                }
                if (name.startsWith("/")) {
                    name = name.substring(1);
                }
                name = this.request.getContextPath() + '/' + this.servletName + '/' + bridgeRequest.getId() + "/" + name;
                return name;
            }
            return url.toString();
        }
        return link;
    }

    public String style(String baseUrl, String css) {
        return this.cssRewriter.rewrite(baseUrl, css, this);
    }

    private boolean shouldRewrite(URI uri) {
        return this.scope.matcher(uri.toString()).matches();
    }

    public String script(String baseUrl, String script) {
        return this.javascriptRewriter.rewrite(baseUrl, script, this);
    }

    public URI getCurrentUrl() {
        return this.currentUrl;
    }

    public void setTitle(String title) {
        this.response.setTitle(title);
    }

    public PortletBridgeMemento getMemento() {
        return this.memento;
    }

    public PerPortletMemento getPerPortletMemento() {
        return this.perPortletMemento;
    }

    public RenderRequest getRequest() {
        return this.request;
    }

    public RenderResponse getResponse() {
        return this.response;
    }

    public String getServletName() {
        return this.servletName;
    }

    public boolean equalsIgnoreCase(String s1, String s2) {
        if (s1 == s2) {
            return true;
        }
        if (s1 == null) {
            return false;
        }
        return s1.equalsIgnoreCase(s2);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

