/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.ImagePlus;
import ij.gui.Roi;
import ij.io.FileSaver;
import ij.process.ImageProcessor;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;

public class ImageRoi
extends Roi {
    private Image img;
    private Composite composite;
    private double opacity = 1.0;

    public ImageRoi(int x, int y, BufferedImage bi) {
        super(x, y, bi.getWidth(), bi.getHeight());
        this.img = bi;
        this.setStrokeColor(Color.black);
    }

    public ImageRoi(int x, int y, ImageProcessor ip) {
        super(x, y, ip.getWidth(), ip.getHeight());
        this.img = ip.createImage();
        this.setStrokeColor(Color.black);
    }

    public void draw(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        double mag = this.getMagnification();
        int sx2 = this.screenX(this.x + this.width);
        int sy2 = this.screenY(this.y + this.height);
        Composite saveComposite = null;
        if (this.composite != null) {
            saveComposite = g2d.getComposite();
            g2d.setComposite(this.composite);
        }
        g.drawImage(this.img, this.screenX(this.x), this.screenY(this.y), sx2, sy2, 0, 0, this.img.getWidth(null), this.img.getHeight(null), null);
        if (this.composite != null) {
            g2d.setComposite(saveComposite);
        }
    }

    public void setComposite(Composite composite) {
        this.composite = composite;
    }

    public void setOpacity(double opacity) {
        if (opacity < 0.0) {
            opacity = 0.0;
        }
        if (opacity > 1.0) {
            opacity = 1.0;
        }
        this.opacity = opacity;
        this.composite = opacity != 1.0 ? AlphaComposite.getInstance(3, (float)opacity) : null;
    }

    public byte[] getSerializedImage() {
        ImagePlus imp = new ImagePlus("", this.img);
        return new FileSaver(imp).serialize();
    }

    public double getOpacity() {
        return this.opacity;
    }

    public synchronized Object clone() {
        ImagePlus imp = new ImagePlus("", this.img);
        ImageRoi roi2 = new ImageRoi(this.x, this.y, imp.getProcessor());
        roi2.setOpacity(this.getOpacity());
        return roi2;
    }
}

