/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Macro;
import ij.Prefs;
import ij.Undo;
import ij.WindowManager;
import ij.gui.Arrow;
import ij.gui.GenericDialog;
import ij.gui.ImageCanvas;
import ij.gui.ImageRoi;
import ij.gui.Line;
import ij.gui.Overlay;
import ij.gui.PointRoi;
import ij.gui.PolygonRoi;
import ij.gui.Roi;
import ij.gui.RoiProperties;
import ij.macro.Interpreter;
import ij.plugin.OverlayLabels;
import ij.plugin.PlugIn;
import ij.plugin.frame.RoiManager;
import ij.process.ImageProcessor;
import java.awt.Color;
import java.awt.Frame;
import java.awt.Rectangle;

public class OverlayCommands
implements PlugIn {
    private static int opacity = 100;
    private static Roi defaultRoi = new Roi(0, 0, 1, 1);

    public void run(String arg) {
        if (arg.equals("add")) {
            this.addSelection();
        } else if (arg.equals("image")) {
            this.addImage(false);
        } else if (arg.equals("image-roi")) {
            this.addImage(true);
        } else if (arg.equals("flatten")) {
            this.flatten();
        } else if (arg.equals("hide")) {
            this.hide();
        } else if (arg.equals("show")) {
            this.show();
        } else if (arg.equals("remove")) {
            this.remove();
        } else if (arg.equals("from")) {
            this.fromRoiManager();
        } else if (arg.equals("to")) {
            this.toRoiManager();
        } else if (arg.equals("options")) {
            this.options();
        }
    }

    void addSelection() {
        boolean newOverlay;
        RoiProperties rp;
        boolean points;
        boolean tooWide;
        boolean setPos;
        ImagePlus imp = IJ.getImage();
        String macroOptions = Macro.getOptions();
        if (macroOptions != null && IJ.macroRunning() && macroOptions.indexOf("remove") != -1) {
            imp.setOverlay(null);
            return;
        }
        Roi roi = imp.getRoi();
        if (roi == null && imp.getOverlay() != null) {
            GenericDialog gd = new GenericDialog("No Selection");
            gd.addMessage("\"Overlay>Add\" requires a selection.");
            gd.setInsets(15, 40, 0);
            gd.addCheckbox("Remove existing overlay", false);
            gd.showDialog();
            if (gd.wasCanceled()) {
                return;
            }
            if (gd.getNextBoolean()) {
                imp.setOverlay(null);
            }
            return;
        }
        if (roi == null) {
            IJ.error("This command requires a selection.");
            return;
        }
        roi = (Roi)roi.clone();
        Overlay overlay = imp.getOverlay();
        if (!roi.isDrawingTool()) {
            if (roi.getStroke() == null) {
                roi.setStrokeWidth(defaultRoi.getStrokeWidth());
            }
            if (roi.getStrokeColor() == null || Line.getWidth() > 1 && defaultRoi.getStrokeColor() != null) {
                roi.setStrokeColor(defaultRoi.getStrokeColor());
            }
            if (roi.getFillColor() == null) {
                roi.setFillColor(defaultRoi.getFillColor());
            }
        }
        boolean bl = setPos = defaultRoi.getPosition() != 0;
        if (setPos && imp.getStackSize() > 1) {
            if (imp.isHyperStack() || imp.isComposite()) {
                roi.setPosition(0, imp.getSlice(), imp.getFrame());
            } else {
                roi.setPosition(imp.getCurrentSlice());
            }
        }
        int width = Line.getWidth();
        Rectangle bounds = roi.getBounds();
        boolean bl2 = tooWide = (double)width > (double)Math.max(bounds.width, bounds.height) / 3.0;
        if (roi.getStroke() == null && width > 1 && !tooWide) {
            roi.setStrokeWidth(Line.getWidth());
        }
        boolean bl3 = points = roi instanceof PointRoi && ((PolygonRoi)roi).getNCoordinates() > 1;
        if ((IJ.altKeyDown() || IJ.macroRunning() && Macro.getOptions() != null) && !(rp = new RoiProperties("Add to Overlay", roi)).showDialog()) {
            return;
        }
        String name = roi.getName();
        boolean bl4 = newOverlay = name != null && name.equals("new-overlay");
        if (overlay == null || newOverlay) {
            overlay = OverlayLabels.createOverlay();
        }
        overlay.add(roi);
        defaultRoi = (Roi)roi.clone();
        defaultRoi.setPosition(setPos ? 1 : 0);
        imp.setOverlay(overlay);
        if (points || roi instanceof ImageRoi || roi instanceof Arrow) {
            imp.killRoi();
        }
        Undo.setup(7, imp);
    }

    void addImage(boolean createImageRoi) {
        ImagePlus imp = IJ.getImage();
        int[] wList = WindowManager.getIDList();
        if (wList == null || wList.length < 2) {
            IJ.error("Add Image...", "The command requires at least two open images.");
            return;
        }
        String[] titles = new String[wList.length];
        for (int i = 0; i < wList.length; ++i) {
            ImagePlus imp2 = WindowManager.getImage(wList[i]);
            titles[i] = imp2 != null ? imp2.getTitle() : "";
        }
        int x = 0;
        int y = 0;
        Roi roi = imp.getRoi();
        if (roi != null && roi.isArea()) {
            Rectangle r = roi.getBounds();
            x = r.x;
            y = r.y;
        }
        int index = 0;
        if (wList.length == 2) {
            ImagePlus i1 = WindowManager.getImage(wList[0]);
            ImagePlus i2 = WindowManager.getImage(wList[1]);
            if (i2.getWidth() < i1.getWidth() && i2.getHeight() < i1.getHeight()) {
                index = 1;
            }
        } else if (imp.getID() == wList[0]) {
            index = 1;
        }
        String title = createImageRoi ? "Create Image ROI" : "Add Image...";
        GenericDialog gd = new GenericDialog(title);
        if (createImageRoi) {
            gd.addChoice("Image:", titles, titles[index]);
        } else {
            gd.addChoice("Image to add:", titles, titles[index]);
            gd.addNumericField("X location:", x, 0);
            gd.addNumericField("Y location:", y, 0);
        }
        gd.addNumericField("Opacity (0-100%):", opacity, 0);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        index = gd.getNextChoiceIndex();
        if (!createImageRoi) {
            x = (int)gd.getNextNumber();
            y = (int)gd.getNextNumber();
        }
        opacity = (int)gd.getNextNumber();
        ImagePlus overlay = WindowManager.getImage(wList[index]);
        if (wList.length == 2) {
            ImagePlus i1 = WindowManager.getImage(wList[0]);
            ImagePlus i2 = WindowManager.getImage(wList[1]);
            if (i2.getWidth() < i1.getWidth() && i2.getHeight() < i1.getHeight()) {
                imp = i1;
                overlay = i2;
            }
        }
        if (overlay == imp) {
            IJ.error("Add Image...", "Image to be added cannot be the same as\n\"" + imp.getTitle() + "\".");
            return;
        }
        if (overlay.getWidth() > imp.getWidth() && overlay.getHeight() > imp.getHeight()) {
            IJ.error("Add Image...", "Image to be added cannnot be larger than\n\"" + imp.getTitle() + "\".");
            return;
        }
        if (createImageRoi && x == 0 && y == 0) {
            x = imp.getWidth() / 2 - overlay.getWidth() / 2;
            y = imp.getHeight() / 2 - overlay.getHeight() / 2;
        }
        roi = new ImageRoi(x, y, overlay.getProcessor());
        roi.setName(overlay.getShortTitle());
        if (opacity != 100) {
            ((ImageRoi)roi).setOpacity((double)opacity / 100.0);
        }
        if (createImageRoi) {
            imp.setRoi(roi);
        } else {
            Overlay overlayList = imp.getOverlay();
            if (overlayList == null) {
                overlayList = new Overlay();
            }
            overlayList.add(roi);
            imp.setOverlay(overlayList);
            Undo.setup(7, imp);
        }
    }

    void hide() {
        ImagePlus imp = IJ.getImage();
        imp.setHideOverlay(true);
        RoiManager rm = RoiManager.getInstance();
        if (rm != null) {
            rm.runCommand("show none");
        }
    }

    void show() {
        RoiManager rm;
        ImagePlus imp = IJ.getImage();
        imp.setHideOverlay(false);
        if (imp.getOverlay() == null && (rm = RoiManager.getInstance()) != null && rm.getCount() > 1) {
            if (!IJ.isMacro()) {
                rm.toFront();
            }
            rm.runCommand("show all with labels");
        }
    }

    void remove() {
        RoiManager rm;
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imp != null) {
            imp.setOverlay(null);
        }
        if ((rm = RoiManager.getInstance()) != null) {
            rm.runCommand("show none");
        }
    }

    void flatten() {
        int flags;
        ImagePlus imp = IJ.getImage();
        int n = flags = imp.isComposite() ? 0 : IJ.setupDialog(imp, 0);
        if (flags == 4096) {
            return;
        }
        if (flags == 32) {
            this.flattenStack(imp);
        } else {
            ImagePlus imp2 = imp.flatten();
            imp2.setTitle(WindowManager.getUniqueName(imp.getTitle()));
            imp2.show();
        }
    }

    void flattenStack(ImagePlus imp) {
        Overlay overlay = imp.getOverlay();
        if (overlay == null || !IJ.isJava16() || imp.getBitDepth() != 24) {
            IJ.error("Flatten Stack", "An overlay, Java 1.6 and an RGB image are required.");
            return;
        }
        ImageStack stack = imp.getStack();
        for (int i = 1; i <= stack.getSize(); ++i) {
            ImageProcessor ip = stack.getProcessor(i);
            Roi[] rois = overlay.toArray();
            for (int j = 0; j < rois.length; ++j) {
                Roi roi = rois[j];
                int position = roi.getPosition();
                if (position != 0 && position != i) continue;
                ip.drawRoi(roi);
            }
        }
        imp.setStack(stack);
        imp.setOverlay(null);
    }

    void fromRoiManager() {
        ImagePlus imp = IJ.getImage();
        RoiManager rm = RoiManager.getInstance2();
        if (rm == null) {
            IJ.error("ROI Manager is not open");
            return;
        }
        Roi[] rois = rm.getRoisAsArray();
        if (rois.length == 0) {
            IJ.error("ROI Manager is empty");
            return;
        }
        Overlay overlay = OverlayLabels.createOverlay();
        for (int i = 0; i < rois.length; ++i) {
            Roi roi = (Roi)rois[i].clone();
            if (!Prefs.showAllSliceOnly) {
                roi.setPosition(0);
            }
            if (roi.getStrokeColor() == null || Line.getWidth() > 1 && defaultRoi.getStrokeColor() != null) {
                roi.setStrokeColor(defaultRoi.getStrokeColor());
            }
            if (roi.getFillColor() == null) {
                roi.setFillColor(defaultRoi.getFillColor());
            }
            overlay.add(roi);
        }
        imp.setOverlay(overlay);
        ImageCanvas ic = imp.getCanvas();
        if (ic != null) {
            ic.setShowAllROIs(false);
        }
        rm.setEditMode(imp, false);
        imp.killRoi();
    }

    void toRoiManager() {
        ImagePlus imp = IJ.getImage();
        Overlay overlay = imp.getOverlay();
        if (overlay == null) {
            IJ.error("Overlay required");
            return;
        }
        RoiManager rm = RoiManager.getInstance();
        if (rm == null) {
            if (Macro.getOptions() != null && Interpreter.isBatchMode()) {
                rm = Interpreter.getBatchModeRoiManager();
            }
            if (rm == null) {
                Frame frame = WindowManager.getFrame("ROI Manager");
                if (frame == null) {
                    IJ.run("ROI Manager...");
                }
                if ((frame = WindowManager.getFrame("ROI Manager")) == null || !(frame instanceof RoiManager)) {
                    return;
                }
                rm = (RoiManager)frame;
            }
        }
        if (overlay.size() >= 4 && overlay.get(3).getPosition() != 0) {
            Prefs.showAllSliceOnly = true;
        }
        rm.runCommand("reset");
        for (int i = 0; i < overlay.size(); ++i) {
            rm.add(imp, overlay.get(i), i);
        }
        rm.setEditMode(imp, true);
        if (rm.getCount() == overlay.size()) {
            imp.setOverlay(null);
        }
    }

    void options() {
        boolean points;
        boolean tooWide;
        ImagePlus imp = WindowManager.getCurrentImage();
        Overlay overlay = null;
        Roi roi = null;
        if (imp != null) {
            overlay = imp.getOverlay();
            roi = imp.getRoi();
            if (roi != null) {
                roi = (Roi)roi.clone();
            }
        }
        if (roi == null) {
            roi = defaultRoi;
        }
        if (roi == null) {
            int size = imp != null ? imp.getWidth() : 512;
            roi = new Roi(0, 0, size / 4, size / 4);
        }
        if (!roi.isDrawingTool()) {
            if (roi.getStroke() == null) {
                roi.setStrokeWidth(defaultRoi.getStrokeWidth());
            }
            if (roi.getStrokeColor() == null || Line.getWidth() > 1 && defaultRoi.getStrokeColor() != null) {
                roi.setStrokeColor(defaultRoi.getStrokeColor());
            }
            if (roi.getFillColor() == null) {
                roi.setFillColor(defaultRoi.getFillColor());
            }
        }
        int width = Line.getWidth();
        Rectangle bounds = roi.getBounds();
        boolean bl = tooWide = (double)width > (double)Math.max(bounds.width, bounds.height) / 3.0;
        if (roi.getStroke() == null && width > 1 && !tooWide) {
            roi.setStrokeWidth(Line.getWidth());
        }
        if (roi.getStrokeColor() == null) {
            roi.setStrokeColor(Roi.getColor());
        }
        boolean bl2 = points = roi instanceof PointRoi && ((PolygonRoi)roi).getNCoordinates() > 1;
        if (points) {
            roi.setStrokeColor(Color.red);
        }
        roi.setPosition(defaultRoi.getPosition());
        RoiProperties rp = new RoiProperties("Overlay Options", roi);
        if (!rp.showDialog()) {
            return;
        }
        defaultRoi = roi;
    }

    static {
        defaultRoi.setStrokeColor(Roi.getColor());
    }
}

