/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.ant;

import aQute.bnd.build.Container;
import aQute.bnd.build.Project;
import aQute.bnd.build.Workspace;
import aQute.bnd.osgi.Jar;
import aQute.bnd.service.RepositoryPlugin;
import aQute.bnd.version.Version;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RunconfigToDistributionTask
extends Task {
    private File rootDir;
    private File buildProject;
    private String outputDir;
    private File bndFile;
    private boolean allowSnapshots;
    private Map<String, Jar> snapshots;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        try {
            this.createReleaseDir();
            Project bndProject = new Project(new Workspace(this.rootDir), this.buildProject, this.bndFile);
            List<RepositoryPlugin> repositories = bndProject.getPlugins(RepositoryPlugin.class);
            if (this.allowSnapshots) {
                this.snapshots = this.indexBundleSnapshots();
            }
            for (Container runBundle : bndProject.getRunbundles()) {
                String bsn = runBundle.getBundleSymbolicName();
                if (bsn.endsWith(".jar")) {
                    bsn = bsn.substring(0, bsn.indexOf(".jar"));
                }
                if (this.allowSnapshots && this.snapshots.containsKey(bsn)) {
                    Jar jar = this.snapshots.get(bsn);
                    jar.write(new File(this.outputDir, runBundle.getFile().getName()));
                    continue;
                }
                Version version = null;
                File foundJar = null;
                for (RepositoryPlugin repo : repositories) {
                    SortedSet<Version> versions = repo.versions(bsn);
                    if (versions.isEmpty()) continue;
                    Version foundVersion = versions.last();
                    if (version != null && foundVersion.compareTo(version) != 1) continue;
                    version = foundVersion;
                    foundJar = repo.get(bsn, version, null, new RepositoryPlugin.DownloadListener[0]);
                }
                if (foundJar != null) {
                    File outputFile = new File(this.outputDir, foundJar.getName());
                    FileChannel source = null;
                    AbstractInterruptibleChannel destination = null;
                    try {
                        source = new FileInputStream(foundJar).getChannel();
                        destination = new FileOutputStream(outputFile).getChannel();
                        ((FileChannel)destination).transferFrom(source, 0L, source.size());
                        continue;
                    }
                    finally {
                        if (source != null) {
                            source.close();
                        }
                        if (destination != null) {
                            destination.close();
                        }
                        continue;
                    }
                }
                this.log(bsn + " could not be found in any repository");
            }
            bndProject.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private File createReleaseDir() {
        boolean created;
        File releaseDir = new File(this.outputDir);
        boolean deleted = releaseDir.delete();
        if (deleted) {
            this.log("Deleted directory " + this.outputDir);
        }
        if (!(created = releaseDir.mkdir())) {
            throw new BuildException("Output directory '" + this.outputDir + "' could not be created");
        }
        this.log("Created directory " + this.outputDir);
        return releaseDir;
    }

    private Map<String, Jar> indexBundleSnapshots() {
        File[] projectFolders;
        HashMap<String, Jar> snapshots = new HashMap<String, Jar>();
        for (File projectFolder : projectFolders = this.rootDir.listFiles(new NonTestProjectFileFilter())) {
            File[] generatedFiles;
            for (File generatedFile : generatedFiles = new File(projectFolder, "generated").listFiles(new JarFileFilter())) {
                try {
                    Jar jar = new Jar(generatedFile);
                    snapshots.put(jar.getBsn(), jar);
                }
                catch (Exception e) {
                    this.log("Error creating a bundle from " + generatedFile.getAbsolutePath());
                    e.printStackTrace();
                }
            }
        }
        this.log("Indexed " + snapshots.size() + " snapshots");
        return snapshots;
    }

    public void setRootDir(File rootDir) {
        this.rootDir = rootDir;
    }

    public void setBuildProject(File buildProject) {
        this.buildProject = buildProject;
    }

    public void setOutputDir(String outputDir) {
        this.outputDir = outputDir;
    }

    public void setBndFile(File bndFile) {
        this.bndFile = bndFile;
    }

    public void setAllowSnapshots(boolean allowSnapshots) {
        this.allowSnapshots = allowSnapshots;
    }

    private static class JarFileFilter
    implements FileFilter {
        public boolean accept(File file) {
            return file.getName().endsWith(".jar");
        }
    }

    private static class NonTestProjectFileFilter
    implements FileFilter {
        public boolean accept(File projectFolder) {
            return !projectFolder.getName().endsWith(".test") && this.containsGeneratedFolder(projectFolder);
        }

        private boolean containsGeneratedFolder(File projectFolder) {
            if (projectFolder.isDirectory()) {
                List<File> files = Arrays.asList(projectFolder.listFiles());
                for (File file : files) {
                    if (!file.isDirectory() || !file.getName().equals("generated")) continue;
                    return true;
                }
            }
            return false;
        }
    }
}

