/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.facets.data;

import com.browseengine.bobo.api.BoboIndexReader;
import com.browseengine.bobo.facets.data.MultiValueFacetDataCache;
import com.browseengine.bobo.facets.data.TermListFactory;
import com.browseengine.bobo.facets.data.TermStringList;
import com.browseengine.bobo.facets.data.TermValueList;
import com.browseengine.bobo.util.BigNestedIntArray;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.util.OpenBitSet;

public class MultiValueWithWeightFacetDataCache<T>
extends MultiValueFacetDataCache<T> {
    private static final long serialVersionUID = 1L;
    public final BigNestedIntArray _weightArray = new BigNestedIntArray();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void load(String fieldName, IndexReader reader, TermListFactory<T> listFactory, BoboIndexReader.WorkArea workArea) throws IOException {
        int doc;
        long t0 = System.currentTimeMillis();
        int maxdoc = reader.maxDoc();
        BigNestedIntArray.BufferedLoader loader = this.getBufferedLoader(maxdoc, workArea);
        BigNestedIntArray.BufferedLoader weightLoader = this.getBufferedLoader(maxdoc, null);
        TermEnum tenum = null;
        TermDocs tdoc = null;
        TermValueList list = listFactory == null ? new TermStringList() : listFactory.createTermList();
        IntArrayList minIDList = new IntArrayList();
        IntArrayList maxIDList = new IntArrayList();
        IntArrayList freqList = new IntArrayList();
        OpenBitSet bitset = new OpenBitSet((long)(maxdoc + 1));
        int negativeValueCount = this.getNegativeValueCount(reader, fieldName.intern());
        int t = 0;
        list.add(null);
        minIDList.add(-1);
        maxIDList.add(-1);
        freqList.add(0);
        ++t;
        this._overflow = false;
        String pre = null;
        int df = 0;
        int minID = -1;
        int maxID = -1;
        int valId = 0;
        try {
            tdoc = reader.termDocs();
            tenum = reader.terms(new Term(fieldName, ""));
            if (tenum != null) {
                Term term;
                while ((term = tenum.term()) != null && fieldName.equals(term.field())) {
                    String val = term.text();
                    if (val != null) {
                        int weight = 0;
                        String[] split = val.split("\u0000");
                        if (split.length > 1) {
                            val = split[0];
                            weight = Integer.parseInt(split[split.length - 1]);
                        }
                        if (pre == null || !val.equals(pre)) {
                            if (pre != null) {
                                freqList.add(df);
                                minIDList.add(minID);
                                maxIDList.add(maxID);
                            }
                            list.add(val);
                            df = 0;
                            minID = -1;
                            maxID = -1;
                            valId = t - 1 < negativeValueCount ? negativeValueCount - t + 1 : t;
                            ++t;
                        }
                        tdoc.seek(tenum);
                        if (tdoc.next()) {
                            ++df;
                            int docid = tdoc.doc();
                            if (!loader.add(docid, valId)) {
                                this.logOverflow(fieldName);
                            } else {
                                weightLoader.add(docid, weight);
                            }
                            if (docid < minID) {
                                minID = docid;
                            }
                            bitset.fastSet(docid);
                            while (tdoc.next()) {
                                ++df;
                                docid = tdoc.doc();
                                if (!loader.add(docid, valId)) {
                                    this.logOverflow(fieldName);
                                } else {
                                    weightLoader.add(docid, weight);
                                }
                                bitset.fastSet(docid);
                            }
                            if (docid > maxID) {
                                maxID = docid;
                            }
                        }
                        pre = val;
                    }
                    if (tenum.next()) continue;
                }
                if (pre != null) {
                    freqList.add(df);
                    minIDList.add(minID);
                    maxIDList.add(maxID);
                }
            }
        }
        finally {
            try {
                if (tdoc != null) {
                    tdoc.close();
                }
            }
            finally {
                if (tenum != null) {
                    tenum.close();
                }
            }
        }
        list.seal();
        try {
            this._nestedArray.load(maxdoc + 1, loader);
            this._weightArray.load(maxdoc + 1, weightLoader);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("failed to load due to " + e.toString(), e);
        }
        this.valArray = list;
        this.freqs = freqList.toIntArray();
        this.minIDs = minIDList.toIntArray();
        this.maxIDs = maxIDList.toIntArray();
        for (doc = 0; doc <= maxdoc && !this._nestedArray.contains(doc, 0, true); ++doc) {
        }
        if (doc <= maxdoc) {
            this.minIDs[0] = doc;
            for (doc = maxdoc; doc > 0 && !this._nestedArray.contains(doc, 0, true); --doc) {
            }
            if (doc > 0) {
                this.maxIDs[0] = doc;
            }
        }
        this.freqs[0] = maxdoc + 1 - (int)bitset.cardinality();
    }
}

