/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.facets.data;

import com.browseengine.bobo.facets.data.TermNumberList;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;

public class TermIntList
extends TermNumberList<Integer> {
    private static Logger log = Logger.getLogger(TermIntList.class);
    private int[] _elements = null;
    private int sanity = -1;
    private boolean withDummy = true;
    public static final int VALUE_MISSING = Integer.MIN_VALUE;

    private static int parse(String s) {
        if (s == null || s.length() == 0) {
            return 0;
        }
        return Integer.parseInt(s);
    }

    public TermIntList() {
    }

    public TermIntList(int capacity, String formatString) {
        super(capacity, formatString);
    }

    public TermIntList(String formatString) {
        super(formatString);
    }

    @Override
    public boolean add(String o) {
        if (this._innerList.size() == 0 && o != null) {
            this.withDummy = false;
        }
        int item = TermIntList.parse(o);
        return ((IntArrayList)this._innerList).add(item);
    }

    @Override
    protected List<?> buildPrimitiveList(int capacity) {
        this._type = Integer.class;
        return capacity > 0 ? new IntArrayList(capacity) : new IntArrayList();
    }

    @Override
    public void clear() {
        super.clear();
    }

    @Override
    public String get(int index) {
        DecimalFormat formatter = (DecimalFormat)this._formatter.get();
        if (formatter == null) {
            return String.valueOf(this._elements[index]);
        }
        return formatter.format(this._elements[index]);
    }

    public int getPrimitiveValue(int index) {
        if (index < this._elements.length) {
            return this._elements[index];
        }
        return Integer.MIN_VALUE;
    }

    @Override
    public int indexOf(Object o) {
        if (this.withDummy) {
            if (o == null) {
                return -1;
            }
            int val = o instanceof String ? TermIntList.parse((String)o) : (Integer)o;
            return Arrays.binarySearch(this._elements, 1, this._elements.length, val);
        }
        int val = o instanceof String ? TermIntList.parse((String)o) : (Integer)o;
        return Arrays.binarySearch(this._elements, val);
    }

    public int indexOf(Integer value) {
        if (this.withDummy) {
            if (value == null) {
                return -1;
            }
            return Arrays.binarySearch(this._elements, 1, this._elements.length, value);
        }
        return Arrays.binarySearch(this._elements, value);
    }

    public int indexOf(int val) {
        if (this.withDummy) {
            return Arrays.binarySearch(this._elements, 1, this._elements.length, val);
        }
        return Arrays.binarySearch(this._elements, val);
    }

    @Override
    public int indexOfWithOffset(Object value, int offset) {
        if (this.withDummy) {
            if (value == null || offset >= this._elements.length) {
                return -1;
            }
            int val = TermIntList.parse(String.valueOf(value));
            return Arrays.binarySearch(this._elements, offset, this._elements.length, val);
        }
        int val = TermIntList.parse(String.valueOf(value));
        return Arrays.binarySearch(this._elements, offset, this._elements.length, val);
    }

    public int indexOfWithOffset(Integer value, int offset) {
        if (this.withDummy) {
            if (value == null || offset >= this._elements.length) {
                return -1;
            }
            return Arrays.binarySearch(this._elements, offset, this._elements.length, value);
        }
        return Arrays.binarySearch(this._elements, offset, this._elements.length, value);
    }

    public int indexOfWithOffset(int value, int offset) {
        if (this.withDummy) {
            if (offset >= this._elements.length) {
                return -1;
            }
            return Arrays.binarySearch(this._elements, offset, this._elements.length, value);
        }
        return Arrays.binarySearch(this._elements, offset, this._elements.length, value);
    }

    @Override
    public int indexOfWithType(Integer val) {
        if (this.withDummy) {
            if (val == null) {
                return -1;
            }
            return Arrays.binarySearch(this._elements, 1, this._elements.length, val);
        }
        return Arrays.binarySearch(this._elements, val);
    }

    @Override
    public int indexOfWithType(int val) {
        if (this.withDummy) {
            return Arrays.binarySearch(this._elements, 1, this._elements.length, val);
        }
        return Arrays.binarySearch(this._elements, val);
    }

    @Override
    public void seal() {
        int negativeIndexCheck;
        ((IntArrayList)this._innerList).trim();
        this._elements = ((IntArrayList)this._innerList).elements();
        int n = negativeIndexCheck = this.withDummy ? 1 : 0;
        if (this._elements.length > negativeIndexCheck && this._elements[negativeIndexCheck] < 0) {
            int endPosition = this.indexOfWithType(0);
            if (endPosition < 0) {
                endPosition = -1 * endPosition - 1;
            }
            for (int i = 0; i < (endPosition - negativeIndexCheck) / 2; ++i) {
                int tmp = this._elements[i + negativeIndexCheck];
                this._elements[i + negativeIndexCheck] = this._elements[endPosition - i - 1];
                this._elements[endPosition - i - 1] = tmp;
            }
        }
    }

    @Override
    protected Object parseString(String o) {
        return TermIntList.parse(o);
    }

    public boolean contains(int val) {
        if (this.withDummy) {
            return Arrays.binarySearch(this._elements, 1, this._elements.length, val) >= 0;
        }
        return Arrays.binarySearch(this._elements, val) >= 0;
    }

    @Override
    public boolean containsWithType(Integer val) {
        if (this.withDummy) {
            if (val == null) {
                return false;
            }
            return Arrays.binarySearch(this._elements, 1, this._elements.length, val) >= 0;
        }
        return Arrays.binarySearch(this._elements, val) >= 0;
    }

    @Override
    public boolean containsWithType(int val) {
        if (this.withDummy) {
            return Arrays.binarySearch(this._elements, 1, this._elements.length, val) >= 0;
        }
        return Arrays.binarySearch(this._elements, val) >= 0;
    }

    public int[] getElements() {
        return this._elements;
    }

    @Override
    public double getDoubleValue(int index) {
        return this._elements[index];
    }
}

