/*
 * Decompiled with CFR 0.152.
 */
package org.jamwiki;

import java.io.File;
import java.io.FileNotFoundException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jamwiki.model.WikiConfigurationObject;
import org.jamwiki.utils.Utilities;
import org.jamwiki.utils.WikiLogger;
import org.jamwiki.utils.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WikiConfiguration {
    private static final WikiLogger logger = WikiLogger.getLogger(WikiConfiguration.class.getName());
    private static WikiConfiguration instance = null;
    private List<WikiConfigurationObject> dataHandlers = null;
    private Map<String, String> editors = null;
    private List<WikiConfigurationObject> parsers = null;
    private List<String> pseudotopics = null;
    private List<WikiConfigurationObject> searchEngines = null;
    private Map<String, String> translations = null;
    public static final String JAMWIKI_CONFIGURATION_FILE = "jamwiki-configuration.xml";
    private static final String XML_CONFIGURATION_ROOT = "configuration";
    private static final String XML_DATA_HANDLER = "data-handler";
    private static final String XML_DATA_HANDLER_ROOT = "data-handlers";
    private static final String XML_EDITOR = "editor";
    private static final String XML_EDITOR_ROOT = "editors";
    private static final String XML_PARAM_CLASS = "class";
    private static final String XML_PARAM_KEY = "key";
    private static final String XML_PARAM_NAME = "name";
    private static final String XML_PARAM_STATE = "state";
    private static final String XML_PARSER = "parser";
    private static final String XML_PARSER_ROOT = "parsers";
    private static final String XML_PSEUDOTOPIC = "pseudotopic";
    private static final String XML_PSEUDOTOPIC_ROOT = "pseudotopics";
    private static final String XML_SEARCH_ENGINE = "search-engine";
    private static final String XML_SEARCH_ENGINE_ROOT = "search-engines";
    private static final String XML_TRANSLATION = "translation";
    private static final String XML_TRANSLATION_ROOT = "translations";

    private WikiConfiguration() {
        this.initialize();
    }

    public static WikiConfiguration getInstance() {
        if (instance == null) {
            instance = new WikiConfiguration();
        }
        return instance;
    }

    public List<WikiConfigurationObject> getDataHandlers() {
        return this.dataHandlers;
    }

    public Map<String, String> getEditors() {
        return this.editors;
    }

    public List<WikiConfigurationObject> getParsers() {
        return this.parsers;
    }

    public List<String> getPseudotopics() {
        return this.pseudotopics;
    }

    public List<WikiConfigurationObject> getSearchEngines() {
        return this.searchEngines;
    }

    public Map<String, String> getTranslations() {
        return this.translations;
    }

    private void initialize() {
        this.dataHandlers = new ArrayList<WikiConfigurationObject>();
        this.editors = new LinkedHashMap<String, String>();
        this.parsers = new ArrayList<WikiConfigurationObject>();
        this.pseudotopics = new ArrayList<String>();
        this.searchEngines = new ArrayList<WikiConfigurationObject>();
        this.translations = new LinkedHashMap<String, String>();
        File file = null;
        Document document = null;
        try {
            file = Utilities.getClassLoaderFile(JAMWIKI_CONFIGURATION_FILE);
            document = XMLUtil.parseXML(file, false);
        }
        catch (ParseException e) {
            throw new IllegalStateException("Unable to parse configuration file jamwiki-configuration.xml", e);
        }
        catch (FileNotFoundException e) {
            throw new IllegalStateException("Unable to find configuration file jamwiki-configuration.xml", e);
        }
        Node node = document.getElementsByTagName(XML_CONFIGURATION_ROOT).item(0);
        NodeList children = node.getChildNodes();
        Node child = null;
        for (int i = 0; i < children.getLength(); ++i) {
            child = children.item(i);
            if (child.getNodeName().equals(XML_PARSER_ROOT)) {
                this.parsers = this.parseConfigurationObjects(child, XML_PARSER);
                continue;
            }
            if (child.getNodeName().equals(XML_DATA_HANDLER_ROOT)) {
                this.dataHandlers = this.parseConfigurationObjects(child, XML_DATA_HANDLER);
                continue;
            }
            if (child.getNodeName().equals(XML_EDITOR_ROOT)) {
                this.parseMapNodes(child, this.editors, XML_EDITOR);
                continue;
            }
            if (child.getNodeName().equals(XML_SEARCH_ENGINE_ROOT)) {
                this.searchEngines = this.parseConfigurationObjects(child, XML_SEARCH_ENGINE);
                continue;
            }
            if (child.getNodeName().equals(XML_PSEUDOTOPIC_ROOT)) {
                this.parsePseudotopics(child);
                continue;
            }
            if (child.getNodeName().equals(XML_TRANSLATION_ROOT)) {
                this.parseMapNodes(child, this.translations, XML_TRANSLATION);
                continue;
            }
            this.logUnknownChild(node, child);
        }
        logger.info("Configuration values loaded from " + file.getPath());
    }

    private WikiConfigurationObject parseConfigurationObject(Node node) {
        WikiConfigurationObject configurationObject = new WikiConfigurationObject();
        NodeList children = node.getChildNodes();
        for (int j = 0; j < children.getLength(); ++j) {
            Node child = children.item(j);
            if (child.getNodeName().equals(XML_PARAM_CLASS)) {
                configurationObject.setClazz(XMLUtil.getTextContent(child));
                continue;
            }
            if (child.getNodeName().equals(XML_PARAM_KEY)) {
                configurationObject.setKey(XMLUtil.getTextContent(child));
                continue;
            }
            if (child.getNodeName().equals(XML_PARAM_NAME)) {
                configurationObject.setName(XMLUtil.getTextContent(child));
                continue;
            }
            if (child.getNodeName().equals(XML_PARAM_STATE)) {
                configurationObject.setState(XMLUtil.getTextContent(child));
                continue;
            }
            this.logUnknownChild(node, child);
        }
        return configurationObject;
    }

    private List<WikiConfigurationObject> parseConfigurationObjects(Node node, String name) {
        ArrayList<WikiConfigurationObject> results = new ArrayList<WikiConfigurationObject>();
        NodeList children = node.getChildNodes();
        for (int j = 0; j < children.getLength(); ++j) {
            Node child = children.item(j);
            if (child.getNodeName().equals(name)) {
                results.add(this.parseConfigurationObject(child));
                continue;
            }
            this.logUnknownChild(node, child);
        }
        return results;
    }

    private void parseMapNode(Node node, Map<String, String> resultMap) {
        NodeList children = node.getChildNodes();
        String name = "";
        String key = "";
        for (int j = 0; j < children.getLength(); ++j) {
            Node child = children.item(j);
            if (child.getNodeName().equals(XML_PARAM_NAME)) {
                name = XMLUtil.getTextContent(child);
                continue;
            }
            if (child.getNodeName().equals(XML_PARAM_KEY)) {
                key = XMLUtil.getTextContent(child);
                continue;
            }
            this.logUnknownChild(node, child);
        }
        resultMap.put(key, name);
    }

    private void parseMapNodes(Node node, Map<String, String> resultsMap, String childNodeName) {
        NodeList children = node.getChildNodes();
        for (int j = 0; j < children.getLength(); ++j) {
            Node child = children.item(j);
            if (child.getNodeName().equals(childNodeName)) {
                this.parseMapNode(child, resultsMap);
                continue;
            }
            this.logUnknownChild(node, child);
        }
    }

    private void parsePseudotopic(Node node) {
        NodeList children = node.getChildNodes();
        for (int j = 0; j < children.getLength(); ++j) {
            Node child = children.item(j);
            if (child.getNodeName().equals(XML_PARAM_NAME)) {
                this.pseudotopics.add(XMLUtil.getTextContent(child));
                continue;
            }
            this.logUnknownChild(node, child);
        }
    }

    private void parsePseudotopics(Node node) {
        NodeList children = node.getChildNodes();
        for (int j = 0; j < children.getLength(); ++j) {
            Node child = children.item(j);
            if (child.getNodeName().equals(XML_PSEUDOTOPIC)) {
                this.parsePseudotopic(child);
                continue;
            }
            this.logUnknownChild(node, child);
        }
    }

    private void logUnknownChild(Node node, Node child) {
        logger.trace("Unknown child of " + node.getNodeName() + " tag: " + child.getNodeName() + " / " + child.getNodeValue());
    }
}

