/*
 * Decompiled with CFR 0.152.
 */
package org.jamwiki;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.jamwiki.utils.WikiLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WikiMessage {
    private static final WikiLogger logger = WikiLogger.getLogger(WikiMessage.class.getName());
    private final String key;
    private String[] params = null;

    public WikiMessage(String key) {
        this.key = key;
    }

    public WikiMessage(String key, String param1) {
        this.key = key;
        this.params = new String[1];
        this.params[0] = this.escapeHtml(param1);
    }

    public WikiMessage(String key, String param1, String param2) {
        this.key = key;
        this.params = new String[2];
        this.params[0] = this.escapeHtml(param1);
        this.params[1] = this.escapeHtml(param2);
    }

    public WikiMessage(String key, String[] params) {
        this.key = key;
        if (params != null) {
            this.params = new String[params.length];
            for (int i = 0; i < params.length; ++i) {
                this.params[i] = this.escapeHtml(params[i]);
            }
        }
    }

    public WikiMessage(String key, List<String> paramList) {
        this.key = key;
        if (paramList != null && !paramList.isEmpty()) {
            this.params = new String[paramList.size()];
            int i = 0;
            for (String param : paramList) {
                this.params[i++] = this.escapeHtml(param);
            }
        }
    }

    public String getKey() {
        return this.key;
    }

    public String[] getParams() {
        return this.params;
    }

    public int getParamsLength() {
        return this.params == null ? 0 : this.params.length;
    }

    public void setParamsWithoutEscaping(String[] params) {
        this.params = params;
    }

    private String escapeHtml(String param) {
        param = StringUtils.replace((String)param, (String)"&", (String)"&amp;");
        param = StringUtils.replace((String)param, (String)"<", (String)"&lt;");
        param = StringUtils.replace((String)param, (String)">", (String)"&gt;");
        param = StringUtils.replace((String)param, (String)"\"", (String)"&quot;");
        return param;
    }

    public void replaceParameter(int index, String parameter) {
        if (this.params == null || this.params.length <= index) {
            throw new IllegalArgumentException("Attempt to replace index " + index + " for an array that has " + (this.params == null ? "0" : Integer.valueOf(this.params.length)) + " parameters");
        }
        this.params[index] = this.escapeHtml(parameter);
    }

    public String toString() {
        String result = this.key;
        if (this.params != null) {
            for (String param : this.params) {
                result = result + " | " + param;
            }
        }
        return result;
    }
}

