/*
 * Decompiled with CFR 0.152.
 */
package org.jamwiki.parser.jflex;

import org.apache.commons.lang.StringUtils;
import org.jamwiki.parser.ParserException;
import org.jamwiki.parser.ParserInput;
import org.jamwiki.parser.ParserOutput;
import org.jamwiki.parser.jflex.JFlexLexer;
import org.jamwiki.parser.jflex.JFlexParserTag;
import org.jamwiki.parser.jflex.JFlexParserUtil;
import org.jamwiki.utils.LinkUtil;
import org.jamwiki.utils.Utilities;
import org.jamwiki.utils.WikiLogger;

public class HtmlLinkTag
implements JFlexParserTag {
    private static final WikiLogger logger = WikiLogger.getLogger(HtmlLinkTag.class.getName());
    private static final String HTML_LINK_CAPTION = "html-link-caption";

    private String buildHtmlLinkRaw(ParserInput parserInput, ParserOutput parserOutput, int mode, String raw) throws ParserException {
        String link = raw.trim();
        String punctuation = this.extractTrailingPunctuation(link);
        String text = null;
        int pos = link.indexOf(32);
        if (pos == -1) {
            pos = link.indexOf(9);
        }
        if (pos > 0) {
            text = link.substring(pos + 1).trim();
            link = link.substring(0, pos).trim();
            punctuation = "";
        } else {
            link = link.substring(0, link.length() - punctuation.length()).trim();
        }
        String html = this.linkHtml(parserInput, parserOutput, mode, link, text, punctuation);
        return html == null ? raw : html;
    }

    private String extractTrailingPunctuation(String text) {
        if (StringUtils.isBlank((String)text)) {
            return "";
        }
        StringBuilder buffer = new StringBuilder();
        for (int i = text.length() - 1; i >= 0; --i) {
            String closeChar;
            String openChar;
            int pos;
            char c = text.charAt(i);
            if (c == '.' || c == ';' || c == ',' || c == ':' || c == '(' || c == '[' || c == '{') {
                buffer.append(c);
                continue;
            }
            if (c != ')' && c != ']' && c != '}' || (pos = Utilities.findMatchingStartTag(text, i, openChar = c == ')' ? "(" : (c == ']' ? "[" : "{"), closeChar = String.valueOf(c))) != -1) break;
            buffer.append(c);
        }
        if (buffer.length() == 0) {
            return "";
        }
        buffer = buffer.reverse();
        return buffer.toString();
    }

    private String linkHtml(ParserInput parserInput, ParserOutput parserOutput, int mode, String link, String text, String punctuation) throws ParserException {
        if (link.toLowerCase().startsWith("mailto://")) {
            link = "mailto:" + link.substring("mailto://".length());
        }
        String caption = link;
        if (!StringUtils.isBlank((String)text)) {
            parserInput.getTempParams().put(HTML_LINK_CAPTION, true);
            caption = JFlexParserUtil.parseFragment(parserInput, parserOutput, text, mode);
            parserInput.getTempParams().remove(HTML_LINK_CAPTION);
        }
        String openTag = LinkUtil.buildHtmlLinkOpenTag(link, "externallink");
        return openTag + caption + "</a>" + punctuation;
    }

    public String parse(JFlexLexer lexer, String raw, Object ... args) throws ParserException {
        if (logger.isTraceEnabled()) {
            logger.trace("htmllink: " + raw + " (" + lexer.yystate() + ")");
        }
        if (raw == null || StringUtils.isBlank((String)raw)) {
            return raw;
        }
        Boolean linkCaption = (Boolean)lexer.getParserInput().getTempParams().get("link-caption");
        Boolean htmlLinkCaption = (Boolean)lexer.getParserInput().getTempParams().get(HTML_LINK_CAPTION);
        if (linkCaption != null && linkCaption.booleanValue() || htmlLinkCaption != null && htmlLinkCaption.booleanValue()) {
            return raw;
        }
        return this.buildHtmlLinkRaw(lexer.getParserInput(), lexer.getParserOutput(), lexer.getMode(), raw);
    }
}

