/*
 * Decompiled with CFR 0.152.
 */
package org.jamwiki.utils;

import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Properties;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.jamwiki.Environment;
import org.jamwiki.WikiException;
import org.jamwiki.utils.WikiLogger;

public class Encryption {
    private static final WikiLogger logger = WikiLogger.getLogger(Encryption.class.getName());
    public static final String DES_ALGORITHM = "DES";
    public static final String ENCRYPTION_KEY = "JAMWiki Key 12345";

    private Encryption() {
    }

    private static String encrypt64(byte[] unencryptedBytes) throws GeneralSecurityException, UnsupportedEncodingException {
        if (unencryptedBytes == null || unencryptedBytes.length == 0) {
            throw new IllegalArgumentException("Cannot encrypt a null or empty byte array");
        }
        SecretKey key = Encryption.createKey();
        Cipher cipher = Cipher.getInstance(key.getAlgorithm());
        cipher.init(1, key);
        byte[] encryptedBytes = Base64.encodeBase64((byte[])cipher.doFinal(unencryptedBytes));
        return Encryption.bytes2String(encryptedBytes);
    }

    public static String encrypt(String unencryptedString) {
        if (StringUtils.isBlank((String)unencryptedString)) {
            throw new IllegalArgumentException("Cannot encrypt a null or empty string");
        }
        MessageDigest md = null;
        String encryptionAlgorithm = Environment.getValue("encryption-algorithm");
        try {
            md = MessageDigest.getInstance(encryptionAlgorithm);
        }
        catch (NoSuchAlgorithmException e) {
            logger.warn("JDK does not support the " + encryptionAlgorithm + " encryption algorithm.  Weaker encryption will be attempted.");
        }
        if (md == null) {
            try {
                md = MessageDigest.getInstance("SHA-1");
            }
            catch (NoSuchAlgorithmException e) {
                throw new UnsupportedOperationException("JDK does not support the SHA-1 or SHA-512 encryption algorithms");
            }
            Environment.setValue("encryption-algorithm", "SHA-1");
            try {
                Environment.saveConfiguration();
            }
            catch (WikiException e) {
                logger.info("Failure while saving encryption algorithm property", e);
            }
        }
        try {
            md.update(unencryptedString.getBytes("UTF-8"));
            byte[] raw = md.digest();
            return Encryption.encrypt64(raw);
        }
        catch (GeneralSecurityException e) {
            logger.error("Encryption failure", e);
            throw new IllegalStateException("Failure while encrypting value");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Unsupporting encoding UTF-8");
        }
    }

    private static String decrypt64(String encryptedString) throws GeneralSecurityException, UnsupportedEncodingException {
        if (StringUtils.isBlank((String)encryptedString)) {
            return encryptedString;
        }
        SecretKey key = Encryption.createKey();
        Cipher cipher = Cipher.getInstance(key.getAlgorithm());
        cipher.init(2, key);
        byte[] encryptedBytes = encryptedString.getBytes("UTF8");
        byte[] unencryptedBytes = cipher.doFinal(Base64.decodeBase64((byte[])encryptedBytes));
        return Encryption.bytes2String(unencryptedBytes);
    }

    private static String bytes2String(byte[] bytes) {
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < bytes.length; ++i) {
            buffer.append((char)bytes[i]);
        }
        return buffer.toString();
    }

    private static SecretKey createKey() throws GeneralSecurityException, UnsupportedEncodingException {
        byte[] bytes = ENCRYPTION_KEY.getBytes("UTF8");
        DESKeySpec spec = new DESKeySpec(bytes);
        SecretKeyFactory keyFactory = SecretKeyFactory.getInstance(DES_ALGORITHM);
        return keyFactory.generateSecret(spec);
    }

    public static String getEncryptedProperty(String name, Properties props) {
        try {
            if (props != null) {
                return Encryption.decrypt64(props.getProperty(name));
            }
            return Encryption.decrypt64(Environment.getValue(name));
        }
        catch (GeneralSecurityException e) {
            String value = Environment.getValue(name);
            if (props != null || StringUtils.isBlank((String)value)) {
                logger.error("Encryption failure or no value available for property: " + name, e);
                throw new IllegalStateException("Failure while retrieving encrypted property: " + name);
            }
            logger.warn("Found unencrypted property file value: " + name + ".  Assuming that this value manually un-encrypted in the property file so re-encrypting and re-saving.");
            Encryption.setEncryptedProperty(name, value, null);
            try {
                Environment.saveConfiguration();
            }
            catch (WikiException ex) {
                logger.error("Failure while saving properties", ex);
                throw new IllegalStateException("Failure while saving properties");
            }
            return value;
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Unsupporting encoding UTF-8");
        }
    }

    public static void setEncryptedProperty(String name, String value, Properties props) {
        String encrypted = "";
        if (!StringUtils.isBlank((String)value)) {
            byte[] unencryptedBytes = null;
            try {
                unencryptedBytes = value.getBytes("UTF8");
                encrypted = Encryption.encrypt64(unencryptedBytes);
            }
            catch (GeneralSecurityException e) {
                logger.error("Encryption failure", e);
                throw new IllegalStateException("Failure while encrypting value");
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalStateException("Unsupporting encoding UTF-8");
            }
        }
        if (props == null) {
            Environment.setValue(name, encrypted);
        } else {
            props.setProperty(name, encrypted);
        }
    }
}

